/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.jmx;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.EventdConfigFactory;
import org.opennms.netmgt.eventd.EventConfigurationManager;
import org.opennms.netmgt.eventd.EventIpcManagerDefaultImpl;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.eventd.jmx.EventdMBean;

public class Eventd
implements EventdMBean {
    public static final String LOG4J_CATEGORY = "OpenNMS.Eventd";

    public void init() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance();
        org.opennms.netmgt.eventd.Eventd e = org.opennms.netmgt.eventd.Eventd.getInstance();
        try {
            EventdConfigFactory.reload();
            DataSourceFactory.init();
        }
        catch (FileNotFoundException ex) {
            log.error((Object)"Failed to load eventd configuration. File Not Found:", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (MarshalException ex) {
            log.error((Object)"Failed to load eventd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            log.error((Object)"Failed to load eventd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            log.error((Object)"Failed to load eventd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)"Failed to init database connection factory", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (SQLException ex) {
            log.error((Object)"Failed to init database connection factory", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (PropertyVetoException ex) {
            log.error((Object)"Failed to init database connection factory", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.EVENT_CONF_FILE_NAME);
            EventConfigurationManager.loadConfiguration(configFile.getPath());
        }
        catch (MarshalException ex) {
            log.error((Object)"Failed to load eventd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            log.error((Object)"Failed to load eventd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            log.error((Object)"Failed to load events configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        e.setConfigManager(EventdConfigFactory.getInstance());
        EventIpcManagerDefaultImpl ipcMgr = new EventIpcManagerDefaultImpl(EventdConfigFactory.getInstance());
        EventIpcManagerFactory.setIpcManager(ipcMgr);
        EventIpcManagerFactory.init();
        e.setDataSource(DataSourceFactory.getDataSource());
        e.setEventIpcManager(ipcMgr);
        e.init();
    }

    public void start() {
        org.opennms.netmgt.eventd.Eventd.getInstance().start();
    }

    public void stop() {
        org.opennms.netmgt.eventd.Eventd.getInstance().stop();
    }

    public int getStatus() {
        return org.opennms.netmgt.eventd.Eventd.getInstance().getStatus();
    }

    public String status() {
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    public String getStatusText() {
        return Fiber.STATUS_NAMES[this.getStatus()];
    }
}

