/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceivedEvent;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;

final class UdpUuidSender
implements Runnable {
    private List m_eventUuidsOut;
    private volatile boolean m_stop;
    private DatagramSocket m_dgSock;
    private Thread m_context = null;
    private List m_handlers;
    private String m_logPrefix;

    UdpUuidSender(DatagramSocket sock, List uuidsOut, List handlers) {
        this.m_dgSock = sock;
        this.m_stop = false;
        this.m_eventUuidsOut = uuidsOut;
        this.m_handlers = handlers;
        this.m_logPrefix = "OpenNMS.Eventd";
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stopping and joining thread context " + this.m_context.getName()));
            }
            this.m_context.interrupt();
            this.m_context.join();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Thread context stopped and joined");
            }
        }
    }

    boolean isAlive() {
        return this.m_context == null ? false : this.m_context.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_context = Thread.currentThread();
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isTracing = log.isDebugEnabled();
        if (this.m_stop) {
            if (isTracing) {
                log.debug((Object)"Stop flag set before thread started, exiting");
            }
            return;
        }
        if (isTracing) {
            log.debug((Object)"Thread context started");
        }
        ArrayList eventHold = new ArrayList(30);
        HashMap<UdpReceivedEvent, EventReceipt> receipts = new HashMap<UdpReceivedEvent, EventReceipt>();
        block16: while (!this.m_stop) {
            if (isTracing) {
                log.debug((Object)"Waiting on event receipts to be generated");
            }
            List list = this.m_eventUuidsOut;
            synchronized (list) {
                while (this.m_eventUuidsOut.isEmpty()) {
                    try {
                        this.m_eventUuidsOut.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (isTracing) {
                            log.debug((Object)"Thread context interrupted");
                        }
                        break block16;
                    }
                }
                eventHold.addAll(this.m_eventUuidsOut);
                this.m_eventUuidsOut.clear();
            }
            if (isTracing) {
                log.debug((Object)("Received " + eventHold.size() + " event receipts to process"));
                log.debug((Object)"Processing receipts");
            }
            for (UdpReceivedEvent udpReceivedEvent : eventHold) {
                for (Event e : udpReceivedEvent.getAckedEvents()) {
                    if (e.getUuid() == null) continue;
                    EventReceipt receipt = (EventReceipt)receipts.get(udpReceivedEvent);
                    if (receipt == null) {
                        receipt = new EventReceipt();
                        receipts.put(udpReceivedEvent, receipt);
                    }
                    receipt.addUuid(e.getUuid());
                }
            }
            eventHold.clear();
            if (isTracing) {
                log.debug((Object)"Event receipts sorted, transmitting receipts");
            }
            for (Map.Entry entry : receipts.entrySet()) {
                UdpReceivedEvent re = (UdpReceivedEvent)entry.getKey();
                EventReceipt receipt = (EventReceipt)entry.getValue();
                StringWriter writer = new StringWriter();
                try {
                    Marshaller.marshal((Object)receipt, (Writer)writer);
                }
                catch (ValidationException e) {
                    log.warn((Object)("Failed to build event receipt for agent " + re.getSender().getHostAddress() + ":" + re.getPort()), (Throwable)e);
                }
                catch (MarshalException e) {
                    log.warn((Object)("Failed to build event receipt for agent " + re.getSender().getHostAddress() + ":" + re.getPort()), (Throwable)e);
                }
                String xml = writer.getBuffer().toString();
                try {
                    byte[] xml_bytes = xml.getBytes("US-ASCII");
                    DatagramPacket pkt = new DatagramPacket(xml_bytes, xml_bytes.length, re.getSender(), re.getPort());
                    if (isTracing) {
                        log.debug((Object)("Transmitting receipt to destination " + re.getSender().getHostAddress() + ":" + re.getPort()));
                    }
                    this.m_dgSock.send(pkt);
                    List list2 = this.m_handlers;
                    synchronized (list2) {
                        Iterator i = this.m_handlers.iterator();
                        while (i.hasNext()) {
                            try {
                                ((EventHandler)i.next()).receiptSent(receipt);
                            }
                            catch (Throwable t) {
                                log.warn((Object)"Error processing event receipt", t);
                            }
                        }
                    }
                    if (!isTracing) continue;
                    log.debug((Object)"Receipt transmitted OK {");
                    log.debug((Object)xml);
                    log.debug((Object)"}");
                }
                catch (UnsupportedEncodingException e) {
                    log.warn((Object)"Failed to convert XML to byte array", (Throwable)e);
                }
                catch (IOException e) {
                    log.warn((Object)("Failed to send packet to host" + re.getSender().getHostAddress() + ":" + re.getPort()), (Throwable)e);
                }
            }
            receipts.clear();
        }
        if (isTracing) {
            log.debug((Object)"Context finished, returning");
        }
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }
}

