/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.net.DatagramSocket;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceivedEvent;
import org.opennms.netmgt.xml.event.Event;

final class UdpProcessor
implements Runnable {
    private Thread m_context = null;
    private List m_eventsIn;
    private List m_eventUuidsOut;
    private List m_handlers;
    private volatile boolean m_stop = false;
    private DatagramSocket m_dgSock;
    private String m_logPrefix;

    UdpProcessor(List handlers, List in, List out) {
        this.m_eventsIn = in;
        this.m_eventUuidsOut = out;
        this.m_handlers = handlers;
        this.m_logPrefix = "OpenNMS.Eventd";
    }

    boolean isAlive() {
        return this.m_context == null ? false : this.m_context.isAlive();
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stopping and joining thread context " + this.m_context.getName()));
            }
            this.m_context.interrupt();
            this.m_context.join();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Thread context stopped and joined");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_context = Thread.currentThread();
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isTracing = log.isDebugEnabled();
        if (this.m_stop) {
            if (isTracing) {
                log.debug((Object)"Stop flag set before thread started, exiting");
            }
            return;
        }
        if (isTracing) {
            log.debug((Object)"Thread context started");
        }
        block16: while (!this.m_stop) {
            if (isTracing) {
                log.debug((Object)"Waiting on a new datagram to arrive");
            }
            UdpReceivedEvent re = null;
            List list = this.m_eventsIn;
            synchronized (list) {
                while (this.m_eventsIn.isEmpty()) {
                    try {
                        this.m_eventsIn.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        if (isTracing) {
                            log.debug((Object)"Thread interrupted");
                        }
                        break block16;
                    }
                    if (!this.m_stop) continue;
                    if (isTracing) {
                        log.debug((Object)"Stop flag is set");
                    }
                    break block16;
                }
                re = (UdpReceivedEvent)this.m_eventsIn.remove(0);
            }
            if (isTracing) {
                log.debug((Object)"A new request has arrived");
            }
            Event[] events = null;
            try {
                if (isTracing) {
                    log.debug((Object)("Event from " + re.getSender().getHostAddress() + ":" + re.getPort()));
                    log.debug((Object)("Unmarshalling Event text {" + System.getProperty("line.separator") + re.getXmlData() + System.getProperty("line.separator") + "}"));
                }
                events = re.unmarshal().getEvents().getEvent();
            }
            catch (MarshalException e) {
                log.warn((Object)("Failed to unmarshal the event from " + re.getSender().getHostAddress() + ":" + re.getPort()), (Throwable)e);
                continue;
            }
            catch (ValidationException e) {
                log.warn((Object)("Failed to validate the event from " + re.getSender().getHostAddress() + ":" + re.getPort()), (Throwable)e);
                continue;
            }
            if (events == null || events.length == 0) {
                if (!isTracing) continue;
                log.debug((Object)"The event log record contained no events");
                continue;
            }
            if (isTracing) {
                log.debug((Object)("Processing " + events.length + " events"));
            }
            List list2 = this.m_handlers;
            synchronized (list2) {
                Iterator iter = this.m_handlers.iterator();
                while (iter.hasNext()) {
                    for (int ndx = 0; ndx < events.length; ++ndx) {
                        try {
                            if (!((EventHandler)iter.next()).processEvent(events[ndx])) continue;
                            re.ackEvent(events[ndx]);
                            continue;
                        }
                        catch (Throwable t) {
                            log.warn((Object)"Failed to process received UDP event, exception follows", t);
                        }
                    }
                }
            }
            if (isTracing) {
                log.debug((Object)"event processing complete, forwarding to receipt generator");
            }
            list2 = this.m_eventUuidsOut;
            synchronized (list2) {
                this.m_eventUuidsOut.add(re);
            }
        }
        if (isTracing) {
            log.debug((Object)"Context finished, returning");
        }
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }
}

