/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpRecordHandler;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;
import org.opennms.netmgt.xml.event.Log;

final class TcpStreamHandler
implements Runnable {
    private List m_handlers;
    private volatile boolean m_stop;
    private Fiber m_parent;
    private Socket m_connection;
    private Thread m_context;
    private int m_recsPerConn;

    TcpStreamHandler(Fiber parent, Socket sock, List handlers, int number) {
        this.m_parent = parent;
        this.m_connection = sock;
        this.m_handlers = handlers;
        this.m_stop = false;
        this.m_context = null;
        this.m_recsPerConn = number;
    }

    boolean isAlive() {
        boolean rc = false;
        if (this.m_context != null) {
            rc = this.m_context.isAlive();
        }
        return rc;
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            Category log = this.log();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Interrupting and joining the thread context " + this.m_context.getName()));
            }
            this.m_context.interrupt();
            this.m_context.join();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Context stopped and joined");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread tchunker;
        Thread thread = this.m_context = Thread.currentThread();
        synchronized (thread) {
            this.m_context.notifyAll();
        }
        boolean isTracing = this.log().isDebugEnabled();
        if (this.m_stop) {
            block67: {
                if (isTracing) {
                    this.log().debug((Object)"The stop flag was set prior to thread entry, closing connection");
                }
                try {
                    this.m_connection.close();
                }
                catch (IOException e) {
                    if (!isTracing) break block67;
                    this.log().error((Object)"An error occured while closing the connection", (Throwable)e);
                }
            }
            if (isTracing) {
                this.log().debug((Object)"Thread context exiting");
            }
            return;
        }
        InetAddress sender = this.m_connection.getInetAddress();
        if (isTracing) {
            this.log().debug((Object)("Event Log Stream Handler Started for " + sender));
        }
        LinkedList pipeXchange = new LinkedList();
        TcpRecordHandler chunker = new TcpRecordHandler(this.m_connection, pipeXchange);
        Thread thread2 = tchunker = new Thread((Runnable)chunker, "TCPRecord Chuncker[" + this.m_connection.getInetAddress().getHostAddress() + ":" + this.m_connection.getPort() + "]");
        synchronized (thread2) {
            tchunker.start();
            try {
                tchunker.wait();
            }
            catch (InterruptedException e) {
                this.log().error((Object)"The thread was interrupted", (Throwable)e);
            }
        }
        block45: while (!this.m_stop && this.m_parent.getStatus() != 3 && this.m_parent.getStatus() != 4 && this.m_recsPerConn != 0) {
            PipedInputStream pipeIn = null;
            LinkedList e = pipeXchange;
            synchronized (e) {
                while (pipeXchange.isEmpty()) {
                    if (chunker.isAlive()) {
                        try {
                            pipeXchange.wait(500L);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            this.log().error((Object)"The thread was interrupted", (Throwable)e2);
                        }
                    }
                    break block45;
                }
                Object o = pipeXchange.removeFirst();
                if (o instanceof Throwable) {
                    break;
                }
                try {
                    pipeIn = new PipedInputStream((PipedOutputStream)o);
                }
                catch (IOException e3) {
                    this.log().error((Object)"An I/O exception occured construction a record reader", (Throwable)e3);
                    break;
                }
                Object e3 = o;
                synchronized (e3) {
                    o.notify();
                }
            }
            this.m_recsPerConn -= this.m_recsPerConn > 0 ? 1 : 0;
            InputStreamReader in = new InputStreamReader(new BufferedInputStream(pipeIn));
            Log eLog = null;
            boolean doCleanup = false;
            try {
                eLog = (Log)Unmarshaller.unmarshal(Log.class, (Reader)in);
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)"Event record converted");
                }
            }
            catch (ValidationException e4) {
                this.log().error((Object)"The XML record is not valid", (Throwable)new ValidationException(e4.getMessage()));
                doCleanup = true;
            }
            catch (MarshalException e5) {
                this.log().error((Object)"Could not unmarshall the XML record", (Throwable)new MarshalException(e5.getMessage()));
                doCleanup = true;
            }
            if (doCleanup) {
                try {
                    while (in.read() != -1) {
                    }
                    continue;
                }
                catch (IOException e6) {
                    continue;
                }
            }
            Event[] events = eLog.getEvents().getEvent();
            Arrays.sort(events, new Comparator(){

                public int compare(Object o1, Object o2) {
                    boolean e2t;
                    Event e1 = (Event)o1;
                    Event e2 = (Event)o2;
                    boolean e1t = e1.getTime() != null;
                    boolean bl = e2t = e2.getTime() != null;
                    if (e1t && !e2t) {
                        return 1;
                    }
                    if (!e1t && e2t) {
                        return -1;
                    }
                    if (!e1t && !e2t) {
                        return 0;
                    }
                    DateFormat fmt = DateFormat.getDateTimeInstance(0, 0);
                    Date de1 = null;
                    try {
                        de1 = fmt.parse(e1.getTime());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    Date de2 = null;
                    try {
                        de2 = fmt.parse(e2.getTime());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (de1 != null && de2 != null) {
                        return (int)(de1.getTime() - de2.getTime());
                    }
                    if (de1 == null && de2 != null) {
                        return -1;
                    }
                    if (de1 != null && de2 == null) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (events != null && events.length != 0) {
                ArrayList<Event> okEvents = new ArrayList<Event>(events.length);
                List list = this.m_handlers;
                synchronized (list) {
                    for (EventHandler hdl : this.m_handlers) {
                        for (int ndx = 0; ndx < events.length; ++ndx) {
                            try {
                                if (isTracing) {
                                    this.log().debug((Object)("handling event, uei = " + events[ndx].getUei()));
                                }
                                if (!hdl.processEvent(events[ndx]) || okEvents.contains(events[ndx])) continue;
                                okEvents.add(events[ndx]);
                                continue;
                            }
                            catch (Throwable t) {
                                this.log().warn((Object)"An exception occured while processing an event", t);
                            }
                        }
                    }
                }
                boolean hasReceipt = false;
                EventReceipt receipt = new EventReceipt();
                for (Event e7 : okEvents) {
                    if (e7.getUuid() == null) continue;
                    receipt.addUuid(e7.getUuid());
                    hasReceipt = true;
                }
                if (!hasReceipt) continue;
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(this.m_connection.getOutputStream()));
                    Marshaller.marshal((Object)receipt, (Writer)writer);
                    writer.flush();
                    List t = this.m_handlers;
                    synchronized (t) {
                        for (EventHandler hdl : this.m_handlers) {
                            try {
                                hdl.receiptSent(receipt);
                            }
                            catch (Throwable t2) {
                                this.log().warn((Object)"An exception occured while processing an event receipt", t2);
                            }
                        }
                    }
                    if (!isTracing) continue;
                    this.log().debug((Object)"Sending Event Receipt {");
                    StringWriter swriter = new StringWriter();
                    try {
                        Marshaller.marshal((Object)receipt, (Writer)swriter);
                    }
                    catch (Exception e8) {
                        this.log().error((Object)"An error occured during marshalling", (Throwable)e8);
                    }
                    this.log().debug((Object)swriter.getBuffer().toString());
                    this.log().debug((Object)"}");
                    continue;
                }
                catch (ValidationException e9) {
                    this.log().warn((Object)"Failed to send event-receipt XML document", (Throwable)e9);
                    break;
                }
                catch (MarshalException e10) {
                    this.log().warn((Object)"Failed to send event-receipt XML document", (Throwable)e10);
                    break;
                }
                catch (IOException e11) {
                    this.log().warn((Object)"Failed to send event-receipt XML document", (Throwable)e11);
                    break;
                }
            }
            if (!isTracing) continue;
            this.log().debug((Object)"The agent sent an empty event stream");
        }
        try {
            if (isTracing) {
                this.log().debug((Object)"stopping record handler");
            }
            chunker.stop();
            if (isTracing) {
                this.log().debug((Object)"record handler stopped");
            }
        }
        catch (InterruptedException e) {
            this.log().warn((Object)"The thread was interrupted while trying to close the record handler", (Throwable)e);
        }
        try {
            if (isTracing) {
                this.log().debug((Object)"closing connnection");
            }
            this.m_connection.close();
            if (isTracing) {
                this.log().debug((Object)"connnection closed ");
            }
        }
        catch (IOException e) {
            this.log().warn((Object)"An I/O exception occured while closing the TCP/IP connection", (Throwable)e);
        }
        if (isTracing) {
            this.log().debug((Object)"Thread exiting");
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

