/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.EventdConfigManager;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.eventd.BroadcastEventProcessor;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.EventReceiver;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpEventReceiver;
import org.opennms.netmgt.eventd.adaptors.udp.UdpEventReceiver;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;

public final class Eventd
extends AbstractServiceDaemon
implements EventHandler {
    private static EventIpcManager m_eventIpcManager;
    public static final String LOG4J_CATEGORY = "OpenNMS.Eventd";
    private static final Eventd m_singleton;
    private static Map m_serviceTableMap;
    private EventReceiver m_tcpReceiver;
    private EventReceiver m_udpReceiver;
    private BroadcastEventProcessor m_receiver;
    private String m_address = null;
    private EventdConfigManager m_eFactory;
    private EventDao m_eventDao;
    private DataSource m_dataSource;

    public Eventd() {
        super(LOG4J_CATEGORY);
        try {
            this.m_address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhE) {
            Category log = ThreadCategory.getInstance(this.getClass());
            this.m_address = "localhost";
            log.warn((Object)"Could not lookup the host name for the local host machine, address set to localhost", (Throwable)uhE);
        }
    }

    protected void onStop() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"calling shutdown on tcp/udp listener threads");
        }
        this.m_tcpReceiver.stop();
        this.m_udpReceiver.stop();
        this.m_receiver.close();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"shutdown on tcp/udp listener threads returned");
        }
    }

    protected void onInit() {
        if (this.m_dataSource == null) {
            throw new IllegalStateException("dataSource not initialized");
        }
        Connection tempConn = null;
        try {
            tempConn = this.m_dataSource.getConnection();
            PreparedStatement stmt = tempConn.prepareStatement("SELECT serviceID, serviceName FROM service");
            ResultSet rset = stmt.executeQuery();
            while (rset.next()) {
                int svcid = rset.getInt(1);
                String svcname = rset.getString(2);
                m_serviceTableMap.put(svcname, new Integer(svcid));
            }
            rset.close();
            stmt.close();
        }
        catch (SQLException sqlE) {
            throw new UndeclaredThrowableException(sqlE);
        }
        finally {
            try {
                if (tempConn != null) {
                    tempConn.close();
                }
            }
            catch (SQLException sqlE) {
                this.log().warn((Object)"An error occured closing the database connection, ignoring", (Throwable)sqlE);
            }
        }
        this.m_tcpReceiver = null;
        this.m_udpReceiver = null;
        try {
            String timeoutReq = this.m_eFactory.getSocketSoTimeoutRequired();
            this.m_tcpReceiver = new TcpEventReceiver(this.m_eFactory.getTCPPort());
            this.m_udpReceiver = new UdpEventReceiver(this.m_eFactory.getUDPPort());
            this.m_tcpReceiver.addEventHandler(this);
            this.m_udpReceiver.addEventHandler(this);
        }
        catch (IOException e) {
            this.log().error((Object)"Error starting up the TCP/UDP threads of eventd", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    protected void onStart() {
        this.m_tcpReceiver.start();
        this.m_udpReceiver.start();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Listener threads started");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Eventd running");
        }
    }

    private void createBroadcastEventProcessor(EventIpcManager manager) {
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"start: Creating event broadcast event processor");
            }
            this.m_receiver = new BroadcastEventProcessor(manager);
        }
        catch (Throwable t) {
            if (this.log().isEnabledFor((Priority)Level.FATAL)) {
                this.log().fatal((Object)"start: Failed to initialized the broadcast event receiver", t);
            }
            throw new UndeclaredThrowableException(t);
        }
    }

    public String getLocalHostAddress() {
        return this.m_address;
    }

    public static synchronized int getServiceID(String svcname) {
        Integer i = (Integer)m_serviceTableMap.get(svcname);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public static synchronized void addServiceMapping(String svcname, int serviceid) {
        m_serviceTableMap.put(svcname, new Integer(serviceid));
    }

    public static Eventd getInstance() {
        return m_singleton;
    }

    public boolean processEvent(Event event) {
        m_eventIpcManager.sendNow(event);
        return true;
    }

    public void receiptSent(EventReceipt event) {
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConfigManager(EventdConfigManager configManager) {
        this.m_eFactory = configManager;
    }

    public EventIpcManager getEventIpcManager() {
        return m_eventIpcManager;
    }

    public void setEventIpcManager(EventIpcManager manager) {
        m_eventIpcManager = manager;
        this.createBroadcastEventProcessor(manager);
    }

    public void setEventDao(EventDao dao) {
        this.m_eventDao = dao;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }

    static {
        m_singleton = new Eventd();
        m_serviceTableMap = Collections.synchronizedMap(new HashMap());
    }
}

