/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.EventdConfigManager;
import org.opennms.netmgt.eventd.EventHandler;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.eventd.UndeclaredEventException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventIpcManagerDefaultImpl
implements EventIpcManager {
    private static EventdConfigManager m_eventdConfigMgr;
    private Map<String, List<EventListener>> m_ueiListeners;
    private List<EventListener> m_listeners;
    private Map<String, ListenerThread> m_listenerThreads;
    private RunnableConsumerThreadPool m_eventHandlerPool;
    private String m_getNextEventIdStr;
    private String m_getNextAlarmIdStr;

    public EventIpcManagerDefaultImpl() {
        this.init();
    }

    public EventIpcManagerDefaultImpl(EventdConfigManager configMgr) {
        this.setEventdConfigMgr(configMgr);
        this.init();
    }

    public synchronized void init() {
        if (m_eventdConfigMgr == null) {
            throw new IllegalStateException("eventd configuration manager not set");
        }
        this.m_ueiListeners = new HashMap<String, List<EventListener>>();
        this.m_listeners = new ArrayList<EventListener>();
        this.m_listenerThreads = new HashMap<String, ListenerThread>();
        int numReceivers = m_eventdConfigMgr.getReceivers();
        this.m_eventHandlerPool = new RunnableConsumerThreadPool("EventHandlerPool", 0.6f, 1.0f, numReceivers);
        this.m_eventHandlerPool.start();
        this.m_getNextEventIdStr = m_eventdConfigMgr.getGetNextEventID();
        this.m_getNextAlarmIdStr = m_eventdConfigMgr.getGetNextAlarmID();
    }

    @Override
    public synchronized void sendNow(Event event) {
        Events events = new Events();
        events.addEvent(event);
        Log eventLog = new Log();
        eventLog.setEvents(events);
        this.sendNow(eventLog);
    }

    @Override
    public synchronized void sendNow(Log eventLog) {
        try {
            this.m_eventHandlerPool.getRunQueue().add((Object)new EventHandler(eventLog, this.m_getNextEventIdStr, this.m_getNextAlarmIdStr));
        }
        catch (InterruptedException iE) {
            Category log = ThreadCategory.getInstance(this.getClass());
            log.warn((Object)"Unable to queue event log to the event handler pool queue", (Throwable)iE);
            throw new UndeclaredEventException(iE);
        }
        catch (FifoQueueException qE) {
            Category log = ThreadCategory.getInstance(this.getClass());
            log.warn((Object)"Unable to queue event log to the event handler pool queue", (Throwable)qE);
            throw new UndeclaredEventException(qE);
        }
    }

    @Override
    public synchronized void broadcastNow(Event event) {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event to be broadcasted: " + event.getUei()));
        }
        if (this.m_listeners.size() <= 0 && log.isDebugEnabled()) {
            log.debug((Object)"No listeners interested in all events");
        }
        for (EventListener listener : this.m_listeners) {
            ListenerThread listenerThr = this.m_listenerThreads.get(listener.getName());
            try {
                listenerThr.getQueue().add((Object)event);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Queued event to listener: " + listener.getName()));
            }
            catch (FifoQueueException fe) {
                log.error((Object)("Error queueing event " + event.getUei() + " to listener thread " + listener.getName()), (Throwable)fe);
            }
            catch (InterruptedException ie) {
                log.error((Object)("Error queueing event " + event.getUei() + " to listener thread " + listener.getName()), (Throwable)ie);
            }
        }
        String uei = event.getUei();
        if (uei == null) {
            return;
        }
        while (uei.length() > 0) {
            int i;
            List<EventListener> listenerList = this.m_ueiListeners.get(uei);
            if (listenerList != null) {
                for (EventListener listener : listenerList) {
                    ListenerThread listenerThread = this.m_listenerThreads.get(listener.getName());
                    try {
                        listenerThread.getQueue().add((Object)event);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Queued event " + uei + " to listener: " + listener.getName()));
                    }
                    catch (FifoQueueException fe) {
                        log.error((Object)("Error queueing event " + event.getUei() + " to listener thread " + listener.getName()), (Throwable)fe);
                    }
                    catch (InterruptedException ie) {
                        log.error((Object)("Error queueing event " + event.getUei() + " to listener thread " + listener.getName()), (Throwable)ie);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No listener interested in event: " + uei));
            }
            if ((i = uei.lastIndexOf("/", uei.length() - 2)) > 0) {
                uei = uei.substring(0, i + 1);
                continue;
            }
            uei = "";
            break;
        }
    }

    @Override
    public synchronized void addEventListener(EventListener listener) {
        ListenerThread listenerThread = this.m_listenerThreads.get(listener.getName());
        if (listenerThread == null) {
            FifoQueueImpl lq = new FifoQueueImpl();
            listenerThread = new ListenerThread(listener, (FifoQueue<Event>)lq);
            listenerThread.start();
            this.m_listenerThreads.put(listener.getName(), listenerThread);
        }
        this.m_listeners.add(listener);
        for (String key : this.m_ueiListeners.keySet()) {
            List<EventListener> listenersList = this.m_ueiListeners.get(key);
            if (listenersList == null) continue;
            listenersList.remove(listener);
        }
    }

    @Override
    public synchronized void addEventListener(EventListener listener, List<String> ueilist) {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding event listener " + listener.getName() + " for " + ueilist));
        }
        if (ueilist == null || ueilist.size() == 0) {
            return;
        }
        ListenerThread listenerThread = this.m_listenerThreads.get(listener.getName());
        if (listenerThread == null) {
            FifoQueueImpl lq = new FifoQueueImpl();
            listenerThread = new ListenerThread(listener, (FifoQueue<Event>)lq);
            listenerThread.start();
            this.m_listenerThreads.put(listener.getName(), listenerThread);
        }
        for (String uei : ueilist) {
            List<EventListener> listenersList = this.m_ueiListeners.get(uei);
            if (listenersList == null) {
                listenersList = new ArrayList<EventListener>();
                listenersList.add(listener);
                this.m_ueiListeners.put(uei, listenersList);
                continue;
            }
            if (listenersList.contains(listener)) continue;
            listenersList.add(listener);
        }
        this.m_listeners.remove(listener);
    }

    @Override
    public synchronized void addEventListener(EventListener listener, String uei) {
        List<EventListener> listenersList;
        if (uei == null) {
            return;
        }
        ListenerThread listenerThread = this.m_listenerThreads.get(listener.getName());
        if (listenerThread == null) {
            FifoQueueImpl lq = new FifoQueueImpl();
            listenerThread = new ListenerThread(listener, (FifoQueue<Event>)lq);
            listenerThread.start();
            this.m_listenerThreads.put(listener.getName(), listenerThread);
        }
        if ((listenersList = this.m_ueiListeners.get(uei)) == null) {
            listenersList = new ArrayList<EventListener>();
            listenersList.add(listener);
            this.m_ueiListeners.put(uei, listenersList);
        } else if (!listenersList.contains(listener)) {
            listenersList.add(listener);
        }
        this.m_listeners.remove(listener);
    }

    @Override
    public synchronized void removeEventListener(EventListener listener, List<String> ueilist) {
        if (ueilist == null || ueilist.size() == 0) {
            return;
        }
        for (String uei : ueilist) {
            List<EventListener> listenersList = this.m_ueiListeners.get(uei);
            if (listenersList == null) continue;
            listenersList.remove(listener);
        }
    }

    @Override
    public synchronized void removeEventListener(EventListener listener, String uei) {
        if (uei == null) {
            return;
        }
        List<EventListener> listenersList = this.m_ueiListeners.get(uei);
        if (listenersList != null) {
            listenersList.remove(listener);
        }
    }

    @Override
    public synchronized void removeEventListener(EventListener listener) {
        this.m_listeners.remove(listener);
        for (String key : this.m_ueiListeners.keySet()) {
            List<EventListener> listenersList = this.m_ueiListeners.get(key);
            if (listenersList == null) continue;
            listenersList.remove(listener);
        }
        ListenerThread listenerThread = this.m_listenerThreads.get(listener.getName());
        if (listenerThread != null) {
            listenerThread.stop();
            this.m_listenerThreads.remove(listener.getName());
        }
    }

    @Override
    public EventdConfigManager getEventdConfigMgr() {
        return m_eventdConfigMgr;
    }

    @Override
    public void setEventdConfigMgr(EventdConfigManager eventdConfigMgr) {
        m_eventdConfigMgr = eventdConfigMgr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerThread
    implements Runnable {
        private EventListener m_listener;
        private FifoQueue<Event> m_queue;
        private Thread m_delegateThread;
        private volatile boolean m_shutdown = false;

        ListenerThread(EventListener listener, FifoQueue<Event> lq) {
            this.m_listener = listener;
            this.m_queue = lq;
            this.m_delegateThread = new Thread((Runnable)this, listener.getName());
        }

        public FifoQueue<Event> getQueue() {
            return this.m_queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("In ListenerThread " + this.m_listener.getName() + " run"));
            }
            while (!this.m_shutdown) {
                Event event = null;
                try {
                    event = (Event)this.m_queue.remove(500L);
                    if (event == null) {
                        continue;
                    }
                }
                catch (InterruptedException ie) {
                    this.m_shutdown = true;
                    break;
                }
                catch (FifoQueueException fqE) {
                    this.m_shutdown = true;
                    break;
                }
                try {
                    if (event == null) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("run: calling onEvent on " + this.m_listener.getName() + " for event " + event.getUei() + " dbid " + event.getDbid() + " with time " + event.getTime()));
                    }
                    String log4jPrefix = ThreadCategory.getPrefix();
                    try {
                        this.m_listener.onEvent(event);
                    }
                    finally {
                        ThreadCategory.setPrefix((String)log4jPrefix);
                    }
                }
                catch (Throwable t) {
                    log.warn((Object)("run: an unexpected error occured during ListenerThread " + this.m_listener.getName() + " run"), t);
                }
            }
        }

        public void start() {
            this.m_shutdown = false;
            this.m_delegateThread.start();
        }

        public void stop() {
            this.m_shutdown = true;
        }
    }
}

