/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;

final class IPPollAddress {
    private InetAddress m_address;
    private long m_timeout;
    private int m_retries;

    IPPollAddress(String ipAddress, long timeout, int retries) throws UnknownHostException {
        InetAddress.getByName(ipAddress);
        this.m_address = InetAddress.getByName(ipAddress);
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    IPPollAddress(InetAddress ipAddress, long timeout, int retries) {
        this.m_address = ipAddress;
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    long getTimeout() {
        return this.m_timeout;
    }

    int getRetries() {
        return this.m_retries;
    }

    InetAddress getAddress() {
        return this.m_address;
    }

    public boolean equals(IPPollAddress pollAddr) {
        boolean bRet = false;
        if (pollAddr != null) {
            if (pollAddr == this) {
                bRet = true;
            } else if (pollAddr.getAddress().equals(this.m_address) && pollAddr.getRetries() == this.m_retries && pollAddr.getTimeout() == this.m_timeout) {
                bRet = true;
            }
        }
        return bRet;
    }
}

