/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opennms.core.utils.IPSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IPAddressRange
implements Iterable<InetAddress> {
    private long m_begin;
    private long m_end;

    IPAddressRange(String fromIP, String toIP) throws UnknownHostException {
        this.m_begin = IPSorter.convertToLong((byte[])InetAddress.getByName(fromIP).getAddress());
        this.m_end = IPSorter.convertToLong((byte[])InetAddress.getByName(toIP).getAddress());
        if (this.m_begin > this.m_end) {
            long a = this.m_end;
            this.m_end = this.m_begin;
            this.m_begin = a;
        }
    }

    IPAddressRange(InetAddress start, InetAddress end) {
        this.m_begin = IPSorter.convertToLong((byte[])start.getAddress());
        this.m_end = IPSorter.convertToLong((byte[])end.getAddress());
    }

    String getBeginAddrAsString() {
        return IPAddressRange.IPv4String(this.m_begin);
    }

    String getEndAddrAsString() {
        return IPAddressRange.IPv4String(this.m_end);
    }

    long getBeginAddrAsLong() {
        return this.m_begin;
    }

    long getEndAddrAsLong() {
        return this.m_end;
    }

    boolean contains(long ipAddr) {
        return ipAddr >= this.m_begin && ipAddr <= this.m_end;
    }

    boolean contains(InetAddress ipAddr) {
        return this.contains(IPSorter.convertToLong((byte[])ipAddr.getAddress()));
    }

    boolean contains(String ipAddr) throws UnknownHostException {
        return this.contains(IPAddressRange.convertToLong(InetAddress.getByName(ipAddr).getAddress()));
    }

    @Override
    public Iterator<InetAddress> iterator() {
        return new IPAddressRangeGenerator(this.m_begin, this.m_end);
    }

    Enumeration<InetAddress> elements() {
        return new IPAddressRangeGenerator(this.m_begin, this.m_end);
    }

    static String IPv4String(long address) {
        StringBuffer buf = new StringBuffer();
        buf.append((int)(address >>> 24 & 0xFFL)).append('.');
        buf.append((int)(address >>> 16 & 0xFFL)).append('.');
        buf.append((int)(address >>> 8 & 0xFFL)).append('.');
        buf.append((int)(address & 0xFFL));
        return buf.toString();
    }

    static String IPv4String(int address) {
        StringBuffer buf = new StringBuffer();
        buf.append(address >>> 24 & 0xFF).append('.');
        buf.append(address >>> 16 & 0xFF).append('.');
        buf.append(address >>> 8 & 0xFF).append('.');
        buf.append(address & 0xFF);
        return buf.toString();
    }

    static long byteToLong(byte b) {
        long r = b;
        if (r < 0L) {
            r += 256L;
        }
        return r;
    }

    public static long convertToLong(byte[] addr) {
        if (addr == null) {
            throw new IllegalArgumentException("The passed array must not be null");
        }
        long address = 0L;
        for (int i = 0; i < addr.length; ++i) {
            address <<= 8;
            address |= IPAddressRange.byteToLong(addr[i]);
        }
        return address;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IPAddressRangeGenerator
    implements Enumeration<InetAddress>,
    Iterator<InetAddress> {
        private long m_next;
        private final long m_end;

        static InetAddress make(long addr) {
            InetAddress naddr = null;
            try {
                naddr = InetAddress.getByName(IPAddressRange.IPv4String(addr));
            }
            catch (UnknownHostException uhE) {
                naddr = null;
            }
            return naddr;
        }

        IPAddressRangeGenerator(long start, long end) {
            if (start > end) {
                throw new IllegalArgumentException("start must be less than or equal to end");
            }
            this.m_next = start;
            this.m_end = end;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_next <= this.m_end;
        }

        @Override
        public InetAddress nextElement() {
            if (this.m_next > this.m_end) {
                throw new NoSuchElementException("End of Range");
            }
            return IPAddressRangeGenerator.make(this.m_next++);
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public InetAddress next() {
            return this.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove operation is not supported by the iterator");
        }
    }
}

