/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Owner
implements Comparable<Owner> {
    private String m_roleid;
    private String m_user;
    private int m_schedIndex;
    private int m_timeIndex;

    public Owner(String roleid, String user, int schedIndex) {
        this(roleid, user, schedIndex, -1);
    }

    public Owner(String roleid, String supervisor) {
        this(roleid, supervisor, -1, -1);
    }

    public Owner(Owner base, int timeIndex) {
        this(base.getRoleid(), base.getUser(), base.getSchedIndex(), timeIndex);
    }

    public Owner(String roleid, String user, int schedIndex, int timeIndex) {
        this.m_roleid = roleid;
        this.m_user = user;
        this.m_schedIndex = schedIndex;
        this.m_timeIndex = timeIndex;
    }

    public boolean isSupervisor() {
        return this.m_schedIndex == -1 && this.m_timeIndex == -1;
    }

    public String getRoleid() {
        return this.m_roleid;
    }

    public int getSchedIndex() {
        return this.m_schedIndex;
    }

    public int getTimeIndex() {
        return this.m_timeIndex;
    }

    public String getUser() {
        return this.m_user;
    }

    Owner addTimeIndex(int timeIndex) {
        return new Owner(this, timeIndex);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Owner) {
            Owner o = (Owner)obj;
            return this.m_user.equals(o.m_user);
        }
        return false;
    }

    public int hashCode() {
        return this.m_user.hashCode();
    }

    @Override
    public int compareTo(Owner o) {
        return this.m_user.compareTo(o.m_user);
    }

    public String toString() {
        return this.m_user;
    }
}

