/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.collectd.Attr;
import org.opennms.netmgt.config.BeanInfo;
import org.opennms.netmgt.config.collectd.Attrib;
import org.opennms.netmgt.config.collectd.JmxCollection;
import org.opennms.netmgt.config.collectd.JmxDatacollectionConfig;
import org.opennms.netmgt.config.collectd.Mbean;
import org.opennms.netmgt.config.collectd.Mbeans;

public final class JMXDataCollectionConfigFactory {
    private static JMXDataCollectionConfigFactory m_singleton = null;
    private JmxDatacollectionConfig m_config;
    private static boolean m_loaded = false;
    private Map m_collectionGroupMap;
    private Map m_collectionMap;

    private JMXDataCollectionConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        this.initialize(new InputStreamReader(cfgIn));
        ((InputStream)cfgIn).close();
    }

    public JMXDataCollectionConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.initialize(rdr);
    }

    private void initialize(Reader rdr) throws MarshalException, ValidationException {
        this.m_config = (JmxDatacollectionConfig)Unmarshaller.unmarshal(JmxDatacollectionConfig.class, (Reader)rdr);
        this.m_collectionMap = new HashMap();
        this.m_collectionGroupMap = new HashMap();
        List collections = this.m_config.getJmxCollectionCollection();
        for (JmxCollection collection : collections) {
            HashMap<String, Mbean> groupMap = new HashMap<String, Mbean>();
            Mbeans mbeans = collection.getMbeans();
            List groupList = mbeans.getMbeanCollection();
            for (Mbean mbean : groupList) {
                groupMap.put(mbean.getName(), mbean);
            }
            this.m_collectionGroupMap.put(collection.getName(), groupMap);
            this.m_collectionMap.put(collection.getName(), collection);
        }
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.JMX_DATA_COLLECTION_CONF_FILE_NAME);
            ThreadCategory.getInstance(JMXDataCollectionConfigFactory.class).debug((Object)("init: config file path: " + cfgFile.getPath()));
            m_singleton = new JMXDataCollectionConfigFactory(cfgFile.getPath());
        }
        catch (Exception e) {
            m_singleton = new JMXDataCollectionConfigFactory("/opt/opennms/rrd/response/jmx/");
        }
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        JMXDataCollectionConfigFactory.init();
    }

    public static synchronized JMXDataCollectionConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(JMXDataCollectionConfigFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public Map getAttributeMap(String cName, String aSysoid, String anAddress) {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMibObjectList: collection: " + cName + " sysoid: " + aSysoid + " address: " + anAddress));
        }
        if (aSysoid == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getMibObjectList: aSysoid parameter is NULL...");
            }
            return new HashMap();
        }
        JmxCollection collection = (JmxCollection)this.m_collectionMap.get(cName);
        if (collection == null) {
            return new HashMap();
        }
        HashMap map = new HashMap();
        Mbeans beans = collection.getMbeans();
        Enumeration en = beans.enumerateMbean();
        while (en.hasMoreElements()) {
            ArrayList<Attrib> list = new ArrayList<Attrib>();
            Mbean mbean = (Mbean)en.nextElement();
            Attrib[] attributes = mbean.getAttrib();
            for (int i = 0; i < attributes.length; ++i) {
                list.add(attributes[i]);
            }
            map.put(mbean.getObjectname(), list);
        }
        return map;
    }

    public HashMap getMBeanInfo(String cName) {
        HashMap<String, BeanInfo> map = new HashMap<String, BeanInfo>();
        JmxCollection collection = (JmxCollection)this.m_collectionMap.get(cName);
        Mbeans beans = collection.getMbeans();
        Enumeration en = beans.enumerateMbean();
        while (en.hasMoreElements()) {
            BeanInfo beanInfo = new BeanInfo();
            Mbean mbean = (Mbean)en.nextElement();
            beanInfo.setMbeanName(mbean.getName());
            beanInfo.setObjectName(mbean.getObjectname());
            beanInfo.setKeyField(mbean.getKeyfield());
            beanInfo.setExcludes(mbean.getExclude());
            beanInfo.setKeyAlias(mbean.getKeyAlias());
            int count = mbean.getAttribCount();
            String[] attribs = new String[count];
            Attrib[] attributes = mbean.getAttrib();
            for (int i = 0; i < attributes.length; ++i) {
                attribs[i] = attributes[i].getName();
            }
            beanInfo.setAttributes(attribs);
            map.put(mbean.getObjectname(), beanInfo);
        }
        return map;
    }

    public HashMap getMBeanInfo_save(String cName) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        JmxCollection collection = (JmxCollection)this.m_collectionMap.get(cName);
        Mbeans beans = collection.getMbeans();
        Enumeration en = beans.enumerateMbean();
        while (en.hasMoreElements()) {
            Mbean mbean = (Mbean)en.nextElement();
            int count = mbean.getAttribCount();
            String[] attribs = new String[count];
            Attrib[] attributes = mbean.getAttrib();
            for (int i = 0; i < attributes.length; ++i) {
                attribs[i] = attributes[i].getName();
            }
            map.put(mbean.getObjectname(), attribs);
        }
        return map;
    }

    static void processObjectList(List objectList, List mibObjectList) {
        for (Attrib mibObj : objectList) {
            Attr aMibObject = new Attr();
            aMibObject.setName(mibObj.getName());
            aMibObject.setAlias(mibObj.getAlias());
            aMibObject.setType(mibObj.getType());
            aMibObject.setMaxval(mibObj.getMaxval());
            aMibObject.setMinval(mibObj.getMinval());
            if (mibObjectList.contains(aMibObject)) continue;
            mibObjectList.add(aMibObject);
        }
    }

    public int getStep(String cName) {
        JmxCollection collection = (JmxCollection)this.m_collectionMap.get(cName);
        if (collection != null) {
            return collection.getRrd().getStep();
        }
        return -1;
    }

    public List getRRAList(String cName) {
        JmxCollection collection = (JmxCollection)this.m_collectionMap.get(cName);
        if (collection != null) {
            return collection.getRrd().getRraCollection();
        }
        return null;
    }

    public int getMaxVarsPerPdu(String cName) {
        JmxCollection collection = (JmxCollection)this.m_collectionMap.get(cName);
        if (collection != null) {
            return collection.getMaxVarsPerPdu();
        }
        return -1;
    }

    public String getRrdRepository() {
        return this.m_config.getRrdRepository();
    }
}

