/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.CatFactory;
import org.opennms.netmgt.config.categories.Categories;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.config.categories.Catinfo;

public final class CategoryFactory
implements CatFactory {
    private static CatFactory m_singleton = null;
    private Catinfo m_config;
    private static boolean m_loaded = false;

    private CategoryFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileReader reader = new FileReader(configFile);
        this.marshal(reader);
        ((Reader)reader).close();
    }

    public CategoryFactory(Reader reader) throws IOException, MarshalException, ValidationException {
        this.marshal(reader);
    }

    private void marshal(Reader reader) throws MarshalException, ValidationException {
        this.m_config = (Catinfo)Unmarshaller.unmarshal(Catinfo.class, (Reader)reader);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CATEGORIES_CONF_FILE_NAME);
        CategoryFactory.setInstance(new CategoryFactory(cfgFile.getPath()));
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        CategoryFactory.init();
    }

    public static synchronized CatFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void setInstance(CatFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public synchronized Catinfo getConfig() {
        return this.m_config;
    }

    public synchronized void addCategoryGroup(Categorygroup group) {
        this.m_config.addCategorygroup(group);
    }

    public synchronized boolean replaceCategoryGroup(Categorygroup group) {
        boolean replaced = false;
        String groupname = group.getName();
        int numCgs = this.m_config.getCategorygroupCount();
        for (int i = 0; i < numCgs; ++i) {
            Categorygroup oldCg = this.m_config.getCategorygroup(i);
            if (!oldCg.getName().equals(groupname)) continue;
            this.m_config.setCategorygroup(i, group);
            replaced = true;
            break;
        }
        return replaced;
    }

    public synchronized boolean deleteCategoryGroup(Categorygroup group) {
        return this.m_config.removeCategorygroup(group);
    }

    public synchronized boolean deleteCategoryGroup(String groupname) {
        boolean deleted = false;
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            if (!cg.getName().equals(groupname)) continue;
            deleted = this.m_config.removeCategorygroup(cg);
            break;
        }
        return deleted;
    }

    public synchronized boolean addCategory(String groupname, Category cat) {
        boolean added = false;
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            if (!cg.getName().equals(groupname)) continue;
            Categories cats = cg.getCategories();
            cats.addCategory(cat);
            added = true;
            break;
        }
        return added;
    }

    public synchronized boolean replaceCategory(String groupname, Category cat) {
        boolean replaced = false;
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        block0: while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            if (!cg.getName().equals(groupname)) continue;
            String catlabel = cat.getLabel();
            Categories cats = cg.getCategories();
            int numCats = cats.getCategoryCount();
            for (int i = 0; i < numCats; ++i) {
                Category oldCat = cats.getCategory(i);
                if (!oldCat.getLabel().equals(catlabel)) continue;
                cats.setCategory(i, cat);
                replaced = true;
                continue block0;
            }
        }
        return replaced;
    }

    public synchronized boolean deleteCategory(String groupname, Category cat) {
        boolean deleted = false;
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            if (!cg.getName().equals(groupname)) continue;
            Categories cats = cg.getCategories();
            cats.removeCategory(cat);
            deleted = true;
            break;
        }
        return deleted;
    }

    public synchronized boolean deleteCategory(String groupname, String catlabel) {
        boolean deleted = false;
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        block0: while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            if (!cg.getName().equals(groupname)) continue;
            Categories cats = cg.getCategories();
            Enumeration enumCat = cats.enumerateCategory();
            while (enumCat.hasMoreElements()) {
                Category cat = (Category)enumCat.nextElement();
                if (!cat.getLabel().equals(catlabel)) continue;
                cats.removeCategory(cat);
                deleted = true;
                continue block0;
            }
        }
        return deleted;
    }

    public synchronized Category getCategory(String name) {
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            Categories cats = cg.getCategories();
            Enumeration enumCat = cats.enumerateCategory();
            while (enumCat.hasMoreElements()) {
                Category cat = (Category)enumCat.nextElement();
                if (!cat.getLabel().equals(name)) continue;
                return cat;
            }
        }
        return null;
    }

    public synchronized double getNormal(String catlabel) {
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            Categories cats = cg.getCategories();
            Enumeration enumCat = cats.enumerateCategory();
            while (enumCat.hasMoreElements()) {
                Category cat = (Category)enumCat.nextElement();
                if (!cat.getLabel().equals(catlabel)) continue;
                return cat.getNormal();
            }
        }
        return -1.0;
    }

    public synchronized double getWarning(String catlabel) {
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            Categories cats = cg.getCategories();
            Enumeration enumCat = cats.enumerateCategory();
            while (enumCat.hasMoreElements()) {
                Category cat = (Category)enumCat.nextElement();
                if (!cat.getLabel().equals(catlabel)) continue;
                return cat.getWarning();
            }
        }
        return -1.0;
    }

    public synchronized String[] getServices(String catlabel) {
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            Categories cats = cg.getCategories();
            Enumeration enumCat = cats.enumerateCategory();
            while (enumCat.hasMoreElements()) {
                Category cat = (Category)enumCat.nextElement();
                if (!cat.getLabel().equals(catlabel)) continue;
                return cat.getService();
            }
        }
        return null;
    }

    public synchronized String getRule(String catlabel) {
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            Categories cats = cg.getCategories();
            Enumeration enumCat = cats.enumerateCategory();
            while (enumCat.hasMoreElements()) {
                Category cat = (Category)enumCat.nextElement();
                if (!cat.getLabel().equals(catlabel)) continue;
                return cat.getRule();
            }
        }
        return null;
    }

    public synchronized String getEffectiveRule(String catlabel) {
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            Categories cats = cg.getCategories();
            Enumeration enumCat = cats.enumerateCategory();
            while (enumCat.hasMoreElements()) {
                Category cat = (Category)enumCat.nextElement();
                if (!cat.getLabel().equals(catlabel)) continue;
                String catRule = "(" + cg.getCommon().getRule() + ") & (" + cat.getRule() + ")";
                return catRule;
            }
        }
        return null;
    }
}

