/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.PersistOperationBuilder;
import org.opennms.netmgt.collectd.ResourceIdentifier;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.NSClientDataCollectionConfigFactory;
import org.opennms.netmgt.config.NSClientPeerFactory;
import org.opennms.netmgt.config.nsclient.Attrib;
import org.opennms.netmgt.config.nsclient.NsclientCollection;
import org.opennms.netmgt.config.nsclient.Wpm;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.poller.nsclient.NSClientAgentConfig;
import org.opennms.netmgt.poller.nsclient.NsclientCheckParams;
import org.opennms.netmgt.poller.nsclient.NsclientException;
import org.opennms.netmgt.poller.nsclient.NsclientManager;
import org.opennms.netmgt.poller.nsclient.NsclientPacket;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.utils.EventProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSClientCollector
implements ServiceCollector {
    private final HashMap<Integer, NSClientAgentState> m_scheduledNodes = new HashMap();

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public int collect(CollectionAgent agent, EventProxy eproxy, Map<String, String> parameters) {
        String collectionName = parameters.get("nsclient-collection");
        final CollectionAgent theAgent = agent;
        NsclientCollection collection = NSClientDataCollectionConfigFactory.getInstance().getNSClientCollection(collectionName);
        NSClientAgentState agentState = this.m_scheduledNodes.get(agent.getNodeId());
        for (Wpm wpm : collection.getWpms().getWpm()) {
            if (agentState.shouldCheckAvailability(wpm.getName(), wpm.getRecheckInterval())) {
                this.log().debug((Object)("Checking availability of group " + wpm.getName()));
                NsclientManager manager = null;
                try {
                    manager = agentState.getManager();
                    manager.init();
                    NsclientCheckParams params = new NsclientCheckParams(wpm.getKeyvalue());
                    NsclientPacket result = manager.processCheckCommand("8", params);
                    manager.close();
                    boolean isAvailable = result.getResultCode() == 0;
                    agentState.setGroupIsAvailable(wpm.getName(), isAvailable);
                }
                catch (NsclientException e) {
                    throw new NSClientCollectorException("Error checking group (" + wpm.getName() + ") availability", e);
                }
                finally {
                    if (manager != null) {
                        manager.close();
                    }
                }
            }
            if (!agentState.groupIsAvailable(wpm.getName())) continue;
            RrdRepository rrdRepository = NSClientDataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
            ResourceIdentifier resource = new ResourceIdentifier(){

                public String getOwnerName() {
                    return theAgent.getHostAddress();
                }

                public File getResourceDir(RrdRepository repository) {
                    return new File(repository.getRrdBaseDir(), Integer.toString(theAgent.getNodeId()));
                }
            };
            try {
                NsclientManager manager = agentState.getManager();
                manager.init();
                for (Attrib attrib : wpm.getAttrib()) {
                    NsclientPacket result = null;
                    try {
                        NsclientCheckParams params = new NsclientCheckParams(attrib.getName());
                        result = manager.processCheckCommand("8", params);
                    }
                    catch (NsclientException e) {
                        this.log().info((Object)("unable to collect params for attribute '" + attrib.getName() + "'"), (Throwable)e);
                    }
                    if (result == null) continue;
                    if (result.getResultCode() != 0) {
                        this.log().info((Object)("not writing parameters for attribute '" + attrib.getName() + "', state is not 'OK'"));
                        continue;
                    }
                    NSClientCollectionAttribute attribute = new NSClientCollectionAttribute(attrib.getAlias(), attrib.getType(), result.getResponse());
                    PersistOperationBuilder builder = new PersistOperationBuilder(rrdRepository, resource, attribute.getName());
                    builder.declareAttribute(attribute);
                    this.log().debug((Object)("doCollection: setting attribute: " + attribute));
                    builder.setAttributeValue(attribute, attribute.getValue());
                    try {
                        builder.commit();
                    }
                    catch (RrdException e) {
                        throw new NSClientCollectorException("Error writing RRD", e);
                    }
                }
                manager.close();
            }
            catch (NsclientException e) {
                throw new NSClientCollectorException("Error collecting data", e);
            }
        }
        return 1;
    }

    @Override
    public void initialize(Map parameters) {
        this.log().debug((Object)"initialize: Initializing NSClientCollector.");
        this.m_scheduledNodes.clear();
        this.initNSClientPeerFactory();
        this.initNSClientCollectionConfig();
        this.initDatabaseConnectionFactory();
        this.initializeRrdRepository();
    }

    private void initNSClientPeerFactory() {
        this.log().debug((Object)"initialize: Initializing NSClientPeerFactory");
        try {
            NSClientPeerFactory.init();
        }
        catch (MarshalException e) {
            this.log().fatal((Object)"initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal((Object)"initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().fatal((Object)"initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initNSClientCollectionConfig() {
        this.log().debug((Object)("initialize: Initializing collector: " + this.getClass()));
        try {
            NSClientDataCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            this.log().fatal((Object)"initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal((Object)"initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (FileNotFoundException e) {
            this.log().fatal((Object)"initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().fatal((Object)"initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initializeRrdRepository() {
        this.log().debug((Object)"initializeRrdRepository: Initializing RRD repo from NSClientCollector...");
        this.initializeRrdDirs();
        this.initializeRrdInterface();
    }

    private void initializeRrdDirs() {
        File f = new File(NSClientDataCollectionConfigFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + DataCollectionConfigFactory.getInstance().getRrdPath());
        }
    }

    private void initializeRrdInterface() {
        try {
            RrdUtils.initialize();
        }
        catch (RrdException e) {
            this.log().error((Object)"initializeRrdInterface: Unable to initialize RrdUtils", (Throwable)e);
            throw new RuntimeException("Unable to initialize RrdUtils", e);
        }
    }

    private void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (IOException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: IOException getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Marshall Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Validation Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void initialize(CollectionAgent agent, Map parameters) {
        this.log().debug((Object)("initialize: Initializing NSClient collection for agent: " + agent));
        Integer scheduledNodeKey = new Integer(agent.getNodeId());
        NSClientAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            this.log().info((Object)("initialize: Not scheduling interface for NSClient collection: " + nodeState.getAddress()));
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(" for address: ");
            sb.append(nodeState.getAddress());
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent);
            this.log().debug((Object)sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        nodeState = new NSClientAgentState(agent.getInetAddress(), parameters);
        this.log().info((Object)("initialize: Scheduling interface for collection: " + nodeState.getAddress()));
        this.m_scheduledNodes.put(scheduledNodeKey, nodeState);
    }

    @Override
    public void release() {
        this.m_scheduledNodes.clear();
    }

    @Override
    public void release(CollectionAgent agent) {
        Integer scheduledNodeKey = new Integer(agent.getNodeId());
        NSClientAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            this.m_scheduledNodes.remove(scheduledNodeKey);
        }
    }

    private class NSClientGroupState {
        private boolean available = false;
        private Date lastChecked;

        public NSClientGroupState(boolean isAvailable) {
            this(isAvailable, new Date());
        }

        public NSClientGroupState(boolean isAvailable, Date lastChecked) {
            this.available = isAvailable;
            this.lastChecked = lastChecked;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public void setAvailable(boolean available) {
            this.available = available;
        }

        public Date getLastChecked() {
            return this.lastChecked;
        }

        public void setLastChecked(Date lastChecked) {
            this.lastChecked = lastChecked;
        }
    }

    private class NSClientAgentState {
        private NsclientManager m_manager;
        private NSClientAgentConfig m_agentConfig;
        private String m_address;
        private HashMap<String, NSClientGroupState> m_groupStates = new HashMap();

        public NSClientAgentState(InetAddress address, Map parameters) {
            this.m_address = address.getHostAddress();
            this.m_agentConfig = NSClientPeerFactory.getInstance().getAgentConfig(address);
            this.m_manager = new NsclientManager(this.m_address);
            this.m_manager.setPassword(this.m_agentConfig.getPassword());
            this.m_manager.setTimeout(this.m_agentConfig.getTimeout());
            this.m_manager.setPortNumber(this.m_agentConfig.getPort());
        }

        public String getAddress() {
            return this.m_address;
        }

        public NsclientManager getManager() {
            return this.m_manager;
        }

        public boolean groupIsAvailable(String groupName) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                return false;
            }
            return groupState.isAvailable();
        }

        public void setGroupIsAvailable(String groupName, boolean available) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                groupState = new NSClientGroupState(available);
            }
            groupState.setAvailable(available);
            this.m_groupStates.put(groupName, groupState);
        }

        public boolean shouldCheckAvailability(String groupName, int recheckInterval) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                return true;
            }
            Date lastchecked = groupState.getLastChecked();
            Date now = new Date();
            return now.getTime() - lastchecked.getTime() > (long)recheckInterval;
        }

        public void didCheckGroupAvailability(String groupName) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                NSClientCollector.this.log().warn((Object)"didCheckGroupAvailability called on a group without state - this is odd");
                return;
            }
            groupState.setLastChecked(new Date());
        }
    }

    public class NSClientCollectorException
    extends RuntimeException {
        public static final long serialVersionUID = 1L;

        NSClientCollectorException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    class NSClientCollectionAttribute
    implements AttributeDefinition {
        String m_alias;
        String m_type;
        String m_value;

        NSClientCollectionAttribute(String alias, String type, String value) {
            this.m_alias = alias;
            this.m_type = type;
            this.m_value = value;
        }

        public String getName() {
            return this.m_alias;
        }

        public String getType() {
            return this.m_type;
        }

        public String getValue() {
            return this.m_value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NSClientCollectionAttribute) {
                NSClientCollectionAttribute other = (NSClientCollectionAttribute)obj;
                return this.getName().equals(other.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("NSClientCollectionAttribute: ");
            buffer.append(this.getName());
            buffer.append(":");
            buffer.append(this.getType());
            buffer.append(":");
            buffer.append(this.getValue());
            return buffer.toString();
        }
    }
}

