/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionSetVisitor;
import org.opennms.netmgt.collectd.Attribute;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.PersistOperationBuilder;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.snmp.SnmpValue;

public class BasePersister
extends AbstractCollectionSetVisitor
implements Persister {
    private ServiceParameters m_params;
    private RrdRepository m_repository;
    private LinkedList<Boolean> m_stack = new LinkedList();
    private PersistOperationBuilder m_builder;

    public BasePersister() {
    }

    public BasePersister(ServiceParameters params) {
        this.m_params = params;
        this.m_repository = DataCollectionConfigFactory.getInstance().getRrdRepository(params.getCollectionName());
    }

    protected void commitBuilder() {
        String name = this.m_builder.getName();
        try {
            this.m_builder.commit();
            this.m_builder = null;
        }
        catch (RrdException e) {
            this.log().error((Object)("Unable to persist data for " + name + ": " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public void completeAttribute(Attribute attribute) {
        this.popShouldPersist();
    }

    public void completeGroup(AttributeGroup group) {
        this.popShouldPersist();
    }

    public void completeResource(CollectionResource resource) {
        this.popShouldPersist();
    }

    protected void createBuilder(CollectionResource resource, String name, AttributeType attributeType) {
        this.createBuilder(resource, name, Collections.singleton(attributeType));
    }

    protected void createBuilder(CollectionResource resource, String name, Set attributeTypes) {
        this.m_builder = new PersistOperationBuilder(this.getRepository(), resource, name);
        for (AttributeType attrType : attributeTypes) {
            if (!(attrType instanceof NumericAttributeType)) continue;
            this.m_builder.declareAttribute(attrType);
        }
    }

    public RrdRepository getRepository() {
        return this.m_repository;
    }

    public void setRepository(RrdRepository repository) {
        this.m_repository = repository;
    }

    protected Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void persistNumericAttribute(Attribute attribute) {
        this.log().debug((Object)("Persisting " + attribute));
        this.m_builder.setAttributeValue(attribute.getAttributeType(), attribute.getNumericValue());
    }

    public void persistStringAttribute(Attribute attribute) {
        String attrVal;
        this.log().debug((Object)("Persisting " + attribute));
        CollectionResource resource = attribute.getResource();
        SnmpValue value = attribute.getValue();
        File resourceDir = resource.getResourceDir(this.getRepository());
        String string = attrVal = value == null ? null : value.toString();
        if (attrVal == null) {
            this.log().info((Object)("No data collected for attribute " + attribute + ".  Skipping."));
            return;
        }
        String attrName = attribute.getName();
        try {
            ResourceTypeUtils.updateStringProperty((File)resourceDir, (String)attrVal, (String)attrName);
        }
        catch (IOException e) {
            this.log().error((Object)("Unable to save string attribute " + attribute + ": " + e), (Throwable)e);
        }
    }

    private boolean pop() {
        boolean top = this.top();
        this.m_stack.removeLast();
        return top;
    }

    protected boolean popShouldPersist() {
        return this.pop();
    }

    private void push(boolean b) {
        this.m_stack.addLast(b);
    }

    protected void pushShouldPersist(Attribute attribute) {
        this.pushShouldPersist(attribute.shouldPersist(this.m_params));
    }

    protected void pushShouldPersist(AttributeGroup group) {
        this.pushShouldPersist(group.shouldPersist(this.m_params));
    }

    private void pushShouldPersist(boolean shouldPersist) {
        this.push(this.top() && shouldPersist);
    }

    protected void pushShouldPersist(CollectionResource resource) {
        this.push(resource.shouldPersist(this.m_params));
    }

    protected boolean shouldPersist() {
        return this.top();
    }

    protected void storeAttribute(Attribute attribute) {
        if (this.shouldPersist()) {
            attribute.storeAttribute(this);
        }
    }

    private boolean top() {
        return this.m_stack.getLast();
    }

    public void visitAttribute(Attribute attribute) {
        this.pushShouldPersist(attribute);
        this.storeAttribute(attribute);
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
    }

    public void visitResource(CollectionResource resource) {
        this.log().info((Object)("Persisting data for resource " + resource));
        this.pushShouldPersist(resource);
    }
}

