/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.charts;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ExtendedCategoryAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.jdbc.JDBCCategoryDataset;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.charts.CustomSeriesColors;
import org.opennms.netmgt.config.ChartConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.charts.BarChart;
import org.opennms.netmgt.config.charts.ImageSize;
import org.opennms.netmgt.config.charts.Rgb;
import org.opennms.netmgt.config.charts.SeriesDef;
import org.opennms.netmgt.config.charts.SubTitle;
import org.opennms.netmgt.config.charts.Title;

public class ChartUtils {
    private static Category log() {
        return ThreadCategory.getInstance(ChartUtils.class);
    }

    public static JFreeChart getBarChart(String chartName) throws MarshalException, ValidationException, IOException, SQLException {
        BarChart chartConfig = null;
        chartConfig = ChartUtils.getBarChartConfigByName(chartName);
        if (chartConfig == null) {
            throw new IllegalArgumentException("getBarChart: Invalid chart name.");
        }
        DefaultCategoryDataset baseDataSet = ChartUtils.buildCategoryDataSet(chartConfig);
        JFreeChart barChart = ChartUtils.createBarChart(chartConfig, baseDataSet);
        ChartUtils.addSubTitles(chartConfig, barChart);
        String subLabelClass = chartConfig.getSubLabelClass();
        if (subLabelClass != null) {
            ChartUtils.addSubLabels(barChart, subLabelClass);
        }
        ChartUtils.customizeSeries(barChart, chartConfig);
        return barChart;
    }

    private static void addSubLabels(JFreeChart barChart, String subLabelClass) {
        CategoryPlot plot = barChart.getCategoryPlot();
        try {
            ExtendedCategoryAxis subLabels = (ExtendedCategoryAxis)Class.forName(subLabelClass).newInstance();
            List cats = plot.getCategories();
            for (int i = 0; i < cats.size(); ++i) {
                subLabels.addSubLabel((Comparable)cats.get(i), cats.get(i).toString());
            }
            plot.setDomainAxis((CategoryAxis)subLabels);
        }
        catch (InstantiationException e) {
            ChartUtils.log().error((Object)("getBarChart: Couldn't instantiate configured CategorySubLabels class: " + subLabelClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            ChartUtils.log().error((Object)("getBarChart: Couldn't instantiate configured CategorySubLabels class: " + subLabelClass), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            ChartUtils.log().error((Object)("getBarChart: Couldn't instantiate configured CategorySubLabels class: " + subLabelClass), (Throwable)e);
        }
    }

    private static void customizeSeries(JFreeChart barChart, BarChart chartConfig) {
        StandardCategoryItemLabelGenerator itemLabelGenerator = new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)new DecimalFormat("0"));
        SeriesDef[] seriesDefs = chartConfig.getSeriesDef();
        CustomSeriesColors seriesColors = null;
        if (chartConfig.getSeriesColorClass() != null) {
            try {
                seriesColors = (CustomSeriesColors)Class.forName(chartConfig.getSeriesColorClass()).newInstance();
            }
            catch (InstantiationException e) {
                ChartUtils.log().error((Object)("getBarChart: Couldn't instantiate configured CustomSeriesColors class: " + seriesColors), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                ChartUtils.log().error((Object)("getBarChart: Couldn't instantiate configured CustomSeriesColors class: " + seriesColors), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                ChartUtils.log().error((Object)("getBarChart: Couldn't instantiate configured CustomSeriesColors class: " + seriesColors), (Throwable)e);
            }
        }
        for (int i = 0; i < seriesDefs.length; ++i) {
            SeriesDef seriesDef = seriesDefs[i];
            Paint paint = Color.BLACK;
            if (seriesColors != null) {
                Comparable cat = (Comparable)((BarRenderer)barChart.getCategoryPlot().getRenderer()).getPlot().getCategories().get(i);
                paint = seriesColors.getPaint(cat);
            } else {
                Rgb rgb = seriesDef.getRgb();
                paint = new Color(rgb.getRed().getRgbColor(), rgb.getGreen().getRgbColor(), rgb.getBlue().getRgbColor());
            }
            ((BarRenderer)barChart.getCategoryPlot().getRenderer()).setSeriesPaint(i, paint);
            ((BarRenderer)barChart.getCategoryPlot().getRenderer()).setSeriesItemLabelsVisible(i, seriesDef.getUseLabels());
            ((BarRenderer)barChart.getCategoryPlot().getRenderer()).setSeriesItemLabelGenerator(i, (CategoryItemLabelGenerator)itemLabelGenerator);
        }
    }

    private static void addSubTitles(BarChart chartConfig, JFreeChart barChart) {
        for (SubTitle subTitle : chartConfig.getSubTitleCollection()) {
            Title title = subTitle.getTitle();
            String value = title.getValue();
            barChart.addSubtitle((org.jfree.chart.title.Title)new TextTitle(value));
        }
    }

    private static JFreeChart createBarChart(BarChart chartConfig, DefaultCategoryDataset baseDataSet) {
        PlotOrientation po = chartConfig.getPlotOrientation() == "horizontal" ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        JFreeChart barChart = ChartFactory.createBarChart((String)chartConfig.getTitle().getValue(), (String)chartConfig.getDomainAxisLabel(), (String)chartConfig.getRangeAxisLabel(), (CategoryDataset)baseDataSet, (PlotOrientation)po, (boolean)chartConfig.getShowLegend(), (boolean)chartConfig.getShowToolTips(), (boolean)chartConfig.getShowUrls());
        return barChart;
    }

    private static DefaultCategoryDataset buildCategoryDataSet(BarChart chartConfig) throws SQLException {
        DefaultCategoryDataset baseDataSet = new DefaultCategoryDataset();
        Connection conn = DataSourceFactory.getInstance().getConnection();
        for (SeriesDef def : chartConfig.getSeriesDefCollection()) {
            JDBCCategoryDataset dataSet = new JDBCCategoryDataset(conn, def.getJdbcDataSet().getSql());
            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                for (int j = 0; j < dataSet.getColumnCount(); ++j) {
                    baseDataSet.addValue(dataSet.getValue(i, j), (Comparable)((Object)def.getSeriesName()), dataSet.getColumnKey(j));
                }
            }
        }
        conn.close();
        return baseDataSet;
    }

    public static void getBarChart(String chartName, OutputStream out) throws MarshalException, ValidationException, IOException, SQLException {
        int vtPixels;
        int hzPixels;
        BarChart chartConfig = ChartUtils.getBarChartConfigByName(chartName);
        JFreeChart chart = ChartUtils.getBarChart(chartName);
        ImageSize imageSize = chartConfig.getImageSize();
        if (imageSize == null) {
            hzPixels = 400;
            vtPixels = 400;
        } else {
            hzPixels = imageSize.getHzSize().getPixels();
            vtPixels = imageSize.getVtSize().getPixels();
        }
        ChartUtilities.writeChartAsJPEG((OutputStream)out, (JFreeChart)chart, (int)hzPixels, (int)vtPixels);
    }

    public static void getBarChartPNG(String chartName, OutputStream out) throws MarshalException, ValidationException, IOException, SQLException {
        int vtPixels;
        int hzPixels;
        BarChart chartConfig = ChartUtils.getBarChartConfigByName(chartName);
        JFreeChart chart = ChartUtils.getBarChart(chartName);
        ImageSize imageSize = chartConfig.getImageSize();
        if (imageSize == null) {
            hzPixels = 400;
            vtPixels = 400;
        } else {
            hzPixels = imageSize.getHzSize().getPixels();
            vtPixels = imageSize.getVtSize().getPixels();
        }
        ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)hzPixels, (int)vtPixels, (boolean)false, (int)6);
    }

    public static byte[] getBarChartAsPNGByteArray(String chartName) throws MarshalException, ValidationException, IOException, SQLException {
        int vtPixels;
        int hzPixels;
        BarChart chartConfig = ChartUtils.getBarChartConfigByName(chartName);
        JFreeChart chart = ChartUtils.getBarChart(chartName);
        ImageSize imageSize = chartConfig.getImageSize();
        if (imageSize == null) {
            hzPixels = 400;
            vtPixels = 400;
        } else {
            hzPixels = imageSize.getHzSize().getPixels();
            vtPixels = imageSize.getVtSize().getPixels();
        }
        return ChartUtilities.encodeAsPNG((BufferedImage)chart.createBufferedImage(hzPixels, vtPixels));
    }

    public static BufferedImage getChartAsBufferedImage(String chartName) throws MarshalException, ValidationException, IOException, SQLException {
        int vtPixels;
        int hzPixels;
        BarChart chartConfig = ChartUtils.getBarChartConfigByName(chartName);
        JFreeChart chart = ChartUtils.getBarChart(chartName);
        ImageSize imageSize = chartConfig.getImageSize();
        if (imageSize == null) {
            hzPixels = 400;
            vtPixels = 400;
        } else {
            hzPixels = imageSize.getHzSize().getPixels();
            vtPixels = imageSize.getVtSize().getPixels();
        }
        return chart.createBufferedImage(hzPixels, vtPixels);
    }

    public static BarChart getBarChartConfigByName(String chartName) throws MarshalException, ValidationException, IOException {
        Iterator it = ChartUtils.getChartCollectionIterator();
        BarChart chart = null;
        while (it.hasNext()) {
            chart = (BarChart)it.next();
            if (!chart.getName().equals(chartName)) continue;
            return chart;
        }
        return null;
    }

    public static Iterator getChartCollectionIterator() throws IOException, MarshalException, ValidationException {
        return ChartConfigFactory.getInstance().getConfiguration().getBarChartCollection().iterator();
    }

    static {
        try {
            DataSourceFactory.init();
            ChartConfigFactory.init();
        }
        catch (MarshalException e) {
            ChartUtils.log().error((Object)("static initializer: Error marshalling chart configuration. " + (Object)((Object)e)));
        }
        catch (ValidationException e) {
            ChartUtils.log().error((Object)("static initializer: Error validating chart configuration. " + (Object)((Object)e)));
        }
        catch (FileNotFoundException e) {
            ChartUtils.log().error((Object)("static initializer: Error finding chart configuration. " + e));
        }
        catch (IOException e) {
            ChartUtils.log().error((Object)("static initializer: IO error while marshalling chart configuration file. " + e));
        }
        catch (ClassNotFoundException e) {
            ChartUtils.log().error((Object)("static initializer: Error initializing database connection factory. " + e));
        }
        catch (PropertyVetoException e) {
            ChartUtils.log().error((Object)("static initializer: Error initializing database connection factory. " + e));
        }
        catch (SQLException e) {
            ChartUtils.log().error((Object)("static initializer: Error initializing database connection factory. " + e));
        }
    }
}

