/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.IpAddrTableEntry;
import org.opennms.netmgt.capsd.snmp.SnmpTable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpAddrTable
extends SnmpTable<IpAddrTableEntry> {
    public IpAddrTable(InetAddress address) {
        super(address, "ipAddrTable", IpAddrTableEntry.ms_elemList);
    }

    @Override
    protected IpAddrTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IpAddrTableEntry();
    }

    public InetAddress[] getIfAddressAndMask(int ifIndex) {
        if (this.getEntries() == null) {
            return null;
        }
        for (IpAddrTableEntry entry : this.getEntries()) {
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            InetAddress[] pair = new InetAddress[]{entry.getIpAdEntAddr(), entry.getIpAdEntNetMask()};
            return pair;
        }
        return null;
    }

    public int getIfIndex(InetAddress address) {
        if (this.getEntries() == null) {
            return -1;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("getIfIndex: num ipAddrTable entries: " + this.getEntries().size()));
        }
        for (IpAddrTableEntry entry : this.getEntries()) {
            InetAddress ifAddr = entry.getIpAdEntAddr();
            if (ifAddr == null || !ifAddr.equals(address)) continue;
            Integer ndx = entry.getIpAdEntIfIndex();
            this.log().debug((Object)("getIfIndex: got a match for address " + address.getHostAddress() + " index: " + ndx));
            if (ndx == null) continue;
            return ndx;
        }
        this.log().debug((Object)("getIfIndex: no matching ipAddrTable entry for " + address.getHostAddress()));
        return -1;
    }

    protected final Category log() {
        return ThreadCategory.getInstance(IpAddrTable.class);
    }

    public List<InetAddress> getIpAddresses(int index) {
        if (index == -1 || this.getEntries() == null) {
            return null;
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (IpAddrTableEntry entry : this.getEntries()) {
            InetAddress ifAddr;
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || ndx != index || (ifAddr = entry.getIpAdEntAddr()) == null) continue;
            addresses.add(ifAddr);
        }
        return addresses;
    }

    public List<InetAddress> getIpAddresses() {
        if (this.getEntries() == null) {
            return null;
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (IpAddrTableEntry entry : this.getEntries()) {
            InetAddress ifAddr;
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || (ifAddr = entry.getIpAdEntAddr()) == null) continue;
            addresses.add(ifAddr);
        }
        return addresses;
    }
}

