/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;

final class KnownIPMgr {
    private static final String IP_LOAD_SQL = "SELECT ipAddr, nodeid, ipLastCapsdPoll FROM ipInterface";
    private static final String IP_UPDATE_TIME_SQL = "UPDATE ipInterface SET ipLastCapsdPoll = ? WHERE ipAddr = ? AND nodeid = ?";
    private static Map<InetAddress, Object> m_known = new TreeMap<InetAddress, Object>(AddrComparator.comparator);

    private KnownIPMgr() {
        throw new UnsupportedOperationException("Construction is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void dataSourceSync() throws SQLException {
        Category log = ThreadCategory.getInstance(KnownIPMgr.class);
        Connection c = null;
        try {
            c = DataSourceFactory.getInstance().getConnection();
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery(IP_LOAD_SQL);
            if (rs != null) {
                m_known.clear();
                while (rs.next()) {
                    String ipstr = rs.getString(1);
                    InetAddress addr = null;
                    try {
                        addr = InetAddress.getByName(ipstr);
                    }
                    catch (UnknownHostException uhE) {
                        log.warn((Object)("KnownIPMgr: failed to convert address " + ipstr), (Throwable)uhE);
                        continue;
                    }
                    int nid = rs.getInt(2);
                    Timestamp lastCheck = rs.getTimestamp(3);
                    m_known.put(addr, new IPInterface(addr, nid, lastCheck));
                }
                rs.close();
            }
            s.close();
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    static synchronized boolean isKnown(InetAddress addr) {
        return m_known.containsKey(addr);
    }

    static boolean isKnown(String ipAddr) throws UnknownHostException {
        return KnownIPMgr.isKnown(InetAddress.getByName(ipAddr));
    }

    static synchronized boolean addKnown(InetAddress addr) {
        return m_known.put(addr, new Date()) == null;
    }

    static boolean addKnown(String addr) throws UnknownHostException {
        return KnownIPMgr.addKnown(InetAddress.getByName(addr));
    }

    static synchronized InetAddress[] knownSet() {
        InetAddress[] set = new InetAddress[m_known.size()];
        return m_known.keySet().toArray(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AddrComparator
    implements Comparator<InetAddress> {
        static final AddrComparator comparator = new AddrComparator();

        AddrComparator() {
        }

        @Override
        public int compare(InetAddress a, InetAddress b) {
            int rc = 0;
            if (a != null && b == null) {
                rc = -1;
            } else if (a == null && b != null) {
                rc = 1;
            } else if (a != null) {
                byte[] ax = a.getAddress();
                byte[] bx = b.getAddress();
                for (int x = 0; x < ax.length && rc == 0; ++x) {
                    rc = (ax[x] < 0 ? 256 + ax[x] : ax[x]) - (bx[x] < 0 ? 256 + bx[x] : bx[x]);
                }
            }
            return rc;
        }
    }

    static final class IPInterface {
        private InetAddress m_interface;
        private Timestamp m_lastCheck;
        private int m_nodeid;

        IPInterface(InetAddress iface, int nodeid) {
            this.m_interface = iface;
            this.m_nodeid = nodeid;
            this.m_lastCheck = new Timestamp(new Date().getTime());
        }

        IPInterface(InetAddress iface, int nodeid, Timestamp date) {
            this.m_interface = iface;
            this.m_lastCheck = date;
            this.m_nodeid = nodeid;
        }

        IPInterface(InetAddress iface, int nodeid, String date) throws ParseException {
            this.m_interface = iface;
            this.m_nodeid = nodeid;
            Date tmpDate = EventConstants.parseToDate(date);
            this.m_lastCheck = new Timestamp(tmpDate.getTime());
        }

        InetAddress getAddress() {
            return this.m_interface;
        }

        int getNodeId() {
            return this.m_nodeid;
        }

        Timestamp getLastCheckTime() {
            return this.m_lastCheck;
        }

        void setLastCheckTime(Timestamp time) {
            this.m_lastCheck = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(Connection db) throws SQLException {
            PreparedStatement stmt = null;
            try {
                stmt = db.prepareStatement(KnownIPMgr.IP_UPDATE_TIME_SQL);
                stmt.setTimestamp(1, this.m_lastCheck);
                stmt.setString(2, this.m_interface.getHostAddress());
                stmt.setInt(3, this.m_nodeid);
                stmt.executeUpdate();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }
}

