/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.availability;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.opennms.report.availability.CalendarTable;
import org.opennms.report.availability.Day;
import org.opennms.report.availability.DaysOfWeek;
import org.opennms.report.availability.Week;

public class CalendarTableBuilder {
    public Day[] m_days;
    public CalendarTable m_calTable;
    private int m_firstDay;
    Calendar m_workingCalendar;
    Locale m_locale = Locale.getDefault();

    public CalendarTableBuilder(long endTime) {
        this.m_workingCalendar = Calendar.getInstance(this.m_locale);
        this.m_workingCalendar.setTimeInMillis(endTime);
        int month = this.m_workingCalendar.get(2);
        this.calendarTableInit(month);
    }

    public CalendarTableBuilder(int year, int month) {
        this.m_workingCalendar = Calendar.getInstance(this.m_locale);
        this.m_workingCalendar.set(2, month);
        this.m_workingCalendar.set(1, year);
        this.calendarTableInit(month);
    }

    private void calendarTableInit(int month) {
        int dayInLastMonth;
        this.m_calTable = new CalendarTable();
        this.m_days = new Day[42];
        String[] monthNames = new DateFormatSymbols(this.m_locale).getMonths();
        this.m_calTable.setMonth(monthNames[month]);
        String[] dayNames = new DateFormatSymbols(this.m_locale).getShortWeekdays();
        DaysOfWeek titleDays = new DaysOfWeek();
        int firstDayOfWeek = this.m_workingCalendar.getFirstDayOfWeek();
        for (int i = 0; i < 7; ++i) {
            int dayOfWeek = firstDayOfWeek + i < 8 ? firstDayOfWeek + i : 1;
            titleDays.addDayName(dayNames[dayOfWeek]);
        }
        this.m_calTable.setDaysOfWeek(titleDays);
        this.m_workingCalendar.set(5, 1);
        this.m_firstDay = this.m_workingCalendar.get(7) - firstDayOfWeek;
        if (this.m_firstDay < 0) {
            this.m_firstDay += 7;
        }
        for (dayInLastMonth = 0; dayInLastMonth < this.m_firstDay; ++dayInLastMonth) {
            this.m_days[dayInLastMonth] = new Day();
            this.m_days[dayInLastMonth].setVisible(false);
            this.m_days[dayInLastMonth].setPctValue(0.0);
        }
        this.m_workingCalendar.add(2, 1);
        Date firstDayInNextMonth = this.m_workingCalendar.getTime();
        this.m_workingCalendar.add(2, -1);
        Date day = this.m_workingCalendar.getTime();
        int dayInThisMonth = dayInLastMonth;
        int date = 1;
        while (day.before(firstDayInNextMonth)) {
            this.m_days[dayInThisMonth] = new Day();
            this.m_days[dayInThisMonth].setDate(date);
            this.m_days[dayInThisMonth].setVisible(true);
            this.m_days[dayInThisMonth].setPctValue(0.0);
            ++dayInThisMonth;
            ++date;
            this.m_workingCalendar.add(5, 1);
            day = this.m_workingCalendar.getTime();
        }
        for (int dayInNextMonth = dayInThisMonth; dayInNextMonth < 42; ++dayInNextMonth) {
            this.m_days[dayInNextMonth] = new Day();
            this.m_days[dayInNextMonth].setVisible(false);
            this.m_days[dayInNextMonth].setPctValue(0.0);
        }
    }

    public void print() {
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 7; ++x) {
                int index = x + 7 * y;
                int pDay = this.m_days[index].getDate();
                System.out.println("index: " + index + "visible: " + this.m_days[index].getVisible() + "date: " + this.m_days[index].getDate() + " value " + this.m_days[index].getPctValue());
            }
        }
    }

    public CalendarTable getTable() {
        Week week = null;
        for (int y = 0; y < 6; ++y) {
            week = new Week();
            this.m_calTable.addWeek(y, week);
            for (int x = 0; x < 7; ++x) {
                int index = x + 7 * y;
                week.addDay(x, this.m_days[index]);
            }
        }
        return this.m_calTable;
    }

    public void setPctValue(int sDate, double value) {
        this.m_days[sDate + this.m_firstDay - 1].setPctValue(value);
    }
}

