/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.availability;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.report.availability.CalendarTableBuilder;
import org.opennms.report.availability.CatSections;
import org.opennms.report.availability.Categories;
import org.opennms.report.availability.Category;
import org.opennms.report.availability.ClassicTable;
import org.opennms.report.availability.Col;
import org.opennms.report.availability.Report;
import org.opennms.report.availability.Row;
import org.opennms.report.availability.Rows;
import org.opennms.report.availability.Section;
import org.opennms.report.availability.Value;
import org.opennms.report.datablock.IfService;
import org.opennms.report.datablock.Interface;
import org.opennms.report.datablock.Node;
import org.opennms.report.datablock.OutageSince;
import org.opennms.report.datablock.OutageSvcTimesList;
import org.opennms.report.datablock.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailCalculations {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private static Report m_report = null;
    private long m_endTime;
    private Map<String, Map<IfService, OutageSvcTimesList>> m_services = null;
    private long m_endLastMonthTime;
    private int m_daysInLastMonth;
    private static final long ROLLING_WINDOW = 86400000L;
    private static final int THIRTY = 30;
    private static final int NMONTHS = 12;
    private List<Node> m_nodes;
    private List<String> m_monitoredServices;
    private int m_sectionIndex;

    public AvailCalculations(List<Node> nodes, long endTime, long lastMonthEndTime, List<String> monitoredServices, Report report, TreeMap<Double, List<String>> offenders, double warning, double normal, String comments, String name, String format, String monthFormat, int catIndex, int sectionIndex) {
        this.m_sectionIndex = sectionIndex;
        Category category = new Category();
        category.setWarning(warning);
        category.setNormal(normal);
        category.setCatComments(comments);
        category.setCatName(name);
        category.setCatIndex(catIndex);
        category.setNodeCount(nodes.size());
        int ipaddrCount = 0;
        int serviceCount = 0;
        for (Node tmpNode : nodes) {
            if (tmpNode == null) continue;
            ipaddrCount += tmpNode.getInterfaceCount();
            serviceCount += tmpNode.getServiceCount();
        }
        category.setIpaddrCount(ipaddrCount);
        category.setServiceCount(serviceCount);
        Categories categories = report.getCategories();
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Inside AvailCalculations using endTime " + endTime));
        }
        this.m_monitoredServices = monitoredServices;
        this.m_endLastMonthTime = lastMonthEndTime;
        this.m_daysInLastMonth = this.getDaysForMonth(this.m_endLastMonthTime);
        m_report = report;
        this.m_nodes = nodes;
        this.m_endTime = endTime;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Now computing last 12 months daily availability ");
        }
        String label = "The last 12 Months Availability";
        String descr = "The last 12 Months Availability";
        if (label == null || label.length() == 0) {
            label = "The last 12 Months Availability";
        }
        if (descr == null || descr.length() == 0) {
            descr = "The last 12 Months Availability";
        }
        CatSections catSections = new CatSections();
        this.lastNMonthsAvailability(12, this.m_endLastMonthTime, catSections, label, descr);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Computed lastNMonthsAvailability");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Now computing last months daily availability ");
        }
        label = "The last Months Daily Availability";
        descr = "Daily Average of svcs monitored and availability of svcs divided by the total svc minutes (last month)";
        if (label == null || label.length() == 0) {
            label = "The last Months Daily Availability";
        }
        if (descr == null || descr.length() == 0) {
            descr = "Daily Average of svcs monitored and availability of svcs divided by the total svc minutes (last month)";
        }
        if (monthFormat.equalsIgnoreCase("calendar")) {
            this.lastCalMoDailyAvailability(this.m_daysInLastMonth, this.m_endLastMonthTime, catSections, label, descr, "LastMonthsDailyAvailability");
        } else {
            this.lastMoDailyAvailability(this.m_daysInLastMonth, this.m_endLastMonthTime, catSections, label, descr, "LastMonthsDailyAvailability");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Computed lastNDaysDailyAvailability");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Now computing  month to date daily availability ");
        }
        label = "Month To Date Daily Availability";
        descr = "Daily Average of svc monitored and availability of svcs div by total svc minutes of month frm 1st till date";
        if (label == null || label.length() == 0) {
            label = "Month To Date Daily Availability";
        }
        if (descr == null || descr.length() == 0) {
            descr = "Daily Average of svc monitored and availability of svcs div by total svc minutes of month frm 1st till date";
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(this.m_endTime));
        int numDaysInMonth = calendar.get(5);
        if (monthFormat.equalsIgnoreCase("calendar")) {
            this.lastCalMTDDailyAvailability(numDaysInMonth, this.m_endTime, catSections, label, descr, "MonthToDateDailyAvailability");
        } else {
            this.lastMTDDailyAvailability(numDaysInMonth, this.m_endTime, catSections, label, descr, "MonthToDateDailyAvailability");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Computed lastNDaysDailyAvailability");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Now computing Last Months Top Offenders ");
        }
        label = "Last Months Top Offenders";
        descr = "This is the list of the worst available devices in the category for the last month";
        if (label == null || label.length() == 0) {
            label = "Last Months Top Offenders";
        }
        if (descr == null || descr.length() == 0) {
            descr = "This is the list of the worst available devices in the category for the last month";
        }
        this.lastMoTopNOffenders(offenders, catSections, label, descr);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Computed lastMoTopNOffenders ");
        }
        if (!format.equals("SVG")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Now computing LAST_30_DAYS_DAILY_LABEL ");
            }
            label = "The last 30 Days Daily Availability";
            descr = "Daily average of svcs and dvcs monitored and their availability divided by total mins for 30days";
            if (label == null || label.length() == 0) {
                label = "The last 30 Days Daily Availability";
            }
            if (descr == null || descr.length() == 0) {
                descr = "Daily average of svcs and dvcs monitored and their availability divided by total mins for 30days";
            }
            this.lastNDaysDailyAvailability(30, this.m_endTime, catSections, label, descr, "Last30DaysDailyAvailability");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Computed lastNDaysDailyAvailability");
            }
        }
        if (!format.equals("SVG")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Now computing LAST_30_DAYS_TOTAL_LABEL ");
            }
            label = "The last 30 Days Total Availability";
            descr = "Average of svcs monitored and availability of svcs divided by total svc minutes of the last 30 days";
            if (label == null || label.length() == 0) {
                label = "The last 30 Days Total Availability";
            }
            if (descr == null || descr.length() == 0) {
                descr = "Average of svcs monitored and availability of svcs divided by total svc minutes of the last 30 days";
            }
            this.lastNDaysTotalAvailability(30, this.m_endTime, catSections, label, descr);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Computed lastNDaysTotalAvailability");
            }
        }
        if (!format.equals("SVG")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Now computing LAST_MONTH_TOTAL_LABEL ");
            }
            label = "The last Months Total Availability";
            descr = "Average of svcs monitored and availability of svcs divided by the total svc minutes of the month";
            if (label == null || label.length() == 0) {
                label = "The last Months Total Availability";
            }
            if (descr == null || descr.length() == 0) {
                descr = "Average of svcs monitored and availability of svcs divided by the total svc minutes of the month";
            }
            this.lastMoTotalAvailability(this.m_daysInLastMonth, this.m_endLastMonthTime, catSections, label, descr);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Computed lastNDaysDailyAvailability");
            }
        }
        if (!format.equals("SVG")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Now computing LAST_MTD_TOTAL_LABEL ");
            }
            label = "Month To Date Total Availability";
            descr = "Average of svc monitored and availability of svcs dividedby total svc minutes of month frm 1st till date";
            if (label == null || label.length() == 0) {
                label = "Month To Date Total Availability";
            }
            if (descr == null || descr.length() == 0) {
                descr = "Average of svc monitored and availability of svcs dividedby total svc minutes of month frm 1st till date";
            }
            this.lastMoTotalAvailability(numDaysInMonth, this.m_endTime, catSections, label, descr);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Computed MTDTotalAvailability");
            }
        }
        this.m_services = new HashMap<String, Map<IfService, OutageSvcTimesList>>();
        for (Node node : nodes) {
            if (node == null) continue;
            for (Interface intf : node.getInterfaces()) {
                if (intf == null) continue;
                for (Service svc : intf.getServices()) {
                    OutageSvcTimesList outages;
                    if (svc == null || (outages = svc.getOutages()) == null) continue;
                    IfService ifservice = new IfService(node.getNodeID(), intf.getName(), -1, node.getName(), svc.getName());
                    Map<IfService, OutageSvcTimesList> svcOutages = this.m_services.get(svc.getName());
                    if (svcOutages == null) {
                        svcOutages = new HashMap<IfService, OutageSvcTimesList>();
                    }
                    svcOutages.put(ifservice, outages);
                    this.m_services.put(svc.getName(), svcOutages);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Services " + this.m_services));
        }
        this.m_nodes = null;
        if (!format.equals("SVG")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Now computing LAST_30_DAYS_SVC_AVAIL_LABEL ");
            }
            label = "The last 30 days Daily Service Availability";
            descr = "The last 30 days Daily Service Availability is the daily average of services";
            if (label == null || label.length() == 0) {
                label = "The last 30 days Daily Service Availability";
            }
            if (descr == null || descr.length() == 0) {
                descr = "The last 30 days Daily Service Availability is the daily average of services";
            }
            this.lastNDaysDailyServiceAvailability(30, this.m_endTime, catSections, label, descr);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Computed lastNDaysDailyServiceAvailability");
            }
        }
        if (!format.equals("SVG")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Now computing LAST_MONTH_SVC_AVAIL_LABE");
            }
            label = "The last Months Daily Service Availability";
            descr = "The last Months Daily Service Availability is the daily average of services and devices";
            if (label == null || label.length() == 0) {
                label = "The last Months Daily Service Availability";
            }
            if (descr == null || descr.length() == 0) {
                descr = "The last Months Daily Service Availability is the daily average of services and devices";
            }
            this.lastNDaysDailyServiceAvailability(this.m_daysInLastMonth, this.m_endLastMonthTime, catSections, label, descr);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Computed lastNDaysDailyServiceAvailability");
            }
        }
        if (!format.equals("SVG")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Now computing TOP20_SVC_OUTAGES_LABEL");
            }
            label = "Last Month Top Service Outages for";
            descr = "Last Month Top Service Outages for";
            if (label == null || label.length() == 0) {
                label = "Last Month Top Service Outages for ";
            }
            if (descr == null || descr.length() == 0) {
                descr = "Last Month Top Service Outages for ";
            }
            this.lastMonTopNServiceOutages(catSections, label, descr);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Computed lastMonTopNServiceOutages");
            }
        }
        this.m_services = null;
        category.addCatSections(catSections);
        categories.addCategory(category);
        m_report.setCategories(categories);
        report = m_report;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving AvailCalculations");
        }
    }

    public int getSectionIndex() {
        return this.m_sectionIndex;
    }

    private void lastMonTopNServiceOutages(CatSections catSections, String label, String descr) {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        TreeMap<Long, ArrayList<OutageSince>> treeMap = null;
        for (String service : this.m_services.keySet()) {
            treeMap = new TreeMap<Long, ArrayList<OutageSince>>();
            Map<IfService, OutageSvcTimesList> ifSvcOutageList = this.m_services.get(service);
            for (IfService ifservice : ifSvcOutageList.keySet()) {
                OutageSvcTimesList outageSvcList;
                if (ifservice == null || (outageSvcList = ifSvcOutageList.get(ifservice)) == null) continue;
                long rollingWindow = (long)this.m_daysInLastMonth * 86400000L;
                List<OutageSince> svcOutages = outageSvcList.getServiceOutages(ifservice.getNodeName(), this.m_endLastMonthTime, rollingWindow);
                for (OutageSince outageSince : svcOutages) {
                    if (outageSince == null) continue;
                    long outage = outageSince.getOutage() / 1000L;
                    ArrayList<OutageSince> tmpList = (ArrayList<OutageSince>)treeMap.get(new Long(outage));
                    if (tmpList == null) {
                        tmpList = new ArrayList<OutageSince>();
                    }
                    tmpList.add(outageSince);
                    treeMap.put(new Long(-1L * outage), tmpList);
                }
            }
            log.debug((Object)("Top 20 service outages from the list " + treeMap));
            int top20Count = 0;
            Rows rows = new Rows();
            block3: for (Long outage : treeMap.keySet()) {
                List list = (List)treeMap.get(outage);
                for (OutageSince outageSince : list) {
                    ++top20Count;
                    String nodeName = outageSince.getNodeName();
                    Value nodeValue = new Value();
                    nodeValue.setContent(nodeName);
                    nodeValue.setType("title");
                    Value value = new Value();
                    long outtime = outageSince.getOutage() / 1000L;
                    int hrs = new Long(outtime / 3600L).intValue();
                    int remain = new Long(outtime % 3600L).intValue();
                    int mins = remain / 60;
                    int secs = remain %= 60;
                    log.debug((Object)("Outage : " + outtime + " in mins " + hrs + " hrs " + mins + " mins " + secs + " secs "));
                    value.setContent(hrs + " hrs " + mins + " mins " + secs + " secs ");
                    value.setType("data");
                    Value datevalue = new Value();
                    SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
                    datevalue.setContent(fmt.format(new Date(outageSince.getOutTime())));
                    datevalue.setType("other");
                    Row row = new Row();
                    row.addValue(nodeValue);
                    row.addValue(value);
                    row.addValue(datevalue);
                    rows.addRow(row);
                    if (top20Count < 20) continue;
                    break block3;
                }
            }
            Col col = new Col();
            col.addColTitle(0, "Node Name");
            col.addColTitle(1, "Duration Of Outage");
            col.addColTitle(2, "Service Lost Time");
            ClassicTable table = new ClassicTable();
            table.setCol(col);
            table.setRows(rows);
            Section section = new Section();
            section.setClassicTable(table);
            section.setSectionName(label + " " + service);
            section.setSectionTitle(label + " " + service);
            section.setSectionDescr(descr + " " + service);
            section.setSectionIndex(this.m_sectionIndex);
            ++this.m_sectionIndex;
            catSections.addSection(section);
        }
    }

    private void lastMTDDailyAvailability(int days, long endTime, CatSections sections, String label, String descr, String sectionName) {
        this.lastNDaysDailyAvailability(days, endTime, sections, label, descr, sectionName);
    }

    private void lastCalMTDDailyAvailability(int days, long endTime, CatSections sections, String label, String descr, String sectionName) {
        this.lastNDaysCalDailyAvailability(days, endTime, sections, label, descr, sectionName);
    }

    private void lastMoTotalAvailability(int days, long endTime, CatSections catSections, String label, String descr) {
        this.lastNDaysTotalAvailability(days, endTime, catSections, label, descr);
    }

    private void lastMoTopNOffenders(TreeMap<Double, List<String>> offenders, CatSections catSections, String label, String descr) {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Offenders " + offenders));
            log.debug((Object)"Inside lastMoTopNOffenders");
        }
        Set<Double> percentValues = offenders.keySet();
        Iterator<Double> iter = percentValues.iterator();
        Rows rows = new Rows();
        int top20Count = 0;
        block0: while (iter.hasNext()) {
            List<String> nodeNames;
            Double percent = iter.next();
            if (!(percent < 100.0) || (nodeNames = offenders.get(percent)) == null) continue;
            ListIterator<String> lstIter = nodeNames.listIterator();
            while (lstIter.hasNext()) {
                ++top20Count;
                String nodeName = lstIter.next();
                Value dateValue = new Value();
                dateValue.setContent(nodeName);
                dateValue.setType("title");
                Value value = new Value();
                value.setContent(this.formatNumber("" + percent));
                value.setType("data");
                Row row = new Row();
                row.addValue(dateValue);
                row.addValue(value);
                rows.addRow(row);
                if (top20Count < 20) continue;
                break block0;
            }
        }
        Col col = new Col();
        col.addColTitle(0, "Node Name");
        col.addColTitle(1, "Percentage Availability");
        ClassicTable table = new ClassicTable();
        table.setCol(col);
        table.setRows(rows);
        Section section = new Section();
        section.setClassicTable(table);
        section.setSectionName("lastMoTop20offenders");
        section.setSectionTitle(label);
        section.setSectionDescr(descr);
        section.setSectionIndex(this.m_sectionIndex);
        ++this.m_sectionIndex;
        catSections.addSection(section);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving lastMoTopNOffenders");
        }
    }

    private void lastMoDailyAvailability(int days, long endTime, CatSections sections, String label, String descr, String sectionName) {
        this.lastNDaysDailyAvailability(days, endTime, sections, label, descr, sectionName);
    }

    private void lastCalMoDailyAvailability(int days, long endTime, CatSections sections, String label, String descr, String sectionName) {
        this.lastNDaysCalDailyAvailability(days, endTime, sections, label, descr, sectionName);
    }

    private void lastNDaysCalDailyAvailability(int days, long endTime, CatSections catSections, String label, String descr, String sectionName) {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Inside lastNDaysDailyAvailability");
        }
        int numdays = 0;
        CalendarTableBuilder calBuilder = new CalendarTableBuilder(endTime);
        TreeMap<Date, Double> treeMap = new TreeMap<Date, Double>();
        SimpleDateFormat fmt = new SimpleDateFormat("dd MMM, yyyy");
        String periodEnd = fmt.format(new Date(endTime));
        String periodFrom = "";
        while (numdays++ < days) {
            double percentAvail;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Computing for " + new Date(endTime)));
            }
            int serviceCount = 0;
            long outage = 0L;
            for (Node node : this.m_nodes) {
                outage += node.getOutage(endTime, 86400000L);
                serviceCount += node.getServiceCount();
            }
            if (serviceCount > 0) {
                log.debug((Object)("LOOK: calculating percentAvail using outage " + outage + " service count " + serviceCount + " ROLLING_WINODW " + 86400000L + " endTime " + endTime));
                percentAvail = 100.0 * (1.0 - (double)outage * 1.0 / (1.0 * (double)serviceCount * 8.64E7));
            } else {
                percentAvail = 100.0;
            }
            treeMap.put(new Date(endTime), new Double(percentAvail));
            Date nicedate = new Date(endTime);
            log.debug((Object)("Inserting " + percentAvail + " into " + nicedate));
            periodFrom = fmt.format(new Date(endTime));
            endTime -= 86400000L;
        }
        Set keyDates = treeMap.keySet();
        Iterator iter = keyDates.iterator();
        int dateSlot = 0;
        while (iter.hasNext()) {
            Date key = (Date)iter.next();
            Double percent = (Double)treeMap.get(key);
            log.debug((Object)("Inserting value " + percent + " into date slot " + dateSlot));
            log.debug((Object)("Inserting value " + percent + " into date slot " + ++dateSlot));
            calBuilder.setPctValue(dateSlot, percent);
        }
        Section section = new Section();
        section.setCalendarTable(calBuilder.getTable());
        section.setSectionName(sectionName);
        section.setSectionTitle(label);
        section.setSectionDescr(descr);
        section.setPeriod(periodFrom + " to " + periodEnd);
        section.setSectionIndex(this.m_sectionIndex);
        ++this.m_sectionIndex;
        catSections.addSection(section);
        log.debug((Object)"Leaving lastNDaysCalDailyAvailability");
    }

    private void lastNDaysDailyAvailability(int days, long endTime, CatSections catSections, String label, String descr, String sectionName) {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Inside lastNDaysDailyAvailability");
        }
        int numdays = 0;
        Rows rows = new Rows();
        TreeMap<Date, String> treeMap = new TreeMap<Date, String>();
        SimpleDateFormat fmt = new SimpleDateFormat("dd MMM, yyyy");
        String periodEnd = fmt.format(new Date(endTime));
        String periodFrom = "";
        while (numdays++ < days) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Computing for " + new Date(endTime)));
            }
            int serviceCount = 0;
            long outage = 0L;
            for (Node node : this.m_nodes) {
                outage += node.getOutage(endTime, 86400000L);
                serviceCount += node.getServiceCount();
            }
            double percentAvail = serviceCount > 0 ? 100.0 * (1.0 - (double)outage * 1.0 / (1.0 * (double)serviceCount * 8.64E7)) : 100.0;
            treeMap.put(new Date(endTime), this.formatNumber(percentAvail + ""));
            periodFrom = fmt.format(new Date(endTime));
            endTime -= 86400000L;
        }
        Set keyDates = treeMap.keySet();
        for (Date key : keyDates) {
            Value dateValue = new Value();
            SimpleDateFormat fmtmp = new SimpleDateFormat("dd");
            dateValue.setContent(fmtmp.format(key));
            dateValue.setType("title");
            String percent = (String)treeMap.get(key);
            Value value = new Value();
            value.setContent(percent);
            value.setType("data");
            Row row = new Row();
            row.addValue(dateValue);
            row.addValue(value);
            rows.addRow(row);
        }
        Col col = new Col();
        col.addColTitle(0, "Date");
        col.addColTitle(1, "Percentage Availability");
        ClassicTable table = new ClassicTable();
        table.setCol(col);
        table.setRows(rows);
        Section section = new Section();
        section.setClassicTable(table);
        section.setSectionName(sectionName);
        section.setSectionTitle(label);
        section.setSectionDescr(descr);
        section.setPeriod(periodFrom + " to " + periodEnd);
        section.setSectionIndex(this.m_sectionIndex);
        ++this.m_sectionIndex;
        catSections.addSection(section);
        log.debug((Object)"Leaving lastNDaysDailyAvailability");
    }

    private void lastNDaysTotalAvailability(int days, long endTime, CatSections catSections, String label, String descr) {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)"Inside lastNDaysTotalAvailability");
        Rows rows = new Rows();
        int serviceCount = 0;
        long outage = 0L;
        int numdays = 0;
        SimpleDateFormat fmt = new SimpleDateFormat("dd MMM, yyyy");
        String periodEnd = fmt.format(new Date(endTime));
        String periodFrom = "";
        while (numdays++ < days) {
            for (Node node : this.m_nodes) {
                serviceCount += node.getServiceCount();
                outage += node.getOutage(endTime, 86400000L);
            }
            periodFrom = fmt.format(new Date(endTime)) + " to " + periodEnd;
            endTime -= 86400000L;
        }
        double percentAvail = serviceCount > 0 ? 100.0 * (1.0 - (double)outage * 1.0 / (1.0 * (double)serviceCount * 8.64E7)) : 100.0;
        Value dateValue = new Value();
        dateValue.setContent(periodFrom);
        dateValue.setType("title");
        Value value = new Value();
        value.setContent(this.formatNumber(percentAvail + ""));
        value.setType("data");
        Row row = new Row();
        row.addValue(dateValue);
        row.addValue(value);
        rows.addRow(row);
        Col col = new Col();
        col.addColTitle(0, "Date");
        col.addColTitle(1, "Percentage Availability");
        ClassicTable table = new ClassicTable();
        table.setCol(col);
        table.setRows(rows);
        Section section = new Section();
        section.setClassicTable(table);
        section.setSectionName("Last" + days + "TotalAvailability");
        section.setSectionTitle(label);
        section.setSectionDescr(descr);
        section.setPeriod(periodFrom);
        section.setSectionIndex(this.m_sectionIndex);
        ++this.m_sectionIndex;
        catSections.addSection(section);
        log.debug((Object)"Leaving lastNDaysTotalAvailability");
    }

    private void lastNMonthsAvailability(int nMonths, long endTime, CatSections catSections, String label, String descr) {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)"Inside lastNMonthsAvailability");
        Rows rows = new Rows();
        int numMonths = 0;
        int numDays = this.getDaysForMonth(endTime);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(endTime));
        int month = calendar.get(2);
        int year = calendar.get(1);
        calendar.set(year, month, numDays, 23, 59, 59);
        endTime = calendar.getTime().getTime();
        SimpleDateFormat fmt = new SimpleDateFormat("MMM, yyyy");
        String periodEnd = fmt.format(new Date(endTime));
        TreeMap<Date, String> treeMap = new TreeMap<Date, String>();
        String periodFrom = null;
        while (numMonths++ < nMonths) {
            int serviceCount = 0;
            long outage = 0L;
            log.debug((Object)("Number of days " + numDays + " in month of " + new Date(endTime)));
            long rollingWindow = (long)numDays * 86400000L * 1L;
            for (Node node : this.m_nodes) {
                serviceCount += node.getServiceCount();
                outage += node.getOutage(endTime, rollingWindow);
            }
            double percentAvail = serviceCount > 0 ? 100.0 * (1.0 - (double)outage * 1.0 / (1.0 * (double)serviceCount * (double)rollingWindow)) : 100.0;
            treeMap.put(new Date(endTime), this.formatNumber(percentAvail + ""));
            periodFrom = fmt.format(new Date(endTime));
            calendar = new GregorianCalendar();
            calendar.setTime(new Date(endTime));
            month = calendar.get(2);
            year = calendar.get(1);
            calendar.set(year, month - 1, 1, 0, 0, 0);
            endTime = calendar.getTime().getTime();
            month = calendar.get(2);
            year = calendar.get(1);
            numDays = this.getDaysForMonth(endTime);
            calendar.set(year, month, numDays, 23, 59, 59);
            endTime = calendar.getTime().getTime();
        }
        Set keyDates = treeMap.keySet();
        for (Date key : keyDates) {
            Value dateValue = new Value();
            SimpleDateFormat fmtmp = new SimpleDateFormat("MMM");
            dateValue.setContent(fmtmp.format(key) + "");
            dateValue.setType("title");
            Value value = new Value();
            String percent = (String)treeMap.get(key);
            value.setContent(percent);
            value.setType("data");
            Row row = new Row();
            row.addValue(dateValue);
            row.addValue(value);
            rows.addRow(row);
        }
        Col col = new Col();
        col.addColTitle(0, "Date");
        col.addColTitle(1, "Percentage Availability");
        ClassicTable table = new ClassicTable();
        table.setCol(col);
        table.setRows(rows);
        Section section = new Section();
        section.setClassicTable(table);
        section.setSectionName("last12MoAvail");
        section.setSectionTitle(label);
        section.setSectionDescr(descr);
        section.setPeriod(periodFrom + " to " + periodEnd);
        section.setSectionIndex(this.m_sectionIndex);
        ++this.m_sectionIndex;
        catSections.addSection(section);
        log.debug((Object)"Leaving lastNMonthsAvailability");
    }

    private static synchronized int getDays(boolean isLeap, int month) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                if (isLeap) {
                    return 29;
                }
                return 28;
            }
        }
        return -1;
    }

    private int getDaysForMonth(long endTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(endTime));
        int month = calendar.get(2);
        int year = calendar.get(1);
        return AvailCalculations.getDays(calendar.isLeapYear(year), month);
    }

    private void lastNDaysDailyServiceAvailability(int days, long endTime, CatSections catSections, String label, String descr) {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)("Inside lastNDaysDailyServiceAvailability " + days));
        String periodFrom = "";
        SimpleDateFormat fmtmp = new SimpleDateFormat("dd MMM, yyyy");
        String periodTo = "";
        periodTo = fmtmp.format(new Date(endTime));
        for (String service : this.m_monitoredServices) {
            Section section;
            ClassicTable table;
            Col col;
            SimpleDateFormat fmt;
            Value dateValue;
            Set keys;
            int daysCnt;
            TreeMap<Date, Double> treeMap = new TreeMap<Date, Double>();
            Rows rows = new Rows();
            log.debug((Object)("SERvice " + service));
            long curTime = endTime;
            Map<IfService, OutageSvcTimesList> svcOutages = null;
            if (this.m_services != null) {
                svcOutages = this.m_services.get(service);
            }
            if (svcOutages == null || svcOutages.size() <= 0) {
                daysCnt = 0;
                while (daysCnt++ < days) {
                    log.debug((Object)("DAy 100 % : " + daysCnt));
                    periodFrom = fmtmp.format(new Date(curTime));
                    treeMap.put(new Date(curTime), new Double(100.0));
                    curTime -= 86400000L;
                }
                keys = treeMap.keySet();
                for (Date tmp : keys) {
                    dateValue = new Value();
                    fmt = new SimpleDateFormat("dd");
                    dateValue.setContent(fmt.format(tmp) + "");
                    dateValue.setType("title");
                    Value value = new Value();
                    value.setContent("100.0");
                    value.setType("data");
                    Row row = new Row();
                    row.addValue(dateValue);
                    row.addValue(value);
                    rows.addRow(row);
                }
                col = new Col();
                col.addColTitle(0, "Date");
                col.addColTitle(1, "Percentage Availability");
                table = new ClassicTable();
                table.setCol(col);
                table.setRows(rows);
                section = new Section();
                section.setClassicTable(table);
                section.setPeriod(periodFrom + " to " + periodTo);
                section.setSectionName(label + service);
                section.setSectionTitle(label + service);
                section.setSectionDescr(descr + service);
                section.setSectionIndex(this.m_sectionIndex);
                ++this.m_sectionIndex;
                catSections.addSection(section);
                continue;
            }
            daysCnt = 0;
            while (daysCnt++ < days) {
                log.debug((Object)("DAy : " + daysCnt + " end time " + new Date(curTime) + " " + " ROLLING_WINDOW " + 86400000L));
                int serviceCnt = 0;
                long outageTime = 0L;
                Set<IfService> keys2 = svcOutages.keySet();
                for (IfService ifservice : keys2) {
                    log.debug((Object)ifservice);
                    OutageSvcTimesList outageList = svcOutages.get(ifservice);
                    if (outageList != null) {
                        long outage = outageList.getDownTime(curTime, 86400000L);
                        outageTime += outage;
                    }
                    ++serviceCnt;
                }
                log.debug((Object)("Outage Time " + outageTime));
                long den = 86400000L * (long)serviceCnt;
                double outag = 1.0 * (double)outageTime;
                double denom = 1.0 * (double)den;
                double cal = 0.0;
                if (den > 0L) {
                    cal = 100.0 * (1.0 - outag / denom);
                }
                treeMap.put(new Date(curTime), new Double(cal));
                periodFrom = fmtmp.format(new Date(curTime));
                log.debug((Object)("Added to svc list " + new Date(curTime)));
                curTime -= 86400000L;
            }
            keys = treeMap.keySet();
            for (Date tmp : keys) {
                dateValue = new Value();
                fmt = new SimpleDateFormat("dd");
                dateValue.setContent(fmt.format(tmp) + "");
                dateValue.setType("title");
                Double val = (Double)treeMap.get(tmp);
                Value value = new Value();
                value.setContent("" + val);
                value.setType("data");
                Row row = new Row();
                row.addValue(dateValue);
                row.addValue(value);
                rows.addRow(row);
            }
            col = new Col();
            col.addColTitle(0, "Date");
            col.addColTitle(1, "Percentage Availability");
            table = new ClassicTable();
            table.setCol(col);
            table.setRows(rows);
            section = new Section();
            section.setClassicTable(table);
            section.setPeriod(periodFrom + " to " + periodTo);
            section.setSectionName(label + service);
            section.setSectionTitle(label + service);
            section.setSectionDescr(descr + service);
            section.setSectionIndex(this.m_sectionIndex);
            ++this.m_sectionIndex;
            catSections.addSection(section);
        }
        log.debug((Object)"Leaving lastNDaysDailyServiceAvailability");
    }

    private String formatNumber(String num) {
        if (num.indexOf(".") == 0) {
            num = "0" + num;
        }
        if (num.indexOf(".") == -1) {
            num = num + ".0";
        }
        num = num + "000000";
        return num.substring(0, num.indexOf(".") + 6);
    }
}

