/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class AttributesImpl
implements Attributes {
    private final List attrList;

    public AttributesImpl(Attributes attrs) {
        this(attrs == null ? 0 : attrs.getLength());
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.add(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
            }
        }
    }

    public AttributesImpl(int size) {
        this.attrList = new ArrayList(size);
    }

    public void add(String namespaceUri, String localName, String qName, String type, String value) {
        this.attrList.add(new AttributeImpl(namespaceUri, localName, qName, type, value));
    }

    public void addAll(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.add(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
        }
    }

    public int getLength() {
        return this.attrList.size();
    }

    public String getURI(int index) {
        return this.getAttribute((int)index).namespaceUri;
    }

    public String getLocalName(int index) {
        return this.getAttribute((int)index).localName;
    }

    public String getQName(int index) {
        return this.getAttribute((int)index).qName;
    }

    public String getType(int index) {
        return this.getAttribute((int)index).type;
    }

    public String getValue(int index) {
        return this.getAttribute((int)index).value;
    }

    public int getIndex(String uri, String localName) {
        int i = 0;
        while (i < this.attrList.size()) {
            AttributeImpl attr = this.getAttribute(i++);
            if (!(attr.namespaceUri == null ? uri == null : attr.namespaceUri.equals(uri)) || !(attr.localName == null ? localName == null : attr.localName.equals(localName))) continue;
            break;
        }
        if (i == this.attrList.size()) {
            return -1;
        }
        return i;
    }

    public int getIndex(String qName) {
        int i = 0;
        while (i < this.attrList.size()) {
            AttributeImpl attr = this.getAttribute(i++);
            if (!attr.qName.equals(qName)) continue;
            break;
        }
        if (i == this.attrList.size()) {
            return -1;
        }
        return i;
    }

    public String getType(String uri, String localName) {
        AttributeImpl attr = null;
        int i = 0;
        while (i < this.attrList.size()) {
            attr = this.getAttribute(i++);
            if (!(attr.namespaceUri == null ? uri == null : attr.namespaceUri.equals(uri)) || !(attr.localName == null ? localName == null : attr.localName.equals(localName))) continue;
        }
        if (attr == null) {
            return null;
        }
        return attr.type;
    }

    public String getType(String qName) {
        AttributeImpl attr = null;
        int i = 0;
        while (i < this.attrList.size()) {
            attr = this.getAttribute(i++);
            if (!attr.qName.equals(qName)) continue;
        }
        if (attr == null) {
            return null;
        }
        return attr.type;
    }

    public String getValue(String uri, String localName) {
        AttributeImpl attr = null;
        int i = 0;
        while (i < this.attrList.size()) {
            attr = this.getAttribute(i++);
            if (!(attr.namespaceUri == null ? uri == null : attr.namespaceUri.equals(uri)) || !(attr.localName == null ? localName == null : attr.localName.equals(localName))) continue;
        }
        if (attr == null) {
            return null;
        }
        return attr.value;
    }

    public String getValue(String qName) {
        AttributeImpl attr = null;
        int i = 0;
        while (i < this.attrList.size()) {
            attr = this.getAttribute(i++);
            if (!attr.qName.equals(qName)) continue;
        }
        if (attr == null) {
            return null;
        }
        return attr.value;
    }

    public String toString() {
        String result;
        if (this.attrList.isEmpty()) {
            result = "[]";
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            sb.append(this.getQName(0)).append('=').append(this.getValue(0));
            for (int i = 1; i < this.attrList.size(); ++i) {
                sb.append(", ").append(this.getQName(i)).append('=').append(this.getValue(i));
            }
            sb.append(']');
            result = sb.toString();
        }
        return result;
    }

    private AttributeImpl getAttribute(int index) {
        return (AttributeImpl)this.attrList.get(index);
    }

    private static final class AttributeImpl {
        public final String namespaceUri;
        public final String localName;
        public final String qName;
        public final String type;
        public final String value;

        public AttributeImpl(String namespaceUri, String localName, String qName, String type, String value) {
            this.namespaceUri = namespaceUri;
            this.localName = localName;
            this.qName = qName;
            this.type = type;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AttributeImpl)) {
                return false;
            }
            AttributeImpl attribute = (AttributeImpl)o;
            if (this.localName != null ? !this.localName.equals(attribute.localName) : attribute.localName != null) {
                return false;
            }
            if (this.namespaceUri != null ? !this.namespaceUri.equals(attribute.namespaceUri) : attribute.namespaceUri != null) {
                return false;
            }
            if (this.qName != null ? !this.qName.equals(attribute.qName) : attribute.qName != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(attribute.type) : attribute.type != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(attribute.value) : attribute.value != null);
        }

        public int hashCode() {
            int result = this.namespaceUri != null ? this.namespaceUri.hashCode() : 0;
            result = 29 * result + (this.localName != null ? this.localName.hashCode() : 0);
            result = 29 * result + (this.qName != null ? this.qName.hashCode() : 0);
            result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

