/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import junit.framework.Assert;
import org.opennms.core.utils.ProcessExec;

public class FileAnticipator
extends Assert {
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private LinkedList<File> m_expecting = new LinkedList();
    private LinkedList<File> m_deleteMe = new LinkedList();
    private File m_tempDir = null;
    private boolean m_initialized = false;

    public FileAnticipator() throws IOException {
        this(true);
    }

    public FileAnticipator(boolean initialize) throws IOException {
        if (initialize) {
            this.initialize();
        }
    }

    protected void finalize() {
        this.tearDown();
    }

    public void tearDown() {
        if (!this.isInitialized()) {
            return;
        }
        try {
            this.deleteExpected(true);
            ListIterator<File> i = this.m_deleteMe.listIterator(this.m_deleteMe.size());
            while (i.hasPrevious()) {
                File f = i.previous();
                if (f.delete()) continue;
                StringBuffer b = new StringBuffer();
                b.append("Could not delete " + f.getAbsolutePath() + ": is it a non-empty directory?");
                b.append("\nDirectory listing:");
                for (File file : f.listFiles()) {
                    b.append("\n\t");
                    b.append(file.getName());
                }
                FileAnticipator.fail((String)b.toString());
            }
            if (this.m_tempDir != null) {
                FileAnticipator.assertFalse((String)(this.m_tempDir + " exists"), (boolean)this.m_tempDir.exists());
            }
        }
        catch (Throwable t) {
            if (this.m_tempDir != null && this.m_tempDir.exists()) {
                ProcessExec ex = new ProcessExec(System.out, System.err);
                String[] cmd = new String[]{"rm", "-r", this.m_tempDir.getAbsolutePath()};
                try {
                    ex.exec(cmd);
                }
                catch (Throwable innerThrowable) {
                    StringBuffer command = new StringBuffer();
                    command.append(cmd[0]);
                    for (int i = 1; i < cmd.length; ++i) {
                        command.append(" ");
                        command.append(cmd[i]);
                    }
                    System.err.println("Got throwable while forcibly removing temporary directory " + this.m_tempDir + " with '" + command + "': " + innerThrowable);
                    innerThrowable.printStackTrace();
                }
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void initialize() throws IOException {
        if (this.m_initialized) {
            return;
        }
        String systemTempDir = System.getProperty(JAVA_IO_TMPDIR);
        FileAnticipator.assertNotNull((String)"java.io.tmpdir system property is not set, but must be", (Object)systemTempDir);
        File f = new File(systemTempDir);
        FileAnticipator.assertTrue((String)("path specified in system property java.io.tmpdir, \"" + systemTempDir + "\" is not a directory"), (boolean)f.isDirectory());
        String tempFileName = "FileAnticipator_temp_" + System.currentTimeMillis() + "_" + FileAnticipator.generateRandomHexString(8);
        this.m_tempDir = this.internalTempDir(f, tempFileName);
        this.m_initialized = true;
    }

    protected static String generateRandomHexString(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length argument is " + length + " and cannot be below zero");
        }
        Random random = new Random();
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public File getTempDir() {
        this.assertInitialized();
        return this.m_tempDir;
    }

    private void assertInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
    }

    public File tempFile(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.assertInitialized();
        return this.internalTempFile(this.m_tempDir, name);
    }

    public File tempFile(File parent, String name) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("parent argument cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.assertInitialized();
        return this.internalTempFile(parent, name);
    }

    public File tempFile(String name, String contents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents argument cannot be null");
        }
        this.assertInitialized();
        return this.internalTempFile(this.m_tempDir, name, contents);
    }

    public File tempFile(File parent, String name, String contents) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("parent argument cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents argument cannot be null");
        }
        this.assertInitialized();
        return this.internalTempFile(parent, name, contents);
    }

    private File internalTempDir(File parent, String name) throws IOException {
        File f = new File(parent, name);
        FileAnticipator.assertFalse((String)("temporary directory exists but it shouldn't: " + f.getAbsolutePath()), (boolean)f.exists());
        FileAnticipator.assertTrue((String)("could not create temporary directory: " + f.getAbsolutePath()), (boolean)f.mkdir());
        this.m_deleteMe.add(f);
        return f;
    }

    private File internalTempFile(File parent, String name) throws IOException {
        File f = new File(parent, name);
        FileAnticipator.assertFalse((String)("temporary file exists but it shouldn't: " + f.getAbsolutePath()), (boolean)f.exists());
        FileAnticipator.assertTrue((String)("createNewFile: " + f.getAbsolutePath()), (boolean)f.createNewFile());
        this.m_deleteMe.add(f);
        return f;
    }

    private File internalTempFile(File parent, String name, String contents) throws IOException {
        File f = this.internalTempFile(parent, name);
        PrintWriter w = new PrintWriter(new FileWriter(f));
        w.print(contents);
        w.close();
        return f;
    }

    public File tempDir(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        return this.tempDir(this.m_tempDir, name);
    }

    public File tempDir(File parent, String name) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("parent argument cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.assertInitialized();
        return this.internalTempDir(parent, name);
    }

    public File expecting(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.assertInitialized();
        return this.internalExpecting(this.m_tempDir, name);
    }

    public File expecting(File parent, String name) {
        if (parent == null) {
            throw new IllegalArgumentException("parent argument cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.assertInitialized();
        return this.internalExpecting(parent, name);
    }

    private File internalExpecting(File parent, String name) {
        File f = new File(parent, name);
        this.m_expecting.add(f);
        return f;
    }

    public void deleteExpected() {
        this.deleteExpected(false);
    }

    public void deleteExpected(boolean ignoreNonExistantFiles) {
        this.assertInitialized();
        ListIterator<File> i = this.m_expecting.listIterator(this.m_expecting.size());
        while (i.hasPrevious()) {
            File f = i.previous();
            if (!f.exists()) {
                if (!ignoreNonExistantFiles) {
                    FileAnticipator.fail((String)("Expected file that needs to be deleted does not exist: " + f.getAbsolutePath()));
                }
            } else {
                FileAnticipator.assertTrue((String)("Could not delete expected file: " + f.getAbsolutePath()), (boolean)f.delete());
            }
            i.remove();
        }
        FileAnticipator.assertEquals((String)"No expected files left over", (int)this.m_expecting.size(), (int)0);
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }
}

