/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class If
extends PostfixMathCommand
implements CallbackEvaluationI {
    public If() {
        this.numberOfParameters = -1;
    }

    public boolean checkNumberOfParameters(int n) {
        return n == 3 || n == 4;
    }

    public Object evaluate(Node node, EvaluatorI evaluatorI) throws ParseException {
        double d;
        int n = node.jjtGetNumChildren();
        if (!this.checkNumberOfParameters(n)) {
            throw new ParseException("If operator must have 3 or 4 arguments.");
        }
        Object object = evaluatorI.eval(node.jjtGetChild(0));
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return evaluatorI.eval(node.jjtGetChild(1));
            }
            return evaluatorI.eval(node.jjtGetChild(2));
        }
        if (object instanceof Complex) {
            d = ((Complex)object).re();
        } else if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else {
            throw new ParseException("Condition in if operator must be double or complex");
        }
        if (d > 0.0) {
            return evaluatorI.eval(node.jjtGetChild(1));
        }
        if (n == 3 || d < 0.0) {
            return evaluatorI.eval(node.jjtGetChild(2));
        }
        return evaluatorI.eval(node.jjtGetChild(3));
    }
}

