/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.nfunk.jep.Variable;
import org.nfunk.jep.VariableFactory;

public class SymbolTable
extends Hashtable {
    private static final long serialVersionUID = 1127787896437151144L;
    private VariableFactory vf;
    protected StObservable obeservable = new StObservable();

    public SymbolTable(VariableFactory variableFactory) {
        this.vf = variableFactory;
    }

    private SymbolTable() {
    }

    public Object get(Object object) {
        return this.getValue(object);
    }

    public Object getValue(Object object) {
        Variable variable = (Variable)super.get(object);
        if (variable == null) {
            return null;
        }
        return variable.getValue();
    }

    public Variable getVar(String string) {
        return (Variable)super.get(string);
    }

    public Object put(Object object, Object object2) {
        return this.makeVarIfNeeded((String)object, object2);
    }

    public void setVarValue(String string, Object object) {
        Variable variable = (Variable)super.get(string);
        if (variable != null) {
            variable.setValue(object);
            return;
        }
        throw new NullPointerException("Variable " + string + " does not exist.");
    }

    protected Variable createVariable(String string, Object object) {
        Variable variable = this.vf.createVariable(string, object);
        this.obeservable.stSetChanged();
        this.obeservable.notifyObservers(variable);
        return variable;
    }

    protected Variable createVariable(String string) {
        Variable variable = this.vf.createVariable(string);
        this.obeservable.stSetChanged();
        this.obeservable.notifyObservers(variable);
        return variable;
    }

    public Variable addVariable(String string, Object object) {
        Variable variable = (Variable)super.get(string);
        if (variable != null) {
            throw new IllegalStateException("Variable " + string + " already exists.");
        }
        variable = this.createVariable(string, object);
        super.put(string, variable);
        variable.setValidValue(true);
        return variable;
    }

    public Variable addConstant(String string, Object object) {
        Variable variable = this.addVariable(string, object);
        variable.setIsConstant(true);
        return variable;
    }

    public Variable makeVarIfNeeded(String string, Object object) {
        Variable variable = (Variable)super.get(string);
        if (variable != null) {
            if (variable.isConstant()) {
                throw new IllegalStateException("Attempt to change the value of constant variable " + string);
            }
            variable.setValue(object);
            return variable;
        }
        variable = this.createVariable(string, object);
        super.put(string, variable);
        return variable;
    }

    public Variable makeVarIfNeeded(String string) {
        Variable variable = (Variable)super.get(string);
        if (variable != null) {
            return variable;
        }
        variable = this.createVariable(string);
        super.put(string, variable);
        return variable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            stringBuffer.append(variable.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void clearValues() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            variable.setValidValue(false);
        }
    }

    public VariableFactory getVariableFactory() {
        return this.vf;
    }

    public synchronized void addObserver(Observer observer) {
        this.obeservable.addObserver(observer);
    }

    public synchronized int countObservers() {
        return this.obeservable.countObservers();
    }

    public synchronized void deleteObserver(Observer observer) {
        this.obeservable.deleteObserver(observer);
    }

    public synchronized void deleteObservers() {
        this.obeservable.deleteObservers();
    }

    public synchronized boolean hasChanged() {
        return this.obeservable.hasChanged();
    }

    public synchronized void addObserverToExistingVariables(Observer observer) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            variable.addObserver(observer);
        }
    }

    public void clearNonConstants() {
        Variable variable;
        Vector<Variable> vector = new Vector<Variable>();
        Enumeration<Object> enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            variable = (Variable)enumeration.nextElement();
            if (!variable.isConstant()) continue;
            vector.add(variable);
        }
        this.clear();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            variable = (Variable)enumeration.nextElement();
            super.put(variable.getName(), variable);
        }
    }

    public class StObservable
    extends Observable {
        protected synchronized void stSetChanged() {
            this.setChanged();
        }

        public SymbolTable getSymbolTable() {
            return SymbolTable.this;
        }
    }
}

