/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.tests;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RMISecurityManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.oss.ApplicationContext;
import javax.oss.fm.monitor.AlarmEvent;
import javax.oss.fm.monitor.AlarmKey;
import javax.oss.fm.monitor.AlarmValue;
import javax.oss.fm.monitor.JVTAlarmMonitorHome;
import javax.oss.fm.monitor.JVTAlarmMonitorSession;
import javax.oss.fm.monitor.NotifyAckStateChangedEvent;
import javax.oss.fm.monitor.NotifyAlarmCommentsEvent;
import javax.oss.fm.monitor.NotifyAlarmListRebuiltEvent;
import javax.oss.fm.monitor.NotifyChangedAlarmEvent;
import javax.oss.fm.monitor.NotifyClearedAlarmEvent;
import javax.oss.fm.monitor.NotifyNewAlarmEvent;
import javax.oss.util.IRPEvent;
import javax.rmi.PortableRemoteObject;
import org.openoss.ossj.fm.monitor.j2ee.AlarmMonitor;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmKey;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmValue;
import org.openoss.ossj.jvt.fm.monitor.OOSSApplicationContext;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyNewAlarmEvent;
import org.openoss.ossj.tests.PropertiesLoader;
import org.openoss.ossj.xml.fm.monitor.OOSSQosEventXmlJvtDocumentMarshaler;

public class SentinalIF {
    private static Properties env;
    private static PropertiesLoader props;
    private static String jnp_host;
    private static JVTAlarmMonitorHome home;
    private static JVTAlarmMonitorSession session;
    private static AlarmMonitor alarmInternals;
    private static Object ref;
    private static Topic eventTopic;
    private static TopicSession jmsSession;
    private static TopicConnection conn;
    private static boolean CONNECTED;
    private AlarmMonitor am = null;
    private static TopicSession jmsSession2;
    private static TopicConnection conn2;
    private static Topic xvteventTopic;
    private static QueueSession jmsSession3;
    private static QueueConnection queueConnection;
    private static Queue xmlMessageQueue;
    int notifyAlarmListRebuiltEvent_count = 0;
    int notifyNewAlarmEvent_count = 0;
    int notifyClearedAlarmEvent_count = 0;
    int notifyChangedAlarmEvent_count = 0;
    int notifyAckStateChangedEvent_count = 0;
    int notifyAlarmCommentsEvent_count = 0;
    int unknownObjectMessage_count = 0;
    int nonObjectMessage_count = 0;
    int objectMessage_count;
    int unknownIRPEvt_count = 0;
    int txtMessage_count = 0;
    Socket sentinalSock;
    private String sentinal_host = "";
    private int sentinal_port = 0;
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean SEND_SENTINAL = false;
    private static boolean TERMINATED_MESSAGE;
    private static boolean USE_XVT;
    public static final int DISPLAY_OUTPUT_ONLY = 1;
    public static final int SEND_OUTPUT_TO_SENTINAL = 2;
    public static final int TEST_SENTINAL_SOCKET_RAISE = 3;
    public static final int TEST_SENTINAL_SOCKET_CLEAR = 4;
    public static final int SEND_NEW_ALARM_EVENT = 4;
    private String sentinalXMLtest_Raise = "<Event>\n    <eventRank>original</eventRank>\n    <systemClass>opennms ossj</systemClass>\n    <systemInstance>app dn</systemInstance>\n    <eventId>999999</eventId>\n    <dataType>X733</dataType>\n    <originatingTime>2006-03-08 14:00:00</originatingTime>\n    <moClass>SignalLinkEquipment</moClass>\n    <moInstance>Channel4-TX-1</moInstance>\n    <severity>CRITICAL</severity>\n    <alarmType>AlarmType</alarmType>\n    <probableCause>ProbableCause</probableCause>\n    <specificProblems>SpecificProblem</specificProblems>\n    <additionalText>AdditionalText</additionalText>\n    <additionalTextTag1>ProposedRepairActions</additionalTextTag1>\n    <additionalTextTag2>NOT POPULATED</additionalTextTag2>\n    <additionalTextTag3>NOT POPULATED</additionalTextTag3>\n    <additionalTextTag4>NOT POPULATED</additionalTextTag4>\n    <additionalTextTag5>NOT POPULATED</additionalTextTag5>\n    <additionalTextTag6>NOT POPULATED</additionalTextTag6>\n</Event> \n";
    private String sentinalXMLtest_Clear = "<Event>\n    <eventRank>original</eventRank>\n    <systemClass>opennms ossj</systemClass>\n    <systemInstance>app dn</systemInstance>\n    <eventId>999999</eventId>\n    <dataType>X733</dataType>\n    <originatingTime>2006-03-08 14:00:10</originatingTime>\n    <moClass>SignalLinkEquipment</moClass>\n    <moInstance>Channel4-TX-1</moInstance>\n    <severity>CLEARED</severity>\n    <alarmType>AlarmType</alarmType>\n    <probableCause>ProbableCause</probableCause>\n    <specificProblems>SpecificProblem</specificProblems>\n    <additionalText>AdditionalText</additionalText>\n    <additionalTextTag1>ProposedRepairActions</additionalTextTag1>\n    <additionalTextTag2>NOT POPULATED</additionalTextTag2>\n    <additionalTextTag3>NOT POPULATED</additionalTextTag3>\n    <additionalTextTag4>NOT POPULATED</additionalTextTag4>\n    <additionalTextTag5>NOT POPULATED</additionalTextTag5>\n    <additionalTextTag6>NOT POPULATED</additionalTextTag6>\n</Event> \n";
    static String sentinalXMLtest2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String helptxt = "\nOpenOSS OSS/J Sentinal Interface--------------------------------\nThe OpenOSS OSS/J Sentinal Interface provides an OSS/J-like* client interface for the Sentinal (StateWise)\nalarm correlation system develped by Sidonis (www.sidonis.com).\n\nValid input options:\n--------------------\n   -h : this help text\n\nInterface Options using OSS/J XVT interface\n-------------------------------------------\n   -receive1                       : print ossj data recieved but do not send to sentinal  ( use TERMINATED message )\n   -receive2                       : print ossj data recieved but do not send to sentinal  ( use CLEARED message )\n   -send1 <hostname> <port>        : send OSS/J recieved data to sentinal at hostname:port ( use TERMINATED message )\n   -send2 <hostname> <port>        : send OSS/J recieved data to sentinal at hostname:port ( use CLEARED message )\nInterface Options using OSS/J XVT interface\n-------------------------------------------\n   -xreceive1                      : print ossj data recieved but do not send to sentinal  ( use TERMINATED message )\n   -xreceive2                      : print ossj data recieved but do not send to sentinal  ( use CLEARED message )\n   -xsend1 <hostname> <port>       : send OSS/J recieved data to sentinal at hostname:port ( use TERMINATED message )\n   -xsend2 <hostname> <port>       : send OSS/J recieved data to sentinal at hostname:port ( use CLEARED message )\nOther Test Options\n------------------\n   -newalarm <severity> <ManagedObjectClass> <ManagedObjectInstance> <SpecificProblem> <ProposedRepairActions>\n                                   : send test OSSJ jvt new alarm event where\n                                     <severity> one of: Indeterminate Cleared Warning Minor Major Critical\n                                     Other values are free format strings\n                                     Note Seperate strings containing spaces with \"quotes\"   -test_raise <hostname> <port>   : send dummy test data to sentinal at hostname:port\n   -test_clear <hostname> <port>   : send dummy test data to sentinal at hostname:port\n\nNotes\n-----\nSentinal requires X.733 events to be sent to a socket in a simplified XML format. This client\ncan register with an OSS/J Qos Interace for JMS object message JVT events or for XVT XML events. \nReceived events are converted into the Sentinal format and sent to the Sentinal socket.\n\n*NOTE - This interface is believed to faithfully follow the OSS/J Qos design principles and API (www.ossj.com).It has been tested with the OpenOSS OSS/J plugin for OpenNMS and it provides a good example of how to impliment a simple client to oteer applications. However although OSSJ design patterns have been used this is not a fullyimplimented OSS/J interface. Only the minimum neccessary methods have been created and the interface has notbeen tested against the OSS/J verification kit.\n\nAuthor: Craig Gallen 2006 \n";
        int run_mode = -1;
        String host = "";
        int port = 0;
        System.out.print("***starting sentinal OSS/J xvt / jvt interface program***\n");
        System.out.print("Arguments (" + args.length + "):");
        for (int i = 0; i < args.length; ++i) {
            System.out.print(" " + args[i]);
        }
        System.out.println();
        if (args.length == 0) {
            System.out.print("Error: Sentinal Interface no args set:\n");
            run_mode = -1;
        } else if ("-h".equals(args[0])) {
            System.out.print("Sentinal Interface Help:\n");
            run_mode = -1;
        } else if ("-newalarm".equals(args[0])) {
            System.out.print("Sentinal Interface SEND_NEW_ALARM_EVENT:\n");
            if (args.length != 6) {
                System.out.print("Wrong number of arguments :" + args.length);
            } else {
                run_mode = 4;
                OOSSAlarmValue updateAlarm = new OOSSAlarmValue();
                updateAlarm.setAlarmType("QualityOfServiceAlarm");
                short ps = SentinalIF.parse_severity_string(args[1]);
                if (ps == -1) {
                    System.out.println("Unrecognised severity: " + args[1]);
                    run_mode = -1;
                } else {
                    updateAlarm.setPerceivedSeverity(ps);
                }
                updateAlarm.setManagedObjectClass(args[2]);
                updateAlarm.setManagedObjectInstance(args[3]);
                updateAlarm.setProbableCause((short)-1);
                updateAlarm.setSpecificProblem(args[4]);
                updateAlarm.setProposedRepairActions(args[5]);
                updateAlarm.setAdditionalText("NOT SET");
                updateAlarm.setSystemDN("NOT SET");
                updateAlarm.setAlarmAckState(2);
                updateAlarm.setAckSystemId("");
                updateAlarm.setAckTime(new Date());
                updateAlarm.setAckUserId("");
                updateAlarm.setAlarmChangedTime(new Date());
                updateAlarm.setAlarmClearedTime(new Date());
                updateAlarm.setAlarmRaisedTime(new Date());
                if (run_mode != -1) {
                    try {
                        SentinalIF sentinalif = new SentinalIF();
                        sentinalif.send_new_alarm_event(updateAlarm);
                        sentinalif.kill();
                    }
                    catch (Exception ex) {
                        System.out.print("main '-newalarm': problem senting new alarm event" + ex);
                    }
                }
            }
        } else if ("-receive1".equals(args[0])) {
            System.out.println("Sentinal Interface -receive1 :\n");
            USE_XVT = false;
            TERMINATED_MESSAGE = true;
            run_mode = 1;
        } else if ("-receive2".equals(args[0])) {
            System.out.println("Sentinal Interface -receive2 :\n");
            USE_XVT = false;
            TERMINATED_MESSAGE = false;
            run_mode = 1;
        } else if ("-xreceive1".equals(args[0])) {
            System.out.println("Sentinal Interface -xreceive1 :\n");
            USE_XVT = true;
            TERMINATED_MESSAGE = true;
            run_mode = 1;
        } else if ("-xreceive2".equals(args[0])) {
            System.out.println("Sentinal Interface -xreceive2 :\n");
            USE_XVT = true;
            TERMINATED_MESSAGE = false;
            run_mode = 1;
        } else if ("-test_raise".equals(args[0])) {
            System.out.println("Sentinal Interface -test_raise :\n");
            run_mode = 3;
            if (args.length != 3) {
                System.out.println("Wrong Arquments Length:" + args.length);
                run_mode = -1;
            }
            try {
                port = Integer.parseInt(args[2]);
                host = args[1];
                if (args.length != 3) {
                    System.out.println("Wrong Arquments Length:" + args.length);
                    run_mode = -1;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("error: port not an integer");
                run_mode = -1;
            }
        } else if ("-test_clear".equals(args[0])) {
            System.out.println("Sentinal Interface -test_clear :\n");
            run_mode = 4;
            if (args.length != 3) {
                System.out.println("Wrong Arquments Length:" + args.length);
                run_mode = -1;
            }
            try {
                port = Integer.parseInt(args[2]);
                host = args[1];
                if (args.length != 3) {
                    System.out.println("Wrong Arquments Length:" + args.length);
                    run_mode = -1;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("error: port not an integer");
                run_mode = -1;
            }
        } else if ("-send1".equals(args[0])) {
            System.out.println("Sentinal Interface -send1 :\n");
            TERMINATED_MESSAGE = true;
            run_mode = 2;
            if (args.length != 3) {
                System.out.println("Wrong Arquments Length:" + args.length);
                run_mode = -1;
            }
            try {
                port = Integer.parseInt(args[2]);
                host = args[1];
                if (args.length != 3) {
                    System.out.println("Wrong Arquments Length:" + args.length);
                    run_mode = -1;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("error: port not an integer");
                run_mode = -1;
            }
        } else if ("-send2".equals(args[0])) {
            System.out.println("Sentinal Interface -send2 :\n");
            TERMINATED_MESSAGE = false;
            run_mode = 2;
            if (args.length != 3) {
                System.out.println("Wrong Arquments Length:" + args.length);
                run_mode = -1;
            }
            try {
                port = Integer.parseInt(args[2]);
                host = args[1];
                if (args.length != 3) {
                    System.out.println("Wrong Arquments Length:" + args.length);
                    run_mode = -1;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("error: port not an integer");
                run_mode = -1;
            }
        } else if ("-xsend1".equals(args[0])) {
            System.out.println("Sentinal Interface -send1 :\n");
            USE_XVT = true;
            TERMINATED_MESSAGE = true;
            run_mode = 2;
            if (args.length != 3) {
                System.out.println("Wrong Arquments Length:" + args.length);
                run_mode = -1;
            }
            try {
                port = Integer.parseInt(args[2]);
                host = args[1];
                if (args.length != 3) {
                    System.out.println("Wrong Arquments Length:" + args.length);
                    run_mode = -1;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("error: port not an integer");
                run_mode = -1;
            }
        } else if ("-xsend2".equals(args[0])) {
            System.out.println("Sentinal Interface -send2 :\n");
            USE_XVT = true;
            TERMINATED_MESSAGE = false;
            run_mode = 2;
            if (args.length != 3) {
                System.out.println("Wrong Arquments Length:" + args.length);
                run_mode = -1;
            }
            try {
                port = Integer.parseInt(args[2]);
                host = args[1];
                if (args.length != 3) {
                    System.out.println("Wrong Arquments Length:" + args.length);
                    run_mode = -1;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("error: port not an integer");
                run_mode = -1;
            }
        }
        if (run_mode == -1) {
            System.out.println("Incorrect Input:\n" + helptxt);
        } else if (run_mode != 4) {
            SentinalIF sentinalif = new SentinalIF();
            try {
                System.out.println(run_mode + " host " + host + " port " + port);
                sentinalif.start(run_mode, host, port);
            }
            catch (Exception ex) {
                System.out.println("other Exception: ");
                ex.printStackTrace();
            }
            finally {
                try {
                    sentinalif.kill();
                    System.out.println("kill successful");
                }
                catch (Exception e) {
                    System.out.println("printAlarmList: Exception closing connections" + e);
                }
            }
        }
        System.out.println("End of Program");
    }

    public void send_new_alarm_event(OOSSAlarmValue updateAlarm) {
        try {
            System.out.println("send_new_alarm_event:Initialise Session: ");
            this.init();
            OOSSAlarmKey ak = new OOSSAlarmKey();
            OOSSApplicationContext ac = new OOSSApplicationContext();
            ac.setURL("updateAlarm.setURL: org.openoss.opennms.qosd.naming.provider");
            ac.setSystemProperties((Map)env);
            ak.setApplicationContext((ApplicationContext)ac);
            ak.setApplicationDN("sentinal");
            updateAlarm.setAlarmKey((AlarmKey)ak);
            OOSSNotifyNewAlarmEvent nnae = new OOSSNotifyNewAlarmEvent((AlarmValue)updateAlarm);
            nnae.setEventTime(new Date());
            nnae.setApplicationDN("sentinal");
            System.out.println("send_new_alarm_event:Session Initialised - sending event: ");
            this.am.sendJMSEvent((IRPEvent)nnae);
        }
        catch (Exception ex) {
            System.out.println("\tException sending new alarm event " + ex);
        }
    }

    public void start(int arg, String host, int port) {
        this.sentinal_host = host;
        this.sentinal_port = port;
        System.out.print("***starting sentinal interface program***\n");
        if (arg == 1) {
            System.out.print("***Option: receive - testing OSS/J connection only***\n");
            try {
                this.SEND_SENTINAL = false;
                this.testEventTopic();
            }
            catch (Exception e) {
                System.out.print("exception:*\n" + e);
            }
        } else if (arg == 3) {
            System.out.print("***Option: test - sentinal socket test - with dummy data ***\n");
            try {
                Socket sentinalSock = null;
                PrintStream out = null;
                sentinalSock = new Socket(host, port);
                out = new PrintStream(sentinalSock.getOutputStream(), true);
                System.out.println("connected to host:" + host + " port: " + port);
                System.out.println("printing test XML to sentinal interface:/n" + this.sentinalXMLtest_Raise);
                out.println(this.sentinalXMLtest_Raise);
                out.close();
                sentinalSock.close();
            }
            catch (UnknownHostException e) {
                System.err.println("Cannot resolve host: " + host + "\n" + e);
                System.exit(1);
            }
            catch (IOException e) {
                System.err.println("Couldn't get I/O for the connection to: " + host + " port: " + port + "\n" + e);
                System.exit(1);
            }
            System.out.println("end of dummy test to sentinal collector");
        } else if (arg == 4) {
            System.out.print("***Option: test - sentinal socket test - with dummy data ***\n");
            try {
                Socket sentinalSock = null;
                PrintStream out = null;
                sentinalSock = new Socket(host, port);
                out = new PrintStream(sentinalSock.getOutputStream(), true);
                System.out.println("connected to host:" + host + " port: " + port);
                System.out.println("printing test XML to sentinal interface:/n" + this.sentinalXMLtest_Clear);
                out.println(this.sentinalXMLtest_Clear);
                out.close();
                sentinalSock.close();
            }
            catch (UnknownHostException e) {
                System.err.println("Cannot resolve host: " + host + "\n" + e);
                System.exit(1);
            }
            catch (IOException e) {
                System.err.println("Couldn't get I/O for the connection to: " + host + " port: " + port + "\n" + e);
                System.exit(1);
            }
            System.out.println("end of dummy test to sentinal collector");
        } else if (arg == 2) {
            System.out.print("***Option: send - passing OSS/J events to sentinal interface***\n");
            try {
                this.SEND_SENTINAL = true;
                this.sentinalSock = new Socket(this.sentinal_host, this.sentinal_port);
                this.sentinalSock.setReuseAddress(true);
                this.sentinalSock.setSendBufferSize(65536);
                this.testEventTopic();
                this.sentinalSock.close();
            }
            catch (Exception e) {
                System.out.print("exception:*\n" + e);
            }
        }
    }

    public String sentinal_terminated_event_to_xml(NotifyClearedAlarmEvent evt) {
        String xmlstr = "";
        try {
            Date d = evt.getEventTime();
            String _evt_time = this.df.format(d);
            xmlstr = "<Event>\n    <eventRank>original</eventRank>\n    <systemClass>opennms ossj</systemClass>\n    <systemInstance>" + evt.getApplicationDN() + "</systemInstance>" + "\n" + "    <eventId>" + evt.getAlarmKey().getAlarmPrimaryKey() + "</eventId>" + "\n" + "    <dataType>" + "X733" + "</dataType>" + "\n" + "    <originatingTime>" + _evt_time + "</originatingTime>" + "\n" + "    <updateState>terminated</updateState>" + "\n" + "</Event> ";
        }
        catch (IllegalStateException ise) {
            System.out.println("\tOSS/J IllegalStateException " + ise);
        }
        catch (Exception e) {
            System.out.println("\tOSS/J Exception " + e);
        }
        return xmlstr;
    }

    public String sentinal_new_event_to_xml(NotifyNewAlarmEvent evt) {
        String xmlstr = "";
        try {
            Date d = evt.getEventTime();
            String _evt_time = this.df.format(d);
            xmlstr = "<Event>\n    <eventRank>original</eventRank>\n    <systemClass>opennms ossj</systemClass>\n    <systemInstance>" + evt.getApplicationDN() + "</systemInstance>" + "\n" + "    <eventId>" + evt.getAlarmKey().getAlarmPrimaryKey() + "</eventId>" + "\n" + "    <dataType>" + "X733" + "</dataType>" + "\n" + "    <originatingTime>" + _evt_time + "</originatingTime>" + "\n" + "    <moClass>" + evt.getManagedObjectClass() + "</moClass>" + "\n" + "    <moInstance>" + evt.getManagedObjectInstance() + "</moInstance>" + "\n" + "    <severity>" + SentinalIF.severity_string(evt.getPerceivedSeverity()) + "</severity>" + "\n" + "    <alarmType>" + evt.getAlarmType() + "</alarmType>" + "\n" + "    <probableCause>" + evt.getProbableCause() + "</probableCause>" + "\n" + "    <specificProblems><![CDATA[" + evt.getSpecificProblem() + "]]></specificProblems>" + "\n" + "    <additionalText><![CDATA[" + evt.getAdditionalText() + "]]></additionalText>" + "\n" + "    <additionalTextTag1><![CDATA[" + evt.getProposedRepairActions() + "]]></additionalTextTag1>" + "\n" + "    <additionalTextTag2>" + "NOT POPULATED" + "</additionalTextTag2>" + "\n" + "    <additionalTextTag3>" + "NOT POPULATED" + "</additionalTextTag3>" + "\n" + "    <additionalTextTag4>" + "NOT POPULATED" + "</additionalTextTag4>" + "\n" + "    <additionalTextTag5>" + "NOT POPULATED" + "</additionalTextTag5>" + "\n" + "    <additionalTextTag6>" + "NOT POPULATED" + "</additionalTextTag6>" + "\n" + "</Event> ";
        }
        catch (IllegalStateException ise) {
            System.out.println("\tOSS/J IllegalStateException " + ise);
        }
        catch (Exception e) {
            System.out.println("\tOSS/J Exception " + e);
        }
        return xmlstr;
    }

    public String sentinal_cleared_event_to_xml(NotifyClearedAlarmEvent evt) {
        String xmlstr = "";
        try {
            Date d = evt.getEventTime();
            String _evt_time = this.df.format(d);
            xmlstr = "<Event>\n    <eventRank>original</eventRank>\n    <systemClass>opennms ossj</systemClass>\n    <systemInstance>" + evt.getApplicationDN() + "</systemInstance>" + "\n" + "    <eventId>" + evt.getAlarmKey().getAlarmPrimaryKey() + "</eventId>" + "\n" + "    <dataType>" + "X733" + "</dataType>" + "\n" + "    <originatingTime>" + _evt_time + "</originatingTime>" + "\n" + "    <moClass>" + evt.getManagedObjectClass() + "</moClass>" + "\n" + "    <moInstance>" + evt.getManagedObjectInstance() + "</moInstance>" + "\n" + "    <severity>" + SentinalIF.severity_string(evt.getPerceivedSeverity()) + "</severity>" + "\n" + "    <alarmType>" + evt.getAlarmType() + "</alarmType>" + "\n" + "    <probableCause>" + evt.getProbableCause() + "</probableCause>" + "\n" + "</Event> ";
        }
        catch (IllegalStateException ise) {
            System.out.println("\tOSS/J IllegalStateException " + ise);
        }
        catch (Exception e) {
            System.out.println("\tOSS/J Exception " + e);
        }
        return xmlstr;
    }

    public static String severity_string(short ps) {
        switch (ps) {
            case 1: {
                return "Indeterminate";
            }
            case 6: {
                return "Cleared";
            }
            case 5: {
                return "Warning";
            }
            case 4: {
                return "Minor";
            }
            case 3: {
                return "Major";
            }
            case 2: {
                return "Critical";
            }
        }
        return "ILLEGAL";
    }

    public static short parse_severity_string(String pstring) {
        if ("Indeterminate".equals(pstring)) {
            return 1;
        }
        if ("Cleared".equals(pstring)) {
            return 6;
        }
        if ("Warning".equals(pstring)) {
            return 5;
        }
        if ("Minor".equals(pstring)) {
            return 4;
        }
        if ("Major".equals(pstring)) {
            return 3;
        }
        if ("Critical".equals(pstring)) {
            return 2;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public void testEventTopic() throws Exception {
        eventSubscriber = null;
        CONNECTED = false;
        block20: while (true) {
            if (!CONNECTED) {
                try {
                    System.out.println("Initialise Session: ");
                    this.init();
                    System.out.println("Session Initialised ");
                    if (SentinalIF.USE_XVT) {
                        System.out.println("Subscribing to OSS/J XVT jms session: ");
                        eventSubscriber = SentinalIF.jmsSession2.createSubscriber(SentinalIF.xvteventTopic);
                        CONNECTED = true;
                    } else {
                        System.out.println("Subscribing to OSS/J JVT jms session: ");
                        eventSubscriber = SentinalIF.jmsSession.createSubscriber(SentinalIF.eventTopic);
                        CONNECTED = true;
                    }
                }
                catch (Exception ex) {
                    System.out.println("while connecting: Exception: " + ex);
                }
                System.out.println("Subscribed - Waiting for events ;");
                continue;
            }
            while (true) {
                if (CONNECTED) ** break;
                continue block20;
                System.out.println("Waiting: Event Counts:- ListRebuilt:" + this.notifyAlarmListRebuiltEvent_count + "\tNewAlrmEvt:" + this.notifyNewAlarmEvent_count + "\tClrAlrmEvt:" + this.notifyClearedAlarmEvent_count + "\tAlrmCngEvt:" + this.notifyChangedAlarmEvent_count + "\tAckChngEvt:" + this.notifyAckStateChangedEvent_count + "\tCommentEvt:" + this.notifyAlarmCommentsEvent_count + "\tUnknownIRPEvt:" + this.unknownIRPEvt_count + "\tUnknownObjMsg:" + this.unknownObjectMessage_count + "\tNonObjMsg:" + this.nonObjectMessage_count + "\tObjMsg:" + this.objectMessage_count + "\tTxtMsg:" + this.txtMessage_count);
                try {
                    objectMessage = null;
                    if (!SentinalIF.USE_XVT) {
                        System.out.println("***Waiting for OSS/J JVT JMS object message event***");
                        msg = eventSubscriber.receive();
                        System.out.println("Received message with Message Properties:");
                        try {
                            System.out.println("\tmsg.getJMSCorrelationID(): " + msg.getJMSCorrelationID());
                            System.out.println("\tmsg.getJMSMessageID(): " + msg.getJMSMessageID());
                            props = msg.getPropertyNames();
                            while (props.hasMoreElements()) {
                                key = (String)props.nextElement();
                                try {
                                    value = msg.getStringProperty(key);
                                    System.out.println("\tProperty: " + key + "\tValue: " + value);
                                }
                                catch (JMSException jmsex) {
                                    System.out.println("AlarmMonitorDaoImpl:sendJMSEvent() Error reading message property value.  Key:" + key + " Error:" + (Object)jmsex);
                                }
                            }
                        }
                        catch (JMSException jmsex) {
                            System.out.println("AlarmMonitorDaoImpl:sendJMSEvent() Error reading message property values" + (Object)jmsex);
                        }
                        if (!(msg instanceof ObjectMessage)) {
                            System.out.println("Recieved non object message" + msg.toString());
                            ++this.nonObjectMessage_count;
                        } else {
                            objectMessage = ((ObjectMessage)msg).getObject();
                            ++this.objectMessage_count;
                        }
                    } else {
                        System.out.println("***Waiting for OSS/J XVT XML JMS text message event***");
                        msg = eventSubscriber.receive();
                        System.out.println("Received message with Message Properties:");
                        try {
                            System.out.println("\tmsg.getJMSCorrelationID(): " + msg.getJMSCorrelationID());
                            System.out.println("\tmsg.getJMSMessageID(): " + msg.getJMSMessageID());
                            props = msg.getPropertyNames();
                            while (props.hasMoreElements()) {
                                key = (String)props.nextElement();
                                try {
                                    value = msg.getStringProperty(key);
                                    System.out.println("\tProperty: " + key + "\tValue: " + value);
                                }
                                catch (JMSException jmsex) {
                                    System.out.println("AlarmMonitorDaoImpl:sendJMSEvent() Error reading message property value.  Key:" + key + " Error:" + (Object)jmsex);
                                }
                            }
                        }
                        catch (JMSException jmsex) {
                            System.out.println("AlarmMonitorDaoImpl:sendJMSEvent() Error reading message property values" + (Object)jmsex);
                        }
                        if (!(msg instanceof TextMessage)) {
                            System.out.println("Recieved unexpected non text message on XVT queue" + msg.toString());
                            ++this.objectMessage_count;
                        } else {
                            tm = (TextMessage)msg;
                            received = tm.getText();
                            System.out.println("testEventTopic() Received XML \n" + received);
                            try {
                                objectMessage = OOSSQosEventXmlJvtDocumentMarshaler.QosDocumenttoEvent((String)received);
                            }
                            catch (Exception e) {
                                System.out.println("testEventTopic() DocumentMarshaler Exception" + e);
                            }
                        }
                    }
                    if (!(objectMessage instanceof IRPEvent)) {
                        System.out.println("Recieved unknown object; not javax.oss.IRPEvent :" + objectMessage.toString());
                        ++this.unknownObjectMessage_count;
                        continue;
                    }
                    if (objectMessage instanceof NotifyAlarmListRebuiltEvent) {
                        nalre = (NotifyAlarmListRebuiltEvent)objectMessage;
                        System.out.println("Recieved NotifyAlarmListRebuiltEvent. Reason: " + nalre.getReason());
                        ++this.notifyAlarmListRebuiltEvent_count;
                        continue;
                    }
                    ae = (AlarmEvent)objectMessage;
                    if (ae instanceof NotifyNewAlarmEvent) {
                        System.out.println("Received NotifyNewAlarmEvent");
                        ++this.notifyNewAlarmEvent_count;
                        ak = ae.getAlarmKey();
                        System.out.println("Alarm Key Received, key is: " + ak.getAlarmPrimaryKey() + "\tApplication DN: " + ak.getApplicationDN());
                        System.out.println("managed object instance is: " + ae.getManagedObjectClass() + "\tManaged object instance: " + ae.getManagedObjectInstance());
                        System.out.println("XML to be sent to Sentinal:");
                        xml = this.sentinal_new_event_to_xml((NotifyNewAlarmEvent)ae);
                        System.out.println(xml);
                        if (!this.SEND_SENTINAL) continue;
                        try {
                            out = new PrintStream(this.sentinalSock.getOutputStream(), true);
                            System.out.println("Event sent to host:" + this.sentinal_host + " port: " + this.sentinal_port);
                            out.println(xml);
                            out.flush();
                        }
                        catch (UnknownHostException e) {
                            System.err.println("Cannot resolve host: " + this.sentinal_host + "\n" + e);
                            System.exit(1);
                        }
                        catch (IOException e) {
                            System.err.println("Couldn't get I/O for the connection to: " + this.sentinal_host + " port: " + this.sentinal_port + "\n" + e);
                            System.exit(1);
                        }
                        continue;
                    }
                    if (ae instanceof NotifyChangedAlarmEvent) {
                        System.out.println("Received NotifyChangedAlarmEvent");
                        ++this.notifyChangedAlarmEvent_count;
                        ak = ae.getAlarmKey();
                        System.out.println("Alarm Key Received, key is: " + ak.getAlarmPrimaryKey() + "\tApplication DN: " + ak.getApplicationDN());
                        continue;
                    }
                    if (ae instanceof NotifyClearedAlarmEvent) {
                        System.out.println("Received NotifyClearedAlarmEvent");
                        ++this.notifyClearedAlarmEvent_count;
                        ak = ae.getAlarmKey();
                        System.out.println("Alarm Key Received, key is: " + ak.getAlarmPrimaryKey() + "\tApplication DN: " + ak.getApplicationDN());
                        System.out.println("XML to be sent to Sentinal:");
                        if (SentinalIF.TERMINATED_MESSAGE) {
                            xml = this.sentinal_terminated_event_to_xml((NotifyClearedAlarmEvent)ae);
                            System.out.println("Sentinal Terminated message:");
                            System.out.println(xml);
                        } else {
                            xml = this.sentinal_cleared_event_to_xml((NotifyClearedAlarmEvent)ae);
                            System.out.println("Sentinal Cleared message:");
                            System.out.println(xml);
                        }
                        if (!this.SEND_SENTINAL) continue;
                        try {
                            out = new PrintStream(this.sentinalSock.getOutputStream(), true);
                            System.out.println("Event sent to host:" + this.sentinal_host + " port: " + this.sentinal_port);
                            out.println(xml);
                            out.flush();
                        }
                        catch (UnknownHostException e) {
                            System.err.println("Cannot resolve host: " + this.sentinal_host + "\n" + e);
                            System.exit(1);
                        }
                        catch (IOException e) {
                            System.err.println("Couldn't get I/O for the connection to: " + this.sentinal_host + " port: " + this.sentinal_port + "\n" + e);
                            System.exit(1);
                        }
                        continue;
                    }
                    if (ae instanceof NotifyAckStateChangedEvent) {
                        System.out.println("Received NotifyAckStateChangedEvent");
                        ++this.notifyAckStateChangedEvent_count;
                        ak = ae.getAlarmKey();
                        System.out.println("Alarm Key Received, key is: " + ak.getAlarmPrimaryKey() + "\tApplication DN: " + ak.getApplicationDN());
                        continue;
                    }
                    if (ae instanceof NotifyAlarmCommentsEvent) {
                        System.out.println("Received NotifyAlarmCommentsEvent");
                        ++this.notifyAlarmCommentsEvent_count;
                        ak = ae.getAlarmKey();
                        System.out.println("Alarm Key Received, key is: " + ak.getAlarmPrimaryKey() + "\tApplication DN: " + ak.getApplicationDN());
                        continue;
                    }
                    System.out.println("Received unclassified event");
                    ++this.unknownIRPEvt_count;
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Exception: ");
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
            break;
        }
    }

    private void loadClientProperties() {
        try {
            props = PropertiesLoader.getInstance();
        }
        catch (FileNotFoundException fnf_ex) {
            String propertiesFilename = System.getProperty("propertiesFile");
            System.out.println("Could not find properties file: " + propertiesFilename + fnf_ex);
            throw new UndeclaredThrowableException(fnf_ex);
        }
        catch (IOException io_ex) {
            String propertiesFilename = System.getProperty("propertiesFile");
            System.out.println("Could not read from properties file: " + propertiesFilename + "\n\t\t\t\tPlease check the file permissions" + io_ex);
            throw new UndeclaredThrowableException(io_ex);
        }
        System.out.println("Client Properties File Loaded");
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        if (props.getProperty("org.openoss.qosclient.naming.provider") != null) {
            jnp_host = props.getProperty("org.openoss.qosclient.naming.provider");
            System.out.println("Using JNP: " + jnp_host);
        } else {
            System.out.println("Naming provider property not set, Using default: jnp://jbossjmsserver1:1099");
            jnp_host = "jnp://jbossjmsserver1:1099";
        }
        env = new Properties();
        env.setProperty("java.naming.provider.url", jnp_host);
        env.setProperty("java.naming.factory.initial", props.getProperty("org.openoss.qosclient.naming.contextfactory"));
        env.setProperty("java.naming.factory.url.pkgs", props.getProperty("org.openoss.qosclient.naming.pkg"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        this.loadClientProperties();
        System.out.println("java.naming.provider.url= " + env.getProperty("java.naming.provider.url"));
        System.out.println("java.naming.factory.initial= " + env.getProperty("java.naming.factory.initial"));
        System.out.println("java.naming.factory.url.pkgs= " + env.getProperty("java.naming.factory.url.pkgs"));
        if (System.getSecurityManager() == null) {
            System.out.println("java.security.policy= " + System.getProperty("java.security.policy"));
            System.setSecurityManager(new RMISecurityManager());
        }
        InitialContext ic = new InitialContext(env);
        System.out.println("Initial context created");
        try {
            System.out.println("Trying to connect to AlarmMonitorBean ");
            ref = ic.lookup(props.getProperty("org.openoss.qosclient.jvthome"));
            System.out.println("Connecting to AlarmMonitorBean:" + props.getProperty("org.openoss.qosclient.jvthome"));
            home = (JVTAlarmMonitorHome)PortableRemoteObject.narrow((Object)ref, JVTAlarmMonitorHome.class);
            session = home.create();
            System.out.println("Obtained home, and created Session");
            this.am = (AlarmMonitor)PortableRemoteObject.narrow((Object)session, AlarmMonitor.class);
            alarmInternals = (AlarmMonitor)PortableRemoteObject.narrow((Object)session.getHandle().getEJBObject(), AlarmMonitor.class);
        }
        catch (Exception ex) {
            System.out.println("Problem connecting to AlarmMonitor bean - (may not exist if spring session):" + ex);
        }
        try {
            System.out.println("Trying to connect to message queues");
            TopicConnectionFactory tcf = (TopicConnectionFactory)ic.lookup(props.getProperty("org.openoss.qosclient.jms.topicconnectionfactory"));
            System.out.println("Topic Connection Factory:" + props.getProperty("org.openoss.qosclient.jms.topicconnectionfactory"));
            conn = tcf.createTopicConnection();
            jmsSession = conn.createTopicSession(false, 1);
            eventTopic = (Topic)ic.lookup(props.getProperty("org.openoss.qosclient.jms.topic"));
            conn.start();
            System.out.println("Event Topic    :" + props.getProperty("org.openoss.qosclient.jms.topic"));
            conn2 = tcf.createTopicConnection();
            jmsSession2 = conn2.createTopicSession(false, 1);
            xvteventTopic = (Topic)ic.lookup(props.getProperty("org.openoss.qosclient.jms.xvttopic"));
            conn2.start();
            System.out.println("XVT Event Topic:" + props.getProperty("org.openoss.qosclient.jms.xvttopic"));
            QueueConnectionFactory qcf = (QueueConnectionFactory)ic.lookup(props.getProperty("org.openoss.qosclient.jms.queueconnectionfactory"));
            queueConnection = qcf.createQueueConnection();
            jmsSession3 = queueConnection.createQueueSession(false, 1);
            xmlMessageQueue = (Queue)ic.lookup(props.getProperty("org.openoss.qosclient.jms.messagequeue"));
            System.out.println("XML Message Queue:" + props.getProperty("org.openoss.qosclient.jms.messagequeue"));
            queueConnection.start();
        }
        catch (Exception ex) {
            System.out.println("Problem connecting to JMS sessions:" + ex);
        }
        finally {
            ic.close();
        }
    }

    public void kill() throws Exception {
        session.remove();
        this.am = null;
        alarmInternals = null;
        conn.stop();
        jmsSession.close();
        conn.close();
        conn2.stop();
        queueConnection.stop();
        jmsSession2.close();
        jmsSession3.close();
        queueConnection.close();
    }

    static {
        eventTopic = null;
        jmsSession = null;
        conn = null;
        CONNECTED = false;
        jmsSession2 = null;
        conn2 = null;
        xvteventTopic = null;
        jmsSession3 = null;
        queueConnection = null;
        xmlMessageQueue = null;
        TERMINATED_MESSAGE = true;
        USE_XVT = false;
        sentinalXMLtest2 = "<Event>\n    <eventRank>original</eventRank>\n    <systemClass>opennms ossj</systemClass>\n    <systemInstance>ApplicationDN</systemInstance>\n    <eventId>AlarmPrimaryKey</eventId>\n    <dataType>X733</dataType>\n    <originatingTime>EventTime</originatingTime>\n    <updateState>terminated</updateState>\n</Event> \n";
    }
}

