/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.fm.monitor.spring;

import java.io.Serializable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.jms.TopicSubscriber;
import org.openoss.ossj.fm.monitor.spring.OssBeanEventReceiver;
import org.openoss.ossj.fm.monitor.spring.OssBeanReceiverImpl;

public class OssBeanEventReceiverImpl
extends OssBeanReceiverImpl
implements OssBeanEventReceiver {
    protected TopicSubscriber eventSubscriber = null;
    int unknownObjectMessage_count = 0;
    int unknownIRPEvt_count = 0;
    protected Boolean use_xvt = null;

    public boolean isUse_xvt() {
        return this.use_xvt;
    }

    public void setUse_xvt(boolean use_xvt) {
        this.use_xvt = use_xvt;
    }

    public int getUnknownIRPEvt_count() {
        return this.unknownIRPEvt_count;
    }

    public int getUnknownObjectMessage_count() {
        return this.unknownObjectMessage_count;
    }

    public String getRuntimeStatistics() {
        String statistics = "Event Counts:- \tUnknownIRPEvt:" + this.unknownIRPEvt_count + "\tUnknownObjMsg:" + this.unknownObjectMessage_count + "\tNonObjMsg:" + this.nonObjectMessage_count + "\tObjMsg:" + this.objectMessage_count + "\tTxtMsg:" + this.txtMessage_count;
        return statistics;
    }

    protected void receive_messages() {
        if (!this.connected) {
            throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Receiver must be initialised using Init() before run()");
        }
        if (this.use_xvt == null) {
            throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): use_xvt is not set. Must be set true or false using setUse_xvt() : ");
        }
        if (this.isUse_xvt()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Use_XVT=true eventSubscriber = xvtEventSubscriber; : "));
            }
            this.eventSubscriber = this.xvtEventSubscriber;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Use_XVT=false eventSubscriber = jvtEventSubscriber;  "));
            }
            this.eventSubscriber = this.jvtEventSubscriber;
        }
        while (this.connected && this.runBean.isRun()) {
            try {
                Serializable objectMessage = null;
                Message msg = null;
                if (!this.use_xvt.booleanValue()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": ***Waiting for OSS/J JVT JMS object message event***"));
                    }
                    while (this.connected && msg == null) {
                        msg = this.eventSubscriber.receive(1000L);
                    }
                    if (msg == null) {
                        this.connected = false;
                        break;
                    }
                    if (!(msg instanceof ObjectMessage)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Recieved non object message on JVT Topic:\n" + msg.toString()));
                        }
                        ++this.nonObjectMessage_count;
                        continue;
                    }
                    objectMessage = ((ObjectMessage)msg).getObject();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Recieved object message on JVT Topic:objectMessage.toString()=" + objectMessage.toString()));
                    }
                    ++this.objectMessage_count;
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": ***Waiting for OSS/J XVT XML JMS text message event***"));
                }
                while (this.connected && msg == null) {
                    msg = this.eventSubscriber.receive(1000L);
                }
                if (msg == null) {
                    this.connected = false;
                    break;
                }
                if (!(msg instanceof TextMessage)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Recieved unexpected non text message on XVT queue" + msg.toString()));
                    }
                    ++this.objectMessage_count;
                    continue;
                }
                TextMessage tm = (TextMessage)msg;
                String received = tm.getText();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Received XML: \n" + received));
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Exception: "));
                }
                ex.printStackTrace();
                this.connected = false;
            }
        }
        try {
            this.connected = false;
            this.eventSubscriber.close();
            this.eventSubscriber = null;
        }
        catch (Exception ex) {
            logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Exception in closing eventSubscriber(): " + ex));
        }
    }
}

