/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.LinkedList;
import java.util.List;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class PacketCollector {
    private static final int MAX_PACKETS = 65536;
    private PacketFilter packetFilter;
    private LinkedList resultQueue;
    private PacketReader packetReader;
    private boolean cancelled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PacketCollector(PacketReader packetReader, PacketFilter packetFilter) {
        this.packetReader = packetReader;
        this.packetFilter = packetFilter;
        this.resultQueue = new LinkedList();
        List list = packetReader.collectors;
        synchronized (list) {
            packetReader.collectors.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            List list = this.packetReader.collectors;
            synchronized (list) {
                int index = this.packetReader.collectors.indexOf(this);
                this.packetReader.collectors.set(index, null);
            }
        }
    }

    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    public synchronized Packet pollResult() {
        if (this.resultQueue.isEmpty()) {
            return null;
        }
        return (Packet)this.resultQueue.removeLast();
    }

    public synchronized Packet nextResult() {
        while (this.resultQueue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return (Packet)this.resultQueue.removeLast();
    }

    public synchronized Packet nextResult(long timeout) {
        if (this.resultQueue.isEmpty()) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.resultQueue.isEmpty()) {
            return null;
        }
        return (Packet)this.resultQueue.removeLast();
    }

    protected synchronized void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            if (this.resultQueue.size() == 65536) {
                this.resultQueue.removeLast();
            }
            this.resultQueue.addFirst(packet);
            this.notifyAll();
        }
    }
}

