/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;

public class HorizontalPanel
extends CellPanel
implements HasAlignment {
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign = ALIGN_LEFT;
    private Element tableRow;
    private HasVerticalAlignment.VerticalAlignmentConstant vertAlign = ALIGN_TOP;

    public HorizontalPanel() {
        this.tableRow = DOM.createTR();
        DOM.appendChild(this.getBody(), this.tableRow);
        DOM.setElementProperty(this.getTable(), "cellSpacing", "0");
        DOM.setElementProperty(this.getTable(), "cellPadding", "0");
    }

    public void add(Widget w) {
        Element td = this.createAlignedTd();
        DOM.appendChild(this.tableRow, td);
        super.add(w, td);
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    public HasVerticalAlignment.VerticalAlignmentConstant getVerticalAlignment() {
        return this.vertAlign;
    }

    public void insert(Widget w, int beforeIndex) {
        this.checkIndexBoundsForInsertion(beforeIndex);
        Element td = this.createAlignedTd();
        DOM.insertChild(this.tableRow, td, beforeIndex);
        super.insert(w, td, beforeIndex, false);
    }

    public boolean remove(Widget w) {
        Element td = DOM.getParent(w.getElement());
        boolean removed = super.remove(w);
        if (removed) {
            DOM.removeChild(this.tableRow, td);
        }
        return removed;
    }

    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.horzAlign = align;
    }

    public void setVerticalAlignment(HasVerticalAlignment.VerticalAlignmentConstant align) {
        this.vertAlign = align;
    }

    private Element createAlignedTd() {
        Element td = DOM.createTD();
        this.setCellHorizontalAlignment(td, this.horzAlign);
        this.setCellVerticalAlignment(td, this.vertAlign);
        return td;
    }
}

