/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;

public class AbsolutePanel
extends ComplexPanel {
    private static void changeToStaticPositioning(Element elem) {
        DOM.setStyleAttribute(elem, "left", "");
        DOM.setStyleAttribute(elem, "top", "");
        DOM.setStyleAttribute(elem, "position", "");
    }

    public AbsolutePanel() {
        this.setElement(DOM.createDiv());
        DOM.setStyleAttribute(this.getElement(), "position", "relative");
        DOM.setStyleAttribute(this.getElement(), "overflow", "hidden");
    }

    public void add(Widget w) {
        super.add(w, this.getElement());
    }

    public void add(Widget w, int left, int top) {
        w.removeFromParent();
        this.setWidgetPositionImpl(w, left, top);
        this.add(w);
    }

    public int getWidgetLeft(Widget w) {
        this.checkWidgetParent(w);
        return DOM.getAbsoluteLeft(w.getElement()) - DOM.getAbsoluteLeft(this.getElement());
    }

    public int getWidgetTop(Widget w) {
        this.checkWidgetParent(w);
        return DOM.getAbsoluteTop(w.getElement()) - DOM.getAbsoluteTop(this.getElement());
    }

    public boolean remove(Widget w) {
        boolean removed = super.remove(w);
        if (removed) {
            AbsolutePanel.changeToStaticPositioning(w.getElement());
        }
        return removed;
    }

    public void setWidgetPosition(Widget w, int left, int top) {
        this.checkWidgetParent(w);
        this.setWidgetPositionImpl(w, left, top);
    }

    private void checkWidgetParent(Widget w) {
        if (w.getParent() != this) {
            throw new IllegalArgumentException("Widget must be a child of this panel.");
        }
    }

    private void setWidgetPositionImpl(Widget w, int left, int top) {
        Element h = w.getElement();
        if (left == -1 && top == -1) {
            AbsolutePanel.changeToStaticPositioning(h);
        } else {
            DOM.setStyleAttribute(h, "position", "absolute");
            DOM.setStyleAttribute(h, "left", left + "px");
            DOM.setStyleAttribute(h, "top", top + "px");
        }
    }
}

