/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateRecord;
import com.google.gwt.i18n.client.constants.DateTimeConstants;
import java.util.ArrayList;
import java.util.Date;

public class DateTimeFormat {
    private static final int FULL_DATE_FORMAT = 0;
    private static final int LONG_DATE_FORMAT = 1;
    private static final int MEDIUM_DATE_FORMAT = 2;
    private static final int SHORT_DATE_FORMAT = 3;
    private static final int FULL_TIME_FORMAT = 0;
    private static final int LONG_TIME_FORMAT = 1;
    private static final int MEDIUM_TIME_FORMAT = 2;
    private static final int SHORT_TIME_FORMAT = 3;
    private static final int NUMBER_BASE = 10;
    private static final int JS_START_YEAR = 1900;
    private static DateTimeFormat cachedFullDateFormat;
    private static DateTimeFormat cachedLongDateFormat;
    private static DateTimeFormat cachedMediumDateFormat;
    private static DateTimeFormat cachedShortDateFormat;
    private static DateTimeFormat cachedFullTimeFormat;
    private static DateTimeFormat cachedLongTimeFormat;
    private static DateTimeFormat cachedMediumTimeFormat;
    private static DateTimeFormat cachedShortTimeFormat;
    private static DateTimeFormat cachedFullDateTimeFormat;
    private static DateTimeFormat cachedLongDateTimeFormat;
    private static DateTimeFormat cachedMediumDateTimeFormat;
    private static DateTimeFormat cachedShortDateTimeFormat;
    private static final DateTimeConstants defaultDateTimeConstants;
    private static final String PATTERN_CHARS = "GyMdkHmsSEDahKzZv";
    private static final String NUMERIC_FORMAT_CHARS = "MydhHmsSDkK";
    private static final String WHITE_SPACE = " \t\r\n";
    private static final String GMT = "GMT";
    private static final int MINUTES_PER_HOUR = 60;
    private final ArrayList patternParts = new ArrayList();
    private final DateTimeConstants dateTimeConstants;
    private final String pattern;

    public static DateTimeFormat getFormat(String pattern) {
        return new DateTimeFormat(pattern, defaultDateTimeConstants);
    }

    public static DateTimeFormat getFullDateFormat() {
        if (cachedFullDateFormat == null) {
            String pattern = defaultDateTimeConstants.dateFormats()[0];
            cachedFullDateFormat = new DateTimeFormat(pattern);
        }
        return cachedFullDateFormat;
    }

    public static DateTimeFormat getFullDateTimeFormat() {
        if (cachedFullDateTimeFormat == null) {
            String pattern = defaultDateTimeConstants.dateFormats()[0] + " " + defaultDateTimeConstants.timeFormats()[0];
            cachedFullDateTimeFormat = new DateTimeFormat(pattern);
        }
        return cachedFullDateTimeFormat;
    }

    public static DateTimeFormat getFullTimeFormat() {
        if (cachedFullTimeFormat == null) {
            String pattern = defaultDateTimeConstants.timeFormats()[0];
            cachedFullTimeFormat = new DateTimeFormat(pattern);
        }
        return cachedFullTimeFormat;
    }

    public static DateTimeFormat getLongDateFormat() {
        if (cachedLongDateFormat == null) {
            String pattern = defaultDateTimeConstants.dateFormats()[1];
            cachedLongDateFormat = new DateTimeFormat(pattern);
        }
        return cachedLongDateFormat;
    }

    public static DateTimeFormat getLongDateTimeFormat() {
        if (cachedLongDateTimeFormat == null) {
            String pattern = defaultDateTimeConstants.dateFormats()[1] + " " + defaultDateTimeConstants.timeFormats()[1];
            cachedLongDateTimeFormat = new DateTimeFormat(pattern);
        }
        return cachedLongDateTimeFormat;
    }

    public static DateTimeFormat getLongTimeFormat() {
        if (cachedLongTimeFormat == null) {
            String pattern = defaultDateTimeConstants.timeFormats()[1];
            cachedLongTimeFormat = new DateTimeFormat(pattern);
        }
        return cachedLongTimeFormat;
    }

    public static DateTimeFormat getMediumDateFormat() {
        if (cachedMediumDateFormat == null) {
            String pattern = defaultDateTimeConstants.dateFormats()[2];
            cachedMediumDateFormat = new DateTimeFormat(pattern);
        }
        return cachedMediumDateFormat;
    }

    public static DateTimeFormat getMediumDateTimeFormat() {
        if (cachedMediumDateTimeFormat == null) {
            String pattern = defaultDateTimeConstants.dateFormats()[2] + " " + defaultDateTimeConstants.timeFormats()[2];
            cachedMediumDateTimeFormat = new DateTimeFormat(pattern);
        }
        return cachedMediumDateTimeFormat;
    }

    public static DateTimeFormat getMediumTimeFormat() {
        if (cachedMediumTimeFormat == null) {
            String pattern = defaultDateTimeConstants.timeFormats()[2];
            cachedMediumTimeFormat = new DateTimeFormat(pattern);
        }
        return cachedMediumTimeFormat;
    }

    public static DateTimeFormat getShortDateFormat() {
        if (cachedShortDateFormat == null) {
            String pattern = defaultDateTimeConstants.dateFormats()[3];
            cachedShortDateFormat = new DateTimeFormat(pattern);
        }
        return cachedShortDateFormat;
    }

    public static DateTimeFormat getShortDateTimeFormat() {
        if (cachedShortDateTimeFormat == null) {
            String pattern = defaultDateTimeConstants.dateFormats()[3] + " " + defaultDateTimeConstants.timeFormats()[3];
            cachedShortDateTimeFormat = new DateTimeFormat(pattern);
        }
        return cachedShortDateTimeFormat;
    }

    public static DateTimeFormat getShortTimeFormat() {
        if (cachedShortTimeFormat == null) {
            String pattern = defaultDateTimeConstants.timeFormats()[3];
            cachedShortTimeFormat = new DateTimeFormat(pattern);
        }
        return cachedShortTimeFormat;
    }

    protected DateTimeFormat(String pattern) {
        this(pattern, defaultDateTimeConstants);
    }

    protected DateTimeFormat(String pattern, DateTimeConstants dateTimeConstants) {
        this.pattern = pattern;
        this.dateTimeConstants = dateTimeConstants;
        this.parsePattern(pattern);
    }

    public String format(Date date) {
        StringBuffer toAppendTo = new StringBuffer(64);
        int n = this.pattern.length();
        int i = 0;
        while (i < n) {
            int j;
            char ch = this.pattern.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                for (j = i + 1; j < n && this.pattern.charAt(j) == ch; ++j) {
                }
                this.subFormat(toAppendTo, ch, j - i, date);
                i = j;
                continue;
            }
            if (ch == '\'') {
                if (++i < n && this.pattern.charAt(i) == '\'') {
                    toAppendTo.append('\'');
                    ++i;
                    continue;
                }
                boolean trailQuote = false;
                while (!trailQuote) {
                    for (j = i; j < n && this.pattern.charAt(j) != '\''; ++j) {
                    }
                    if (j >= n) {
                        throw new IllegalArgumentException("Missing trailing '");
                    }
                    if (j + 1 < n && this.pattern.charAt(j + 1) == '\'') {
                        ++j;
                    } else {
                        trailQuote = true;
                    }
                    toAppendTo.append(this.pattern.substring(i, j));
                    i = j + 1;
                }
                continue;
            }
            toAppendTo.append(ch);
            ++i;
        }
        return toAppendTo.toString();
    }

    public String getPattern() {
        return this.pattern;
    }

    public Date parse(String text) {
        Date date = new Date();
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
        int charsConsumed = this.parse(text, 0, date);
        if (charsConsumed == 0 || charsConsumed < text.length()) {
            throw new IllegalArgumentException(text);
        }
        return date;
    }

    public int parse(String text, int start, Date date) {
        DateRecord cal = new DateRecord();
        int[] parsePos = new int[]{start};
        int abutPat = -1;
        int abutStart = 0;
        int abutPass = 0;
        for (int i = 0; i < this.patternParts.size(); ++i) {
            PatternPart part = (PatternPart)this.patternParts.get(i);
            if (part.count > 0) {
                if (abutPat < 0 && part.abutStart) {
                    abutPat = i;
                    abutStart = start;
                    abutPass = 0;
                }
                if (abutPat >= 0) {
                    int count = part.count;
                    if (i == abutPat && (count -= abutPass++) == 0) {
                        return 0;
                    }
                    if (this.subParse(text, parsePos, part, count, cal)) continue;
                    i = abutPat - 1;
                    parsePos[0] = abutStart;
                    continue;
                }
                abutPat = -1;
                if (this.subParse(text, parsePos, part, 0, cal)) continue;
                return 0;
            }
            abutPat = -1;
            if (part.text.charAt(0) == ' ') {
                int s = parsePos[0];
                this.skipSpace(text, parsePos);
                if (parsePos[0] > s) {
                    continue;
                }
            } else if (text.startsWith(part.text, parsePos[0])) {
                parsePos[0] = parsePos[0] + part.text.length();
                continue;
            }
            return 0;
        }
        if (!cal.calcDate(date)) {
            return 0;
        }
        return parsePos[0] - start;
    }

    private void addPart(StringBuffer buf, int count) {
        if (buf.length() > 0) {
            this.patternParts.add(new PatternPart(buf.toString(), count));
            buf.setLength(0);
        }
    }

    private void appendGMT(StringBuffer buf, Date date) {
        int value = -date.getTimezoneOffset();
        if (value < 0) {
            buf.append("GMT-");
            value = -value;
        } else {
            buf.append("GMT+");
        }
        this.zeroPaddingNumber(buf, value / 60, 2);
        buf.append(':');
        this.zeroPaddingNumber(buf, value % 60, 2);
    }

    private void format0To11Hours(StringBuffer buf, int count, Date date) {
        int value = date.getHours() % 12;
        this.zeroPaddingNumber(buf, value, count);
    }

    private void format0To23Hours(StringBuffer buf, int count, Date date) {
        int value = date.getHours();
        this.zeroPaddingNumber(buf, value, count);
    }

    private void format1To12Hours(StringBuffer buf, int count, Date date) {
        int value = date.getHours() % 12;
        if (value == 0) {
            this.zeroPaddingNumber(buf, 12, count);
        } else {
            this.zeroPaddingNumber(buf, value, count);
        }
    }

    private void format24Hours(StringBuffer buf, int count, Date date) {
        int value = date.getHours();
        if (value == 0) {
            this.zeroPaddingNumber(buf, 24, count);
        } else {
            this.zeroPaddingNumber(buf, value, count);
        }
    }

    private void formatAmPm(StringBuffer buf, int count, Date date) {
        if (date.getHours() >= 12 && date.getHours() < 24) {
            buf.append(this.dateTimeConstants.ampms()[1]);
        } else {
            buf.append(this.dateTimeConstants.ampms()[0]);
        }
    }

    private void formatDate(StringBuffer buf, int count, Date date) {
        int value = date.getDate();
        this.zeroPaddingNumber(buf, value, count);
    }

    private void formatDayOfWeek(StringBuffer buf, int count, Date date) {
        int value = date.getDay();
        if (count >= 4) {
            buf.append(this.dateTimeConstants.weekdays()[value]);
        } else {
            buf.append(this.dateTimeConstants.shortWeekdays()[value]);
        }
    }

    private void formatEra(StringBuffer buf, int count, Date date) {
        int value;
        int n = value = date.getYear() >= -1900 ? 1 : 0;
        if (count >= 4) {
            buf.append(this.dateTimeConstants.eraNames()[value]);
        } else {
            buf.append(this.dateTimeConstants.eras()[value]);
        }
    }

    private void formatFractionalSeconds(StringBuffer buf, int count, Date date) {
        int value = (int)(date.getTime() % 1000L);
        if (count == 1) {
            value = (value + 50) / 100;
            buf.append(Integer.toString(value));
        } else if (count == 2) {
            value = (value + 5) / 10;
            this.zeroPaddingNumber(buf, value, 2);
        } else {
            this.zeroPaddingNumber(buf, value, 3);
            if (count > 3) {
                this.zeroPaddingNumber(buf, 0, count - 3);
            }
        }
    }

    private void formatMinutes(StringBuffer buf, int count, Date date) {
        int value = date.getMinutes();
        this.zeroPaddingNumber(buf, value, count);
    }

    private void formatMonth(StringBuffer buf, int count, Date date) {
        int value = date.getMonth();
        switch (count) {
            case 5: {
                buf.append(this.dateTimeConstants.narrowMonths()[value]);
                break;
            }
            case 4: {
                buf.append(this.dateTimeConstants.standaloneMonths()[value]);
                break;
            }
            case 3: {
                buf.append(this.dateTimeConstants.shortMonths()[value]);
                break;
            }
            default: {
                this.zeroPaddingNumber(buf, value + 1, count);
            }
        }
    }

    private void formatQuarter(StringBuffer buf, int count, Date date) {
        int value = date.getMonth() / 3;
        if (count < 4) {
            buf.append(this.dateTimeConstants.shortQuarters()[value]);
        } else {
            buf.append(this.dateTimeConstants.quarters()[value]);
        }
    }

    private void formatSeconds(StringBuffer buf, int count, Date date) {
        int value = date.getSeconds();
        this.zeroPaddingNumber(buf, value, count);
    }

    private void formatStandaloneDay(StringBuffer buf, int count, Date date) {
        int value = date.getDay();
        if (count == 5) {
            buf.append(this.dateTimeConstants.standaloneNarrowWeekdays()[value]);
        } else if (count == 4) {
            buf.append(this.dateTimeConstants.standaloneWeekdays()[value]);
        } else if (count == 3) {
            buf.append(this.dateTimeConstants.standaloneShortWeekdays()[value]);
        } else {
            this.zeroPaddingNumber(buf, value, 1);
        }
    }

    private void formatStandaloneMonth(StringBuffer buf, int count, Date date) {
        int value = date.getMonth();
        if (count == 5) {
            buf.append(this.dateTimeConstants.standaloneNarrowMonths()[value]);
        } else if (count == 4) {
            buf.append(this.dateTimeConstants.standaloneMonths()[value]);
        } else if (count == 3) {
            buf.append(this.dateTimeConstants.standaloneShortMonths()[value]);
        } else {
            this.zeroPaddingNumber(buf, value + 1, count);
        }
    }

    private void formatTimeZoneRFC(StringBuffer buf, int count, Date date) {
        if (count < 4) {
            int val = date.getTimezoneOffset();
            char sign = '-';
            if (val < 0) {
                val = -val;
                sign = '+';
            }
            val = val / 3 * 5 + val % 60;
            buf.append(sign);
            this.zeroPaddingNumber(buf, val, 4);
        } else {
            this.appendGMT(buf, date);
        }
    }

    private void formatYear(StringBuffer buf, int count, Date date) {
        int value = date.getYear() + 1900;
        if (value < 0) {
            value = -value;
        }
        if (count == 2) {
            this.zeroPaddingNumber(buf, value % 100, 2);
        } else {
            buf.append(Integer.toString(value));
        }
    }

    private int getNextCharCountInPattern(String pattern, int start) {
        int next;
        char ch = pattern.charAt(start);
        for (next = start + 1; next < pattern.length() && pattern.charAt(next) == ch; ++next) {
        }
        return next - start;
    }

    private void identifyAbutStart() {
        boolean abut = false;
        int len = this.patternParts.size();
        for (int i = 0; i < len; ++i) {
            if (this.isNumeric((PatternPart)this.patternParts.get(i))) {
                if (abut || i + 1 >= len || !this.isNumeric((PatternPart)this.patternParts.get(i + 1))) continue;
                abut = true;
                ((PatternPart)this.patternParts.get((int)i)).abutStart = true;
                continue;
            }
            abut = false;
        }
    }

    private final boolean isNumeric(PatternPart part) {
        if (part.count <= 0) {
            return false;
        }
        int i = NUMERIC_FORMAT_CHARS.indexOf(part.text.charAt(0));
        return i > 0 || i == 0 && part.count < 3;
    }

    private int matchString(String text, int start, String[] data, int[] pos) {
        int count = data.length;
        int bestMatchLength = 0;
        int bestMatch = -1;
        String textInLowerCase = text.substring(start).toLowerCase();
        for (int i = 0; i < count; ++i) {
            int length = data[i].length();
            if (length <= bestMatchLength || !textInLowerCase.startsWith(data[i].toLowerCase())) continue;
            bestMatch = i;
            bestMatchLength = length;
        }
        if (bestMatch >= 0) {
            pos[0] = start + bestMatchLength;
        }
        return bestMatch;
    }

    private int parseInt(String text, int[] pos) {
        int ret = 0;
        int ind = pos[0];
        char ch = text.charAt(ind);
        while (ch >= '0' && ch <= '9') {
            ret = ret * 10 + (ch - 48);
            if (++ind >= text.length()) break;
            ch = text.charAt(ind);
        }
        if (ind > pos[0]) {
            pos[0] = ind;
        } else {
            ret = -1;
        }
        return ret;
    }

    private void parsePattern(String pattern) {
        StringBuffer buf = new StringBuffer(32);
        boolean inQuote = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == ' ') {
                this.addPart(buf, 0);
                buf.append(' ');
                this.addPart(buf, 0);
                while (i + 1 < pattern.length() && pattern.charAt(i + 1) == ' ') {
                    ++i;
                }
                continue;
            }
            if (inQuote) {
                if (ch == '\'') {
                    if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\'') {
                        buf.append(ch);
                        ++i;
                        continue;
                    }
                    inQuote = false;
                    continue;
                }
                buf.append(ch);
                continue;
            }
            if (PATTERN_CHARS.indexOf(ch) > 0) {
                this.addPart(buf, 0);
                buf.append(ch);
                int count = this.getNextCharCountInPattern(pattern, i);
                this.addPart(buf, count);
                i += count - 1;
                continue;
            }
            if (ch == '\'') {
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\'') {
                    buf.append('\'');
                    ++i;
                    continue;
                }
                inQuote = true;
                continue;
            }
            buf.append(ch);
        }
        this.addPart(buf, 0);
        this.identifyAbutStart();
    }

    private boolean parseTimeZoneOffset(String text, int[] pos, DateRecord cal) {
        int offset;
        int sign;
        if (pos[0] >= text.length()) {
            cal.setTzOffset(0);
            return true;
        }
        switch (text.charAt(pos[0])) {
            case '+': {
                sign = 1;
                break;
            }
            case '-': {
                sign = -1;
                break;
            }
            default: {
                cal.setTzOffset(0);
                return true;
            }
        }
        pos[0] = pos[0] + 1;
        int st = pos[0];
        int value = this.parseInt(text, pos);
        if (value == 0 && pos[0] == st) {
            return false;
        }
        if (pos[0] < text.length() && text.charAt(pos[0]) == ':') {
            offset = value * 60;
            pos[0] = pos[0] + 1;
            st = pos[0];
            value = this.parseInt(text, pos);
            if (value == 0 && pos[0] == st) {
                return false;
            }
            offset += value;
        } else {
            offset = value;
            offset = offset < 24 && pos[0] - st <= 2 ? (offset *= 60) : offset % 100 + offset / 100 * 60;
        }
        cal.setTzOffset(-(offset *= sign));
        return true;
    }

    private void skipSpace(String text, int[] pos) {
        while (pos[0] < text.length() && WHITE_SPACE.indexOf(text.charAt(pos[0])) >= 0) {
            pos[0] = pos[0] + 1;
        }
    }

    private boolean subFormat(StringBuffer buf, char ch, int count, Date date) {
        switch (ch) {
            case 'G': {
                this.formatEra(buf, count, date);
                break;
            }
            case 'y': {
                this.formatYear(buf, count, date);
                break;
            }
            case 'M': {
                this.formatMonth(buf, count, date);
                break;
            }
            case 'k': {
                this.format24Hours(buf, count, date);
                break;
            }
            case 'S': {
                this.formatFractionalSeconds(buf, count, date);
                break;
            }
            case 'E': {
                this.formatDayOfWeek(buf, count, date);
                break;
            }
            case 'a': {
                this.formatAmPm(buf, count, date);
                break;
            }
            case 'h': {
                this.format1To12Hours(buf, count, date);
                break;
            }
            case 'K': {
                this.format0To11Hours(buf, count, date);
                break;
            }
            case 'H': {
                this.format0To23Hours(buf, count, date);
                break;
            }
            case 'c': {
                this.formatStandaloneDay(buf, count, date);
                break;
            }
            case 'L': {
                this.formatStandaloneMonth(buf, count, date);
                break;
            }
            case 'Q': {
                this.formatQuarter(buf, count, date);
                break;
            }
            case 'd': {
                this.formatDate(buf, count, date);
                break;
            }
            case 'm': {
                this.formatMinutes(buf, count, date);
                break;
            }
            case 's': {
                this.formatSeconds(buf, count, date);
                break;
            }
            case 'v': 
            case 'z': {
                this.appendGMT(buf, date);
                break;
            }
            case 'Z': {
                this.formatTimeZoneRFC(buf, count, date);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean subParse(String text, int[] pos, PatternPart part, int digitCount, DateRecord cal) {
        this.skipSpace(text, pos);
        int start = pos[0];
        char ch = part.text.charAt(0);
        int value = -1;
        if (this.isNumeric(part)) {
            if (digitCount > 0) {
                if (start + digitCount > text.length()) {
                    return false;
                }
                value = this.parseInt(text.substring(0, start + digitCount), pos);
            } else {
                value = this.parseInt(text, pos);
            }
        }
        switch (ch) {
            case 'G': {
                value = this.matchString(text, start, this.dateTimeConstants.eras(), pos);
                cal.setEra(value);
                return true;
            }
            case 'M': {
                return this.subParseMonth(text, pos, cal, value, start);
            }
            case 'E': {
                return this.subParseDayOfWeek(text, pos, start, cal);
            }
            case 'a': {
                value = this.matchString(text, start, this.dateTimeConstants.ampms(), pos);
                cal.setAmpm(value);
                return true;
            }
            case 'y': {
                return this.subParseYear(text, pos, start, value, part, cal);
            }
            case 'd': {
                cal.setDayOfMonth(value);
                return true;
            }
            case 'S': {
                return this.subParseFractionalSeconds(value, start, pos[0], cal);
            }
            case 'h': {
                if (value == 12) {
                    value = 0;
                }
            }
            case 'H': 
            case 'K': {
                cal.setHours(value);
                return true;
            }
            case 'k': {
                cal.setHours(value);
                return true;
            }
            case 'm': {
                cal.setMinutes(value);
                return true;
            }
            case 's': {
                cal.setSeconds(value);
                return true;
            }
            case 'Z': 
            case 'v': 
            case 'z': {
                return this.subParseTimeZoneInGMT(text, start, pos, cal);
            }
        }
        return false;
    }

    private boolean subParseDayOfWeek(String text, int[] pos, int start, DateRecord cal) {
        int value = this.matchString(text, start, this.dateTimeConstants.weekdays(), pos);
        if (value < 0) {
            value = this.matchString(text, start, this.dateTimeConstants.shortWeekdays(), pos);
        }
        if (value < 0) {
            return false;
        }
        cal.setDayOfWeek(value);
        return true;
    }

    private boolean subParseFractionalSeconds(int value, int start, int end, DateRecord cal) {
        int i = end - start;
        if (i < 3) {
            while (i < 3) {
                value *= 10;
                ++i;
            }
        } else {
            int a = 1;
            while (i > 3) {
                a *= 10;
                --i;
            }
            value = (value + (a >> 1)) / a;
        }
        cal.setMilliseconds(value);
        return true;
    }

    private boolean subParseMonth(String text, int[] pos, DateRecord cal, int value, int start) {
        if (value < 0) {
            value = this.matchString(text, start, this.dateTimeConstants.months(), pos);
            if (value < 0) {
                value = this.matchString(text, start, this.dateTimeConstants.shortMonths(), pos);
            }
            if (value < 0) {
                return false;
            }
            cal.setMonth(value);
            return true;
        }
        cal.setMonth(value - 1);
        return true;
    }

    private boolean subParseTimeZoneInGMT(String text, int start, int[] pos, DateRecord cal) {
        if (text.startsWith(GMT, start)) {
            pos[0] = start + GMT.length();
            return this.parseTimeZoneOffset(text, pos, cal);
        }
        return this.parseTimeZoneOffset(text, pos, cal);
    }

    private boolean subParseYear(String text, int[] pos, int start, int value, PatternPart part, DateRecord cal) {
        int ch = 32;
        if (value < 0) {
            ch = text.charAt(pos[0]);
            if (ch != 43 && ch != 45) {
                return false;
            }
            pos[0] = pos[0] + 1;
            value = this.parseInt(text, pos);
            if (value < 0) {
                return false;
            }
            if (ch == 45) {
                value = -value;
            }
        }
        if (ch == 32 && pos[0] - start == 2 && part.count == 2) {
            Date date = new Date();
            int defaultCenturyStartYear = date.getYear() + 1900 - 80;
            int ambiguousTwoDigitYear = defaultCenturyStartYear % 100;
            cal.setAmbiguousYear(value == ambiguousTwoDigitYear);
            value += defaultCenturyStartYear / 100 * 100 + (value < ambiguousTwoDigitYear ? 100 : 0);
        }
        cal.setYear(value);
        return true;
    }

    private void zeroPaddingNumber(StringBuffer buf, int value, int minWidth) {
        int b = 10;
        for (int i = 0; i < minWidth - 1; ++i) {
            if (value < b) {
                buf.append('0');
            }
            b *= 10;
        }
        buf.append(Integer.toString(value));
    }

    static {
        defaultDateTimeConstants = (DateTimeConstants)GWT.create(DateTimeConstants.class);
    }

    private class PatternPart {
        public String text;
        public int count;
        public boolean abutStart;

        public PatternPart(String txt, int cnt) {
            this.text = txt;
            this.count = cnt;
            this.abutStart = false;
        }
    }
}

