/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.PduBuilder;
import org.opennms.netmgt.snmp.ResponseProcessor;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public class SingleInstanceTracker
extends CollectionTracker {
    private SnmpObjId m_base;
    private SnmpInstId m_inst;
    private SnmpObjId m_oid;
    private boolean m_finished = false;

    public SingleInstanceTracker(SnmpObjId base, SnmpInstId inst) {
        this(base, inst, null);
    }

    public SingleInstanceTracker(SnmpObjId base, SnmpInstId inst, CollectionTracker parent) {
        super(parent);
        this.m_base = base;
        this.m_inst = inst;
        this.m_oid = SnmpObjId.get(this.m_base, this.m_inst);
    }

    public void setMaxRepititions(int maxRepititions) {
    }

    public boolean isFinished() {
        return this.m_finished;
    }

    public ResponseProcessor buildNextPdu(PduBuilder pduBuilder) {
        if (pduBuilder.getMaxVarsPerPdu() < 1) {
            throw new IllegalArgumentException("maxVarsPerPdu < 1");
        }
        SnmpObjId requestOid = this.m_oid.decrement();
        this.log().debug((Object)("Requesting oid following: " + requestOid));
        pduBuilder.addOid(requestOid);
        pduBuilder.setNonRepeaters(1);
        pduBuilder.setMaxRepetitions(1);
        ResponseProcessor rp = new ResponseProcessor(){

            public void processResponse(SnmpObjId responseObjId, SnmpValue val) {
                SingleInstanceTracker.this.log().debug((Object)("Processing varBind: " + responseObjId + " = " + val));
                if (val.isEndOfMib()) {
                    SingleInstanceTracker.this.receivedEndOfMib();
                }
                SingleInstanceTracker.this.m_finished = true;
                if (SingleInstanceTracker.this.m_oid.equals(responseObjId)) {
                    SingleInstanceTracker.this.storeResult(SingleInstanceTracker.this.m_base, SingleInstanceTracker.this.m_inst, val);
                }
            }

            public boolean processErrors(int errorStatus, int errorIndex) {
                if (errorStatus == 0) {
                    return false;
                }
                if (errorStatus == 1) {
                    throw new IllegalArgumentException("Unable to handle tooBigError for oid request " + SingleInstanceTracker.this.m_oid.decrement());
                }
                if (errorStatus == 5) {
                    SingleInstanceTracker.this.reportGenErr("Received genErr reqeusting oid " + SingleInstanceTracker.this.m_oid.decrement() + ". Marking column is finished.");
                    SingleInstanceTracker.this.errorOccurred();
                    return true;
                }
                if (errorStatus == 2) {
                    SingleInstanceTracker.this.reportNoSuchNameErr("Received noSuchName reqeusting oid " + SingleInstanceTracker.this.m_oid.decrement() + ". Marking column is finished.");
                    SingleInstanceTracker.this.errorOccurred();
                    return true;
                }
                throw new IllegalArgumentException("Unexpected error processing oid " + SingleInstanceTracker.this.m_oid.decrement() + ". Aborting!");
            }
        };
        return rp;
    }

    protected Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected void errorOccurred() {
        this.m_finished = true;
    }

    protected void receivedEndOfMib() {
        this.m_finished = true;
    }
}

