// This file is part of the OpenNMS(R) MIB Parser.
//
// Copyright (C) 2002-2003 John Rodriguez
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// See: http://www.fsf.org/copyleft/lesser.html
//

/* Generated By:JJTree&JavaCC: Do not edit this line. ParseMibTokenManager.java */
import java.util.Vector;

public class ParseMibTokenManager implements ParseMibConstants
{
  public static  java.io.PrintStream debugStream = System.out;
  public static  void setDebugStream(java.io.PrintStream ds) { debugStream = ds; }
private static final int jjStopStringLiteralDfa_0(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0x1ffffffffffc0L) != 0L)
         {
            jjmatchedKind = 64;
            return 17;
         }
         if ((active0 & 0x200000000000000L) != 0L)
            return 24;
         return -1;
      case 1:
         if ((active0 & 0x1ffffdfffffc0L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 1;
            return 17;
         }
         if ((active0 & 0x20000000L) != 0L)
            return 17;
         return -1;
      case 2:
         if ((active0 & 0x1ffffdfffbfc0L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 2;
            return 17;
         }
         if ((active0 & 0x4000L) != 0L)
            return 17;
         return -1;
      case 3:
         if ((active0 & 0x8000100L) != 0L)
            return 17;
         if ((active0 & 0x1ffffd7ffbec0L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 3;
            return 17;
         }
         return -1;
      case 4:
         if ((active0 & 0x1fefb97febe40L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 4;
            return 17;
         }
         if ((active0 & 0x10440010080L) != 0L)
            return 17;
         return -1;
      case 5:
         if ((active0 & 0x10cf2177c2c40L) != 0L)
         {
            if (jjmatchedPos != 5)
            {
               jjmatchedKind = 64;
               jjmatchedPos = 5;
            }
            return 17;
         }
         if ((active0 & 0xf20980829200L) != 0L)
            return 17;
         return -1;
      case 6:
         if ((active0 & 0x800000000040L) != 0L)
            return 17;
         if ((active0 & 0x13cfa97fc2c00L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 6;
            return 17;
         }
         return -1;
      case 7:
         if ((active0 & 0x13cfa83fc0c00L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 7;
            return 17;
         }
         if ((active0 & 0x14002000L) != 0L)
            return 17;
         return -1;
      case 8:
         if ((active0 & 0x134fa83dc0400L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 8;
            return 17;
         }
         if ((active0 & 0x80000200800L) != 0L)
            return 17;
         return -1;
      case 9:
         if ((active0 & 0x30fa83d00400L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 9;
            return 17;
         }
         if ((active0 & 0x10400000c0000L) != 0L)
            return 17;
         return -1;
      case 10:
         if ((active0 & 0x20fa83d00000L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 10;
            return 17;
         }
         if ((active0 & 0x100000000400L) != 0L)
            return 17;
         return -1;
      case 11:
         if ((active0 & 0x207280900000L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 11;
            return 17;
         }
         if ((active0 & 0x8803400000L) != 0L)
            return 17;
         return -1;
      case 12:
         if ((active0 & 0x205280900000L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 12;
            return 17;
         }
         if ((active0 & 0x2000000000L) != 0L)
            return 17;
         return -1;
      case 13:
         if ((active0 & 0x205280900000L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 13;
            return 17;
         }
         return -1;
      case 14:
         if ((active0 & 0x5280100000L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 14;
            return 17;
         }
         if ((active0 & 0x200000800000L) != 0L)
            return 17;
         return -1;
      case 15:
         if ((active0 & 0x5080100000L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 15;
            return 17;
         }
         if ((active0 & 0x200000000L) != 0L)
            return 17;
         return -1;
      case 16:
         if ((active0 & 0x5000000000L) != 0L)
         {
            jjmatchedKind = 64;
            jjmatchedPos = 16;
            return 17;
         }
         if ((active0 & 0x80100000L) != 0L)
            return 17;
         return -1;
      default :
         return -1;
   }
}
private static final int jjStartNfa_0(int pos, long active0, long active1)
{
   return jjMoveNfa_0(jjStopStringLiteralDfa_0(pos, active0, active1), pos + 1);
}
static private final int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
static private final int jjStartNfaWithStates_0(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_0(state, pos + 1);
}
static private final int jjMoveStringLiteralDfa0_0()
{
   switch(curChar)
   {
      case 34:
         return jjStartNfaWithStates_0(0, 57, 24);
      case 40:
         return jjStopAtPos(0, 49);
      case 41:
         return jjStopAtPos(0, 50);
      case 44:
         return jjStopAtPos(0, 56);
      case 46:
         return jjStopAtPos(0, 68);
      case 58:
         return jjMoveStringLiteralDfa1_0(0x0L, 0x8L);
      case 59:
         return jjStopAtPos(0, 55);
      case 65:
         return jjMoveStringLiteralDfa1_0(0x22000L, 0x0L);
      case 66:
         return jjMoveStringLiteralDfa1_0(0x80L, 0x0L);
      case 67:
         return jjMoveStringLiteralDfa1_0(0x2000000L, 0x0L);
      case 68:
         return jjMoveStringLiteralDfa1_0(0x8000001400L, 0x0L);
      case 69:
         return jjMoveStringLiteralDfa1_0(0x40000004000L, 0x0L);
      case 70:
         return jjMoveStringLiteralDfa1_0(0x100L, 0x0L);
      case 71:
         return jjMoveStringLiteralDfa1_0(0x400000000L, 0x0L);
      case 73:
         return jjMoveStringLiteralDfa1_0(0x1000040000040L, 0x0L);
      case 76:
         return jjMoveStringLiteralDfa1_0(0x400000L, 0x0L);
      case 77:
         return jjMoveStringLiteralDfa1_0(0x3808c0000L, 0x0L);
      case 78:
         return jjMoveStringLiteralDfa1_0(0x3000100000L, 0x0L);
      case 79:
         return jjMoveStringLiteralDfa1_0(0xf10821000000L, 0x0L);
      case 82:
         return jjMoveStringLiteralDfa1_0(0x4000800L, 0x0L);
      case 83:
         return jjMoveStringLiteralDfa1_0(0x20018008200L, 0x0L);
      case 84:
         return jjMoveStringLiteralDfa1_0(0x4000200000L, 0x0L);
      case 85:
         return jjMoveStringLiteralDfa1_0(0x10000L, 0x0L);
      case 86:
         return jjMoveStringLiteralDfa1_0(0x80000000000L, 0x0L);
      case 91:
         return jjStopAtPos(0, 53);
      case 93:
         return jjStopAtPos(0, 54);
      case 123:
         return jjStopAtPos(0, 51);
      case 124:
         return jjStopAtPos(0, 69);
      case 125:
         return jjStopAtPos(0, 52);
      default :
         return jjMoveNfa_0(5, 0);
   }
}
static private final int jjMoveStringLiteralDfa1_0(long active0, long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(0, active0, active1);
      return 1;
   }
   switch(curChar)
   {
      case 58:
         return jjMoveStringLiteralDfa2_0(active0, 0L, active1, 0x8L);
      case 65:
         return jjMoveStringLiteralDfa2_0(active0, 0x80200440000L, active1, 0L);
      case 66:
         return jjMoveStringLiteralDfa2_0(active0, 0xf00800000000L, active1, 0L);
      case 67:
         return jjMoveStringLiteralDfa2_0(active0, 0x10000020000L, active1, 0L);
      case 68:
         return jjMoveStringLiteralDfa2_0(active0, 0x1000000000000L, active1, 0L);
      case 69:
         return jjMoveStringLiteralDfa2_0(active0, 0x4014001c80L, active1, 0L);
      case 70:
         if ((active0 & 0x20000000L) != 0L)
            return jjStartNfaWithStates_0(1, 29, 17);
         break;
      case 73:
         return jjMoveStringLiteralDfa2_0(active0, 0x8008080000L, active1, 0L);
      case 77:
         return jjMoveStringLiteralDfa2_0(active0, 0x40L, active1, 0L);
      case 78:
         return jjMoveStringLiteralDfa2_0(active0, 0x40040014000L, active1, 0L);
      case 79:
         return jjMoveStringLiteralDfa2_0(active0, 0x3182900000L, active1, 0L);
      case 82:
         return jjMoveStringLiteralDfa2_0(active0, 0x401200100L, active1, 0L);
      case 84:
         return jjMoveStringLiteralDfa2_0(active0, 0x20000000200L, active1, 0L);
      case 85:
         return jjMoveStringLiteralDfa2_0(active0, 0x2000L, active1, 0L);
      case 89:
         return jjMoveStringLiteralDfa2_0(active0, 0x8000L, active1, 0L);
      default :
         break;
   }
   return jjStartNfa_0(0, active0, active1);
}
static private final int jjMoveStringLiteralDfa2_0(long old0, long active0, long old1, long active1)
{
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_0(0, old0, old1); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(1, active0, active1);
      return 2;
   }
   switch(curChar)
   {
      case 61:
         if ((active1 & 0x8L) != 0L)
            return jjStopAtPos(2, 67);
         break;
      case 65:
         return jjMoveStringLiteralDfa3_0(active0, 0x200200L, active1, 0L);
      case 67:
         return jjMoveStringLiteralDfa3_0(active0, 0x20000L, active1, 0L);
      case 68:
         if ((active0 & 0x4000L) != 0L)
            return jjStartNfaWithStates_0(2, 14, 17);
         return jjMoveStringLiteralDfa3_0(active0, 0x1c0800000L, active1, 0L);
      case 69:
         return jjMoveStringLiteralDfa3_0(active0, 0x1000000000000L, active1, 0L);
      case 70:
         return jjMoveStringLiteralDfa3_0(active0, 0x1800L, active1, 0L);
      case 71:
         return jjMoveStringLiteralDfa3_0(active0, 0x1002080L, active1, 0L);
      case 73:
         return jjMoveStringLiteralDfa3_0(active0, 0x10000L, active1, 0L);
      case 74:
         return jjMoveStringLiteralDfa3_0(active0, 0xf00800000000L, active1, 0L);
      case 78:
         return jjMoveStringLiteralDfa3_0(active0, 0x202088000L, active1, 0L);
      case 79:
         return jjMoveStringLiteralDfa3_0(active0, 0x400000100L, active1, 0L);
      case 80:
         return jjMoveStringLiteralDfa3_0(active0, 0x40L, active1, 0L);
      case 81:
         return jjMoveStringLiteralDfa3_0(active0, 0x10000000L, active1, 0L);
      case 82:
         return jjMoveStringLiteralDfa3_0(active0, 0xa0000000000L, active1, 0L);
      case 83:
         return jjMoveStringLiteralDfa3_0(active0, 0x8000400400L, active1, 0L);
      case 84:
         return jjMoveStringLiteralDfa3_0(active0, 0x53000100000L, active1, 0L);
      case 86:
         return jjMoveStringLiteralDfa3_0(active0, 0x4000000L, active1, 0L);
      case 88:
         return jjMoveStringLiteralDfa3_0(active0, 0x4000040000L, active1, 0L);
      case 90:
         return jjMoveStringLiteralDfa3_0(active0, 0x8000000L, active1, 0L);
      default :
         break;
   }
   return jjStartNfa_0(1, active0, active1);
}
static private final int jjMoveStringLiteralDfa3_0(long old0, long active0, long old1, long active1)
{
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_0(1, old0, old1); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(2, active0, 0L);
      return 3;
   }
   switch(curChar)
   {
      case 45:
         return jjMoveStringLiteralDfa4_0(active0, 0xc0000L);
      case 65:
         return jjMoveStringLiteralDfa4_0(active0, 0x1000000L);
      case 67:
         return jjMoveStringLiteralDfa4_0(active0, 0x400L);
      case 68:
         return jjMoveStringLiteralDfa4_0(active0, 0x200000000L);
      case 69:
         if ((active0 & 0x8000000L) != 0L)
            return jjStartNfaWithStates_0(3, 27, 17);
         return jjMoveStringLiteralDfa4_0(active0, 0xf50840020800L);
      case 73:
         return jjMoveStringLiteralDfa4_0(active0, 0xa3004100080L);
      case 77:
         if ((active0 & 0x100L) != 0L)
            return jjStartNfaWithStates_0(3, 8, 17);
         return jjMoveStringLiteralDfa4_0(active0, 0x2000L);
      case 78:
         return jjMoveStringLiteralDfa4_0(active0, 0x1000000000000L);
      case 79:
         return jjMoveStringLiteralDfa4_0(active0, 0x40L);
      case 80:
         return jjMoveStringLiteralDfa4_0(active0, 0x8000200000L);
      case 84:
         return jjMoveStringLiteralDfa4_0(active0, 0x4002418200L);
      case 85:
         return jjMoveStringLiteralDfa4_0(active0, 0x590800000L);
      case 86:
         return jjMoveStringLiteralDfa4_0(active0, 0x1000L);
      default :
         break;
   }
   return jjStartNfa_0(2, active0, 0L);
}
static private final int jjMoveStringLiteralDfa4_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(2, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(3, active0, 0L);
      return 4;
   }
   switch(curChar)
   {
      case 45:
         return jjMoveStringLiteralDfa5_0(active0, 0x600000L);
      case 65:
         return jjMoveStringLiteralDfa5_0(active0, 0x802020c9000L);
      case 67:
         return jjMoveStringLiteralDfa5_0(active0, 0xf00800000000L);
      case 69:
         return jjMoveStringLiteralDfa5_0(active0, 0x10002000L);
      case 70:
         return jjMoveStringLiteralDfa5_0(active0, 0x3000100000L);
      case 76:
         return jjMoveStringLiteralDfa5_0(active0, 0x8180800000L);
      case 78:
         if ((active0 & 0x80L) != 0L)
            return jjStartNfaWithStates_0(4, 7, 17);
         return jjMoveStringLiteralDfa5_0(active0, 0x20001000000L);
      case 80:
         if ((active0 & 0x400000000L) != 0L)
            return jjStartNfaWithStates_0(4, 34, 17);
         break;
      case 82:
         return jjMoveStringLiteralDfa5_0(active0, 0x40000000c40L);
      case 83:
         if ((active0 & 0x10000L) != 0L)
            return jjStartNfaWithStates_0(4, 16, 17);
         return jjMoveStringLiteralDfa5_0(active0, 0x4020000L);
      case 84:
         if ((active0 & 0x10000000000L) != 0L)
            return jjStartNfaWithStates_0(4, 40, 17);
         return jjMoveStringLiteralDfa5_0(active0, 0x1000000000000L);
      case 85:
         return jjMoveStringLiteralDfa5_0(active0, 0x4000000200L);
      case 88:
         if ((active0 & 0x40000000L) != 0L)
            return jjStartNfaWithStates_0(4, 30, 17);
         break;
      default :
         break;
   }
   return jjStartNfa_0(3, active0, 0L);
}
static private final int jjMoveStringLiteralDfa5_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(3, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(4, active0, 0L);
      return 5;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa6_0(active0, 0xc000000000L);
      case 66:
         return jjMoveStringLiteralDfa6_0(active0, 0x80000000000L);
      case 67:
         return jjMoveStringLiteralDfa6_0(active0, 0x20c0000L);
      case 69:
         if ((active0 & 0x100000000L) != 0L)
         {
            jjmatchedKind = 32;
            jjmatchedPos = 5;
         }
         return jjMoveStringLiteralDfa6_0(active0, 0x80800800L);
      case 71:
         if ((active0 & 0x20000000000L) != 0L)
            return jjStartNfaWithStates_0(5, 41, 17);
         break;
      case 73:
         return jjMoveStringLiteralDfa6_0(active0, 0x1003005100400L);
      case 76:
         if ((active0 & 0x1000L) != 0L)
            return jjStartNfaWithStates_0(5, 12, 17);
         break;
      case 78:
         return jjMoveStringLiteralDfa6_0(active0, 0x10002000L);
      case 80:
         return jjMoveStringLiteralDfa6_0(active0, 0x40000000000L);
      case 83:
         if ((active0 & 0x200L) != 0L)
            return jjStartNfaWithStates_0(5, 9, 17);
         else if ((active0 & 0x20000L) != 0L)
            return jjStartNfaWithStates_0(5, 17, 17);
         break;
      case 84:
         if ((active0 & 0x400000000000L) != 0L)
         {
            jjmatchedKind = 46;
            jjmatchedPos = 5;
         }
         return jjMoveStringLiteralDfa6_0(active0, 0xb00a00200040L);
      case 85:
         return jjMoveStringLiteralDfa6_0(active0, 0x400000L);
      case 88:
         if ((active0 & 0x8000L) != 0L)
            return jjStartNfaWithStates_0(5, 15, 17);
         break;
      default :
         break;
   }
   return jjStartNfa_0(4, active0, 0L);
}
static private final int jjMoveStringLiteralDfa6_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(4, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(5, active0, 0L);
      return 6;
   }
   switch(curChar)
   {
      case 45:
         return jjMoveStringLiteralDfa7_0(active0, 0x300880800000L);
      case 67:
         return jjMoveStringLiteralDfa7_0(active0, 0x30101c0000L);
      case 70:
         return jjMoveStringLiteralDfa7_0(active0, 0x1000000000000L);
      case 76:
         return jjMoveStringLiteralDfa7_0(active0, 0x84000000000L);
      case 78:
         return jjMoveStringLiteralDfa7_0(active0, 0x800L);
      case 79:
         return jjMoveStringLiteralDfa7_0(active0, 0x204000000L);
      case 80:
         return jjMoveStringLiteralDfa7_0(active0, 0x400400L);
      case 82:
         return jjMoveStringLiteralDfa7_0(active0, 0x40000000000L);
      case 83:
         if ((active0 & 0x40L) != 0L)
            return jjStartNfaWithStates_0(6, 6, 17);
         else if ((active0 & 0x800000000000L) != 0L)
            return jjStartNfaWithStates_0(6, 47, 17);
         break;
      case 84:
         return jjMoveStringLiteralDfa7_0(active0, 0x2002000L);
      case 89:
         return jjMoveStringLiteralDfa7_0(active0, 0x8000200000L);
      case 90:
         return jjMoveStringLiteralDfa7_0(active0, 0x1000000L);
      default :
         break;
   }
   return jjStartNfa_0(5, active0, 0L);
}
static private final int jjMoveStringLiteralDfa7_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(5, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(6, active0, 0L);
      return 7;
   }
   switch(curChar)
   {
      case 45:
         return jjMoveStringLiteralDfa8_0(active0, 0xc002000000L);
      case 65:
         return jjMoveStringLiteralDfa8_0(active0, 0x3001100000L);
      case 67:
         return jjMoveStringLiteralDfa8_0(active0, 0x80000800L);
      case 68:
         return jjMoveStringLiteralDfa8_0(active0, 0x400000L);
      case 69:
         if ((active0 & 0x10000000L) != 0L)
            return jjStartNfaWithStates_0(7, 28, 17);
         return jjMoveStringLiteralDfa8_0(active0, 0x800000c0000L);
      case 71:
         return jjMoveStringLiteralDfa8_0(active0, 0x800000000L);
      case 73:
         return jjMoveStringLiteralDfa8_0(active0, 0x1240000800000L);
      case 78:
         if ((active0 & 0x4000000L) != 0L)
            return jjStartNfaWithStates_0(7, 26, 17);
         break;
      case 80:
         return jjMoveStringLiteralDfa8_0(active0, 0x200000L);
      case 82:
         return jjMoveStringLiteralDfa8_0(active0, 0x200000000L);
      case 83:
         if ((active0 & 0x2000L) != 0L)
            return jjStartNfaWithStates_0(7, 13, 17);
         break;
      case 84:
         return jjMoveStringLiteralDfa8_0(active0, 0x100000000400L);
      default :
         break;
   }
   return jjStartNfa_0(6, active0, 0L);
}
static private final int jjMoveStringLiteralDfa8_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(6, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(7, active0, 0L);
      return 8;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa9_0(active0, 0x400000L);
      case 67:
         return jjMoveStringLiteralDfa9_0(active0, 0x4000000000L);
      case 68:
         return jjMoveStringLiteralDfa9_0(active0, 0x200000800000L);
      case 69:
         if ((active0 & 0x800L) != 0L)
            return jjStartNfaWithStates_0(8, 11, 17);
         else if ((active0 & 0x200000L) != 0L)
            return jjStartNfaWithStates_0(8, 21, 17);
         return jjMoveStringLiteralDfa9_0(active0, 0x1000000000000L);
      case 72:
         return jjMoveStringLiteralDfa9_0(active0, 0x8000000000L);
      case 73:
         return jjMoveStringLiteralDfa9_0(active0, 0x2000400L);
      case 79:
         return jjMoveStringLiteralDfa9_0(active0, 0x80000000L);
      case 82:
         return jjMoveStringLiteralDfa9_0(active0, 0x800000000L);
      case 83:
         if ((active0 & 0x80000000000L) != 0L)
            return jjStartNfaWithStates_0(8, 43, 17);
         return jjMoveStringLiteralDfa9_0(active0, 0x400000c0000L);
      case 84:
         return jjMoveStringLiteralDfa9_0(active0, 0x3001100000L);
      case 89:
         return jjMoveStringLiteralDfa9_0(active0, 0x100200000000L);
      default :
         break;
   }
   return jjStartNfa_0(7, active0, 0L);
}
static private final int jjMoveStringLiteralDfa9_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(7, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(8, active0, 0L);
      return 9;
   }
   switch(curChar)
   {
      case 45:
         return jjMoveStringLiteralDfa10_0(active0, 0x200000000L);
      case 69:
         if ((active0 & 0x40000000000L) != 0L)
            return jjStartNfaWithStates_0(9, 42, 17);
         return jjMoveStringLiteralDfa10_0(active0, 0x200000800000L);
      case 73:
         return jjMoveStringLiteralDfa10_0(active0, 0xb001100000L);
      case 77:
         return jjMoveStringLiteralDfa10_0(active0, 0x80000000L);
      case 78:
         return jjMoveStringLiteralDfa10_0(active0, 0x2000000L);
      case 79:
         return jjMoveStringLiteralDfa10_0(active0, 0x4800000400L);
      case 80:
         return jjMoveStringLiteralDfa10_0(active0, 0x100000000000L);
      case 82:
         if ((active0 & 0x1000000000000L) != 0L)
            return jjStartNfaWithStates_0(9, 48, 17);
         break;
      case 83:
         if ((active0 & 0x40000L) != 0L)
            return jjStartNfaWithStates_0(9, 18, 17);
         else if ((active0 & 0x80000L) != 0L)
            return jjStartNfaWithStates_0(9, 19, 17);
         break;
      case 84:
         return jjMoveStringLiteralDfa10_0(active0, 0x400000L);
      default :
         break;
   }
   return jjStartNfa_0(8, active0, 0L);
}
static private final int jjMoveStringLiteralDfa10_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(8, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(9, active0, 0L);
      return 10;
   }
   switch(curChar)
   {
      case 69:
         if ((active0 & 0x100000000000L) != 0L)
            return jjStartNfaWithStates_0(10, 44, 17);
         return jjMoveStringLiteralDfa11_0(active0, 0x400000L);
      case 70:
         return jjMoveStringLiteralDfa11_0(active0, 0x2000000L);
      case 71:
         return jjMoveStringLiteralDfa11_0(active0, 0x200000000L);
      case 78:
         if ((active0 & 0x400L) != 0L)
            return jjStartNfaWithStates_0(10, 10, 17);
         return jjMoveStringLiteralDfa11_0(active0, 0x20c000800000L);
      case 79:
         return jjMoveStringLiteralDfa11_0(active0, 0x3001100000L);
      case 80:
         return jjMoveStringLiteralDfa11_0(active0, 0x80000000L);
      case 85:
         return jjMoveStringLiteralDfa11_0(active0, 0x800000000L);
      default :
         break;
   }
   return jjStartNfa_0(9, active0, 0L);
}
static private final int jjMoveStringLiteralDfa11_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(9, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(10, active0, 0L);
      return 11;
   }
   switch(curChar)
   {
      case 68:
         if ((active0 & 0x400000L) != 0L)
            return jjStartNfaWithStates_0(11, 22, 17);
         break;
      case 76:
         return jjMoveStringLiteralDfa12_0(active0, 0x80000000L);
      case 78:
         if ((active0 & 0x1000000L) != 0L)
            return jjStartNfaWithStates_0(11, 24, 17);
         return jjMoveStringLiteralDfa12_0(active0, 0x3000100000L);
      case 79:
         if ((active0 & 0x2000000L) != 0L)
            return jjStartNfaWithStates_0(11, 25, 17);
         break;
      case 80:
         if ((active0 & 0x800000000L) != 0L)
            return jjStartNfaWithStates_0(11, 35, 17);
         break;
      case 82:
         return jjMoveStringLiteralDfa12_0(active0, 0x200000000L);
      case 84:
         if ((active0 & 0x8000000000L) != 0L)
            return jjStartNfaWithStates_0(11, 39, 17);
         return jjMoveStringLiteralDfa12_0(active0, 0x200000800000L);
      case 86:
         return jjMoveStringLiteralDfa12_0(active0, 0x4000000000L);
      default :
         break;
   }
   return jjStartNfa_0(10, active0, 0L);
}
static private final int jjMoveStringLiteralDfa12_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(10, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(11, active0, 0L);
      return 12;
   }
   switch(curChar)
   {
      case 45:
         return jjMoveStringLiteralDfa13_0(active0, 0x1000100000L);
      case 69:
         return jjMoveStringLiteralDfa13_0(active0, 0x4000000000L);
      case 73:
         return jjMoveStringLiteralDfa13_0(active0, 0x200080800000L);
      case 79:
         return jjMoveStringLiteralDfa13_0(active0, 0x200000000L);
      case 83:
         if ((active0 & 0x2000000000L) != 0L)
            return jjStartNfaWithStates_0(12, 37, 17);
         break;
      default :
         break;
   }
   return jjStartNfa_0(11, active0, 0L);
}
static private final int jjMoveStringLiteralDfa13_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(11, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(12, active0, 0L);
      return 13;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa14_0(active0, 0x80000000L);
      case 71:
         return jjMoveStringLiteralDfa14_0(active0, 0x1000000000L);
      case 78:
         return jjMoveStringLiteralDfa14_0(active0, 0x4000000000L);
      case 84:
         return jjMoveStringLiteralDfa14_0(active0, 0x200000900000L);
      case 85:
         return jjMoveStringLiteralDfa14_0(active0, 0x200000000L);
      default :
         break;
   }
   return jjStartNfa_0(12, active0, 0L);
}
static private final int jjMoveStringLiteralDfa14_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(12, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(13, active0, 0L);
      return 14;
   }
   switch(curChar)
   {
      case 78:
         return jjMoveStringLiteralDfa15_0(active0, 0x80000000L);
      case 80:
         return jjMoveStringLiteralDfa15_0(active0, 0x200000000L);
      case 82:
         return jjMoveStringLiteralDfa15_0(active0, 0x1000000000L);
      case 84:
         return jjMoveStringLiteralDfa15_0(active0, 0x4000000000L);
      case 89:
         if ((active0 & 0x800000L) != 0L)
            return jjStartNfaWithStates_0(14, 23, 17);
         else if ((active0 & 0x200000000000L) != 0L)
            return jjStartNfaWithStates_0(14, 45, 17);
         return jjMoveStringLiteralDfa15_0(active0, 0x100000L);
      default :
         break;
   }
   return jjStartNfa_0(13, active0, 0L);
}
static private final int jjMoveStringLiteralDfa15_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(13, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(14, active0, 0L);
      return 15;
   }
   switch(curChar)
   {
      case 67:
         return jjMoveStringLiteralDfa16_0(active0, 0x80000000L);
      case 73:
         return jjMoveStringLiteralDfa16_0(active0, 0x4000000000L);
      case 79:
         return jjMoveStringLiteralDfa16_0(active0, 0x1000000000L);
      case 80:
         return jjMoveStringLiteralDfa16_0(active0, 0x100000L);
      case 83:
         if ((active0 & 0x200000000L) != 0L)
            return jjStartNfaWithStates_0(15, 33, 17);
         break;
      default :
         break;
   }
   return jjStartNfa_0(14, active0, 0L);
}
static private final int jjMoveStringLiteralDfa16_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(14, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(15, active0, 0L);
      return 16;
   }
   switch(curChar)
   {
      case 69:
         if ((active0 & 0x100000L) != 0L)
            return jjStartNfaWithStates_0(16, 20, 17);
         else if ((active0 & 0x80000000L) != 0L)
            return jjStartNfaWithStates_0(16, 31, 17);
         break;
      case 79:
         return jjMoveStringLiteralDfa17_0(active0, 0x4000000000L);
      case 85:
         return jjMoveStringLiteralDfa17_0(active0, 0x1000000000L);
      default :
         break;
   }
   return jjStartNfa_0(15, active0, 0L);
}
static private final int jjMoveStringLiteralDfa17_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(15, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(16, active0, 0L);
      return 17;
   }
   switch(curChar)
   {
      case 78:
         if ((active0 & 0x4000000000L) != 0L)
            return jjStartNfaWithStates_0(17, 38, 17);
         break;
      case 80:
         if ((active0 & 0x1000000000L) != 0L)
            return jjStartNfaWithStates_0(17, 36, 17);
         break;
      default :
         break;
   }
   return jjStartNfa_0(16, active0, 0L);
}
static private final void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
static private final void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
static private final void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}
static private final void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}
static private final void jjCheckNAddStates(int start)
{
   jjCheckNAdd(jjnextStates[start]);
   jjCheckNAdd(jjnextStates[start + 1]);
}
static final long[] jjbitVec0 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static private final int jjMoveNfa_0(int startState, int curPos)
{
   int[] nextStates;
   int startsAt = 0;
   jjnewStateCnt = 24;
   int i = 1;
   jjstateSet[0] = startState;
   int j, kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               case 24:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddTwoStates(19, 20);
                  else if (curChar == 34)
                  {
                     if (kind > 62)
                        kind = 62;
                  }
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(21, 22);
                  break;
               case 5:
                  if ((0x3fe000000000000L & l) != 0L)
                  {
                     if (kind > 58)
                        kind = 58;
                     jjCheckNAddTwoStates(8, 9);
                  }
                  else if (curChar == 34)
                     jjCheckNAddStates(0, 2);
                  else if (curChar == 45)
                  {
                     if (kind > 64)
                        kind = 64;
                     jjCheckNAdd(17);
                  }
                  else if (curChar == 48)
                  {
                     if (kind > 58)
                        kind = 58;
                     jjCheckNAddTwoStates(15, 9);
                  }
                  else if (curChar == 39)
                     jjCheckNAddTwoStates(11, 13);
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 7;
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 0;
                  break;
               case 0:
                  if (curChar == 45)
                     jjCheckNAddStates(3, 5);
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) != 0L)
                     jjCheckNAddStates(3, 5);
                  break;
               case 2:
                  if ((0x2400L & l) != 0L && kind > 5)
                     kind = 5;
                  break;
               case 3:
                  if (curChar == 10 && kind > 5)
                     kind = 5;
                  break;
               case 4:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 6:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 7:
                  if ((0x3fe000000000000L & l) == 0L)
                     break;
                  if (kind > 58)
                     kind = 58;
                  jjCheckNAddTwoStates(8, 9);
                  break;
               case 8:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 58)
                     kind = 58;
                  jjCheckNAddTwoStates(8, 9);
                  break;
               case 10:
                  if (curChar == 39)
                     jjCheckNAddTwoStates(11, 13);
                  break;
               case 11:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(11, 13);
                  break;
               case 13:
                  if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 14:
                  if (curChar != 48)
                     break;
                  if (kind > 58)
                     kind = 58;
                  jjCheckNAddTwoStates(15, 9);
                  break;
               case 15:
                  if ((0xff000000000000L & l) == 0L)
                     break;
                  if (kind > 58)
                     kind = 58;
                  jjCheckNAddTwoStates(15, 9);
                  break;
               case 16:
                  if (curChar != 45)
                     break;
                  if (kind > 64)
                     kind = 64;
                  jjCheckNAdd(17);
                  break;
               case 17:
                  if ((0x3ff200000000000L & l) == 0L)
                     break;
                  if (kind > 64)
                     kind = 64;
                  jjCheckNAdd(17);
                  break;
               case 18:
                  if (curChar == 34)
                     jjCheckNAddStates(0, 2);
                  break;
               case 19:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddTwoStates(19, 20);
                  break;
               case 20:
                  if (curChar == 34 && kind > 62)
                     kind = 62;
                  break;
               case 21:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(21, 22);
                  break;
               case 23:
                  if (curChar == 34 && kind > 63)
                     kind = 63;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               case 24:
               case 19:
                  jjCheckNAddTwoStates(19, 20);
                  break;
               case 5:
               case 17:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 64)
                     kind = 64;
                  jjCheckNAdd(17);
                  break;
               case 1:
                  jjAddStates(3, 5);
                  break;
               case 9:
                  if ((0x100000001000L & l) != 0L && kind > 58)
                     kind = 58;
                  break;
               case 11:
                  if ((0x7e0000007eL & l) != 0L)
                     jjAddStates(6, 7);
                  break;
               case 12:
                  if (curChar != 104)
                     break;
                  if (kind > 58)
                     kind = 58;
                  jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 22:
                  if ((0x400000004000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 23;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               case 24:
               case 19:
                  if ((jjbitVec0[i2] & l2) != 0L)
                     jjCheckNAddTwoStates(19, 20);
                  break;
               case 1:
                  if ((jjbitVec0[i2] & l2) != 0L)
                     jjAddStates(3, 5);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 24 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
static final int[] jjnextStates = {
   19, 20, 21, 1, 2, 4, 11, 13, 
};
public static final String[] jjstrLiteralImages = {
"", null, null, null, null, null, "\111\115\120\117\122\124\123", 
"\102\105\107\111\116", "\106\122\117\115", "\123\124\101\124\125\123", 
"\104\105\123\103\122\111\120\124\111\117\116", "\122\105\106\105\122\105\116\103\105", "\104\105\106\126\101\114", 
"\101\125\107\115\105\116\124\123", "\105\116\104", "\123\131\116\124\101\130", "\125\116\111\124\123", 
"\101\103\103\105\123\123", "\115\101\130\55\101\103\103\105\123\123", 
"\115\111\116\55\101\103\103\105\123\123", "\116\117\124\111\106\111\103\101\124\111\117\116\55\124\131\120\105", 
"\124\122\101\120\55\124\131\120\105", "\114\101\123\124\55\125\120\104\101\124\105\104", 
"\115\117\104\125\114\105\55\111\104\105\116\124\111\124\131", "\117\122\107\101\116\111\132\101\124\111\117\116", 
"\103\117\116\124\101\103\124\55\111\116\106\117", "\122\105\126\111\123\111\117\116", "\123\111\132\105", 
"\123\105\121\125\105\116\103\105", "\117\106", "\111\116\104\105\130", 
"\115\117\104\125\114\105\55\103\117\115\120\114\111\101\116\103\105", "\115\117\104\125\114\105", 
"\115\101\116\104\101\124\117\122\131\55\107\122\117\125\120\123", "\107\122\117\125\120", "\117\102\112\105\103\124\55\107\122\117\125\120", 
"\116\117\124\111\106\111\103\101\124\111\117\116\55\107\122\117\125\120", "\116\117\124\111\106\111\103\101\124\111\117\116\123", 
"\124\105\130\124\125\101\114\55\103\117\116\126\105\116\124\111\117\116", "\104\111\123\120\114\101\131\55\110\111\116\124", "\117\103\124\105\124", 
"\123\124\122\111\116\107", "\105\116\124\105\122\120\122\111\123\105", 
"\126\101\122\111\101\102\114\105\123", "\117\102\112\105\103\124\55\124\131\120\105", 
"\117\102\112\105\103\124\55\111\104\105\116\124\111\124\131", "\117\102\112\105\103\124", "\117\102\112\105\103\124\123", 
"\111\104\105\116\124\111\106\111\105\122", "\50", "\51", "\173", "\175", "\133", "\135", "\73", "\54", "\42", null, null, 
null, null, null, null, null, null, null, "\72\72\75", "\56", "\174", };
public static final String[] lexStateNames = {
   "DEFAULT", 
};
static final long[] jjtoToken = {
   0xc7ffffffffffffc1L, 0x39L, 
};
static final long[] jjtoSkip = {
   0x3eL, 0x0L, 
};
static protected SimpleCharStream input_stream;
static private final int[] jjrounds = new int[24];
static private final int[] jjstateSet = new int[48];
static protected char curChar;
public ParseMibTokenManager(SimpleCharStream stream)
{
   if (input_stream != null)
      throw new TokenMgrError("ERROR: Second call to constructor of static lexer. You must use ReInit() to initialize the static variables.", TokenMgrError.STATIC_LEXER_ERROR);
   input_stream = stream;
}
public ParseMibTokenManager(SimpleCharStream stream, int lexState)
{
   this(stream);
   SwitchTo(lexState);
}
static public void ReInit(SimpleCharStream stream)
{
   jjmatchedPos = jjnewStateCnt = 0;
   curLexState = defaultLexState;
   input_stream = stream;
   ReInitRounds();
}
static private final void ReInitRounds()
{
   int i;
   jjround = 0x80000001;
   for (i = 24; i-- > 0;)
      jjrounds[i] = 0x80000000;
}
static public void ReInit(SimpleCharStream stream, int lexState)
{
   ReInit(stream);
   SwitchTo(lexState);
}
static public void SwitchTo(int lexState)
{
   if (lexState >= 1 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
   else
      curLexState = lexState;
}

static protected Token jjFillToken()
{
   Token t = Token.newToken(jjmatchedKind);
   t.kind = jjmatchedKind;
   String im = jjstrLiteralImages[jjmatchedKind];
   t.image = (im == null) ? input_stream.GetImage() : im;
   t.beginLine = input_stream.getBeginLine();
   t.beginColumn = input_stream.getBeginColumn();
   t.endLine = input_stream.getEndLine();
   t.endColumn = input_stream.getEndColumn();
   return t;
}

static int curLexState = 0;
static int defaultLexState = 0;
static int jjnewStateCnt;
static int jjround;
static int jjmatchedPos;
static int jjmatchedKind;

public static Token getNextToken() 
{
  int kind;
  Token specialToken = null;
  Token matchedToken;
  int curPos = 0;

  EOFLoop :
  for (;;)
  {   
   try   
   {     
      curChar = input_stream.BeginToken();
   }     
   catch(java.io.IOException e)
   {        
      jjmatchedKind = 0;
      matchedToken = jjFillToken();
      return matchedToken;
   }

   try { input_stream.backup(0);
      while (curChar <= 32 && (0x100002600L & (1L << curChar)) != 0L)
         curChar = input_stream.BeginToken();
   }
   catch (java.io.IOException e1) { continue EOFLoop; }
   jjmatchedKind = 0x7fffffff;
   jjmatchedPos = 0;
   curPos = jjMoveStringLiteralDfa0_0();
   if (jjmatchedKind != 0x7fffffff)
   {
      if (jjmatchedPos + 1 < curPos)
         input_stream.backup(curPos - jjmatchedPos - 1);
      if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
      {
         matchedToken = jjFillToken();
         return matchedToken;
      }
      else
      {
         continue EOFLoop;
      }
   }
   int error_line = input_stream.getEndLine();
   int error_column = input_stream.getEndColumn();
   String error_after = null;
   boolean EOFSeen = false;
   try { input_stream.readChar(); input_stream.backup(1); }
   catch (java.io.IOException e1) {
      EOFSeen = true;
      error_after = curPos <= 1 ? "" : input_stream.GetImage();
      if (curChar == '\n' || curChar == '\r') {
         error_line++;
         error_column = 0;
      }
      else
         error_column++;
   }
   if (!EOFSeen) {
      input_stream.backup(1);
      error_after = curPos <= 1 ? "" : input_stream.GetImage();
   }
   throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
  }
}

}
