/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.filter.Table;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.netmgt.filter.analysis.DepthFirstAdapter;
import org.opennms.netmgt.filter.node.AAndRule;
import org.opennms.netmgt.filter.node.ACompareExprPart;
import org.opennms.netmgt.filter.node.AExprParensExpr;
import org.opennms.netmgt.filter.node.AGtrThanEqualExprPart;
import org.opennms.netmgt.filter.node.AGtrThanExprPart;
import org.opennms.netmgt.filter.node.AIdentExprPart;
import org.opennms.netmgt.filter.node.AIntegerCompareRight;
import org.opennms.netmgt.filter.node.AIntegerOctet;
import org.opennms.netmgt.filter.node.AIpaddrIpIdent;
import org.opennms.netmgt.filter.node.AIplikeExprPart;
import org.opennms.netmgt.filter.node.ALessThanEqualExprPart;
import org.opennms.netmgt.filter.node.ALessThanExprPart;
import org.opennms.netmgt.filter.node.ALikeExprPart;
import org.opennms.netmgt.filter.node.ANotEqualExprPart;
import org.opennms.netmgt.filter.node.ANotExprPart;
import org.opennms.netmgt.filter.node.AOctetListOctet;
import org.opennms.netmgt.filter.node.AOctetRangeListOctet;
import org.opennms.netmgt.filter.node.AOctetRangeOctet;
import org.opennms.netmgt.filter.node.AOrRule;
import org.opennms.netmgt.filter.node.AStarOctet;
import org.opennms.netmgt.filter.node.AStringCompareRight;
import org.opennms.netmgt.filter.node.ATildelikeExprPart;
import org.opennms.netmgt.filter.node.Start;

public class SQLTranslation
extends DepthFirstAdapter {
    private DatabaseSchemaConfigFactory m_schemaFactory;
    public static final String VIRTUAL_COLUMN_PREFIX = "is";
    public static final String VIRTUAL_NOT_COLUMN_PREFIX = "notis";
    public static final String VIRTUAL_CATINC_PREFIX = "catinc";
    private List<Table> m_tables;
    private List<String> m_selectList;
    private String m_selectModifier;
    private StringBuffer m_from;
    private StringBuffer m_where;
    private StringBuffer m_ipaddr;
    private Start m_node;

    private String constructJoin() {
        StringBuffer joinBuf = new StringBuffer();
        for (Table t : this.m_tables) {
            String expr = this.m_schemaFactory.constructJoinExprForTable(t);
            if (expr == null || "".equals(expr)) continue;
            joinBuf.append(" AND ");
            joinBuf.append(expr);
        }
        return joinBuf.toString();
    }

    private String validateIdent(String ident) {
        String serviceName;
        String expr = null;
        Table tableForIdent = this.m_schemaFactory.findTableByVisableColumn(ident);
        if (tableForIdent != null) {
            expr = this.addColumnToStatement(tableForIdent, ident);
        }
        if (expr == null && ident.startsWith(VIRTUAL_COLUMN_PREFIX)) {
            serviceName = ident.substring(VIRTUAL_COLUMN_PREFIX.length());
            tableForIdent = this.m_schemaFactory.findTableByVisableColumn("serviceName");
            if (tableForIdent != null) {
                expr = this.addColumnToStatement(tableForIdent, "serviceName");
            }
            if (expr != null) {
                expr = expr + " = '" + serviceName + '\'';
            }
        }
        if (expr == null && ident.startsWith(VIRTUAL_NOT_COLUMN_PREFIX)) {
            serviceName = ident.substring(VIRTUAL_NOT_COLUMN_PREFIX.length());
            tableForIdent = this.m_schemaFactory.findTableByVisableColumn("ipAddr");
            if (tableForIdent != null) {
                expr = this.addColumnToStatement(tableForIdent, "ipAddr");
            }
            if (expr != null) {
                expr = expr + " not in (select ipaddr from ifservices,service where service.serviceName ='" + serviceName + "' and service.serviceID = ifServices.serviceid)";
            }
        }
        if (expr == null && ident.startsWith(VIRTUAL_CATINC_PREFIX)) {
            String categoryName = ident.substring(VIRTUAL_CATINC_PREFIX.length());
            tableForIdent = this.m_schemaFactory.findTableByVisableColumn("nodeID");
            if (tableForIdent != null) {
                expr = this.addColumnToStatement(tableForIdent, "nodeID");
            }
            if (expr != null) {
                expr = expr + " in (select nodeid from category_node, categories where categories.categoryID = category_node.categoryID AND categories.categoryName = '" + categoryName + "')";
            }
        }
        if (expr == null) {
            throw new FilterParseException("The token " + ident + " is an illegal column value.");
        }
        return expr;
    }

    private String addColumnToStatement(String colName) {
        Table t = this.m_schemaFactory.findTableByVisableColumn(colName);
        if (t == null) {
            throw new FilterParseException("Could not find the column '" + colName + "' in the database schema");
        }
        return this.addColumnToStatement(t, colName).toString();
    }

    private String addColumnToStatement(Table t, String colName) {
        String[] joinTableNames = this.m_schemaFactory.getJoinTablesForTable(t);
        for (int i = 0; i < joinTableNames.length; ++i) {
            Table joinTable = this.m_schemaFactory.getTableByName(joinTableNames[i]);
            if (joinTable == null) {
                throw new FilterParseException("Unable to locate visable table for " + joinTableNames[i] + " referrenced in join for table " + t.getName());
            }
            if (this.m_tables.contains(joinTable)) continue;
            if (this.m_tables.size() == 0) {
                this.m_from.append(joinTable.getName());
            } else {
                this.m_from.append(", ").append(joinTable.getName());
            }
            this.m_tables.add(joinTable);
        }
        return t.getName() + "." + colName;
    }

    private String convertString(String string) {
        StringBuffer buffer = new StringBuffer(string);
        buffer.setCharAt(0, '\'');
        buffer.setCharAt(buffer.length() - 1, '\'');
        return buffer.toString();
    }

    public void checkIPNum(String octet) {
        try {
            int ipnum = Integer.parseInt(octet);
            if (ipnum < 0 || ipnum > 255) {
                throw new IndexOutOfBoundsException("The specified IP octet is not valid, value = " + octet);
            }
        }
        catch (NumberFormatException e) {
            throw new IndexOutOfBoundsException("The specified IP octet is not valid, value = " + octet);
        }
    }

    public SQLTranslation(Start node, DatabaseSchemaConfigFactory databaseSchemaConfigFactory) {
        this.m_schemaFactory = databaseSchemaConfigFactory;
        this.m_node = node;
        this.m_selectList = new ArrayList<String>();
        this.m_from = new StringBuffer(" FROM ");
        this.m_where = new StringBuffer(" WHERE (");
        this.m_tables = new ArrayList<Table>(this.m_schemaFactory.getTableCount());
        this.setDefaultTranslation();
    }

    private String buildSelectClause() {
        StringBuffer clause = new StringBuffer("SELECT ");
        clause.append(this.m_selectModifier).append(" ");
        for (int i = 0; i < this.m_selectList.size(); ++i) {
            clause.append(this.m_selectList.get(i)).append(i < this.m_selectList.size() - 1 ? ", " : "");
        }
        return clause.toString();
    }

    public void setDefaultTranslation() {
        this.m_selectModifier = "DISTINCT";
        this.m_selectList.clear();
        this.m_selectList.add(this.addColumnToStatement("ipAddr"));
    }

    public void setIPServiceMappingTranslation() {
        this.m_selectModifier = "";
        this.m_selectList.clear();
        this.m_selectList.add(this.addColumnToStatement("ipAddr"));
        this.m_selectList.add(this.addColumnToStatement("serviceName"));
    }

    public void setNodeMappingTranslation() {
        this.m_selectModifier = "DISTINCT";
        this.m_selectList.clear();
        this.m_selectList.add(this.addColumnToStatement("nodeid"));
        this.m_selectList.add(this.addColumnToStatement("nodelabel"));
    }

    public void setConstraintTranslation(long nodeId, String ipaddr, String service) {
        this.m_selectModifier = "DISTINCT";
        this.m_selectList.clear();
        String ipAddrColumn = this.addColumnToStatement("ipAddr");
        this.m_selectList.add(ipAddrColumn);
        StringBuffer constraint = new StringBuffer();
        boolean needAnd = false;
        if (nodeId != 0L) {
            if (needAnd) {
                constraint.append(" AND ");
            }
            String nodeIDColumn = this.addColumnToStatement("nodeID");
            constraint.append(nodeIDColumn).append(" = ").append(nodeId);
            needAnd = true;
        }
        if (ipaddr != null && !ipaddr.equals("")) {
            if (needAnd) {
                constraint.append(" AND ");
            }
            constraint.append(ipAddrColumn).append(" = '").append(ipaddr).append('\'');
            needAnd = true;
        }
        if (service != null && !service.equals("")) {
            String serviceColumn = this.addColumnToStatement("serviceName");
            if (needAnd) {
                constraint.append(" AND ");
            }
            constraint.append(serviceColumn).append(" = '").append(service).append('\'');
            needAnd = true;
        }
        this.m_where.append(constraint).append(") AND (");
    }

    public void setInterfaceWithServiceTranslation() {
        this.m_selectModifier = "DISTINCT";
        this.m_selectList.clear();
        this.m_selectList.add(this.addColumnToStatement("ipAddr"));
        this.m_selectList.add(this.addColumnToStatement("serviceName"));
        this.m_selectList.add(this.addColumnToStatement("nodeID"));
    }

    public void outStart(Start node) {
        this.m_where.append(")" + this.constructJoin());
    }

    public void caseAAndRule(AAndRule node) {
        node.getRule().apply(this);
        this.m_where.append(" AND ");
        node.getExpr().apply(this);
    }

    public void caseAOrRule(AOrRule node) {
        node.getRule().apply(this);
        this.m_where.append(" OR ");
        node.getExpr().apply(this);
    }

    public void inAExprParensExpr(AExprParensExpr node) {
        this.m_where.append("( ");
    }

    public void outAExprParensExpr(AExprParensExpr node) {
        this.m_where.append(" )");
    }

    public void inAIdentExprPart(AIdentExprPart node) {
        this.m_where.append(this.validateIdent(node.getIdent().getText()));
    }

    public void caseAGtrThanExprPart(AGtrThanExprPart node) {
        this.m_where.append(this.validateIdent(node.getIdent().getText()));
        this.m_where.append(" > ");
        node.getCompareRight().apply(this);
    }

    public void caseALessThanExprPart(ALessThanExprPart node) {
        this.m_where.append(this.validateIdent(node.getIdent().getText()));
        this.m_where.append(" < ");
        node.getCompareRight().apply(this);
    }

    public void caseAGtrThanEqualExprPart(AGtrThanEqualExprPart node) {
        this.m_where.append(this.validateIdent(node.getIdent().getText()));
        this.m_where.append(" >= ");
        node.getCompareRight().apply(this);
    }

    public void caseALessThanEqualExprPart(ALessThanEqualExprPart node) {
        this.m_where.append(this.validateIdent(node.getIdent().getText()));
        this.m_where.append(" <= ");
        node.getCompareRight().apply(this);
    }

    public void caseACompareExprPart(ACompareExprPart node) {
        this.m_where.append(this.validateIdent(node.getIdent().getText()));
        this.m_where.append(" = ");
        node.getCompareRight().apply(this);
    }

    public void caseANotEqualExprPart(ANotEqualExprPart node) {
        this.m_where.append(this.validateIdent(node.getIdent().getText()));
        this.m_where.append(" <> ");
        node.getCompareRight().apply(this);
    }

    public void inANotExprPart(ANotExprPart node) {
        this.m_where.append("NOT ");
    }

    public void caseAIntegerCompareRight(AIntegerCompareRight node) {
        this.inAIntegerCompareRight(node);
        this.m_where.append(node.getInteger().getText());
        this.outAIntegerCompareRight(node);
    }

    public void caseAStringCompareRight(AStringCompareRight node) {
        this.inAStringCompareRight(node);
        if (node.getQuotedString() != null) {
            node.getQuotedString().apply(this);
            this.m_where.append(this.convertString(node.getQuotedString().getText()));
        }
        this.outAStringCompareRight(node);
    }

    public void caseALikeExprPart(ALikeExprPart node) {
        this.inALikeExprPart(node);
        if (node.getIdent() != null) {
            node.getIdent().apply(this);
            this.m_where.append(this.validateIdent(node.getIdent().getText()));
        }
        if (node.getLike() != null) {
            node.getLike().apply(this);
            this.m_where.append(" LIKE ");
        }
        if (node.getQuotedString() != null) {
            node.getQuotedString().apply(this);
            this.m_where.append(this.convertString(node.getQuotedString().getText()));
        }
        this.outALikeExprPart(node);
    }

    public void caseATildelikeExprPart(ATildelikeExprPart node) {
        this.inATildelikeExprPart(node);
        if (node.getIdent() != null) {
            node.getIdent().apply(this);
            this.m_where.append(this.validateIdent(node.getIdent().getText()));
        }
        if (node.getTildelike() != null) {
            node.getTildelike().apply(this);
            this.m_where.append(" ~ ");
        }
        if (node.getQuotedString() != null) {
            node.getQuotedString().apply(this);
            this.m_where.append(this.convertString(node.getQuotedString().getText()));
        }
        this.outATildelikeExprPart(node);
    }

    public void caseAIplikeExprPart(AIplikeExprPart node) {
        StringBuffer iplikeMethodCall = new StringBuffer("iplike(");
        this.inAIplikeExprPart(node);
        if (node.getIdent() != null) {
            node.getIdent().apply(this);
            iplikeMethodCall.append(this.validateIdent(node.getIdent().getText()));
        }
        if (node.getIplike() != null) {
            node.getIplike().apply(this);
        }
        if (node.getIpIdent() != null) {
            node.getIpIdent().apply(this);
            iplikeMethodCall.append(", '" + this.m_ipaddr + "')");
        }
        this.m_where.append(iplikeMethodCall.toString());
        this.outAIplikeExprPart(node);
    }

    public void caseAIpaddrIpIdent(AIpaddrIpIdent node) {
        this.m_ipaddr = new StringBuffer();
        this.inAIpaddrIpIdent(node);
        if (node.getOct1() != null) {
            node.getOct1().apply(this);
        }
        if (node.getDot1() != null) {
            node.getDot1().apply(this);
            this.m_ipaddr.append(node.getDot1().getText());
        }
        if (node.getOct2() != null) {
            node.getOct2().apply(this);
        }
        if (node.getDot2() != null) {
            node.getDot2().apply(this);
            this.m_ipaddr.append(node.getDot2().getText());
        }
        if (node.getOct3() != null) {
            node.getOct3().apply(this);
        }
        if (node.getDot3() != null) {
            node.getDot3().apply(this);
            this.m_ipaddr.append(node.getDot3().getText());
        }
        if (node.getOct4() != null) {
            node.getOct4().apply(this);
        }
        this.outAIpaddrIpIdent(node);
    }

    public void caseAStarOctet(AStarOctet node) {
        this.inAStarOctet(node);
        if (node.getStar() != null) {
            node.getStar().apply(this);
            this.m_ipaddr.append(node.getStar().getText());
        }
        this.outAStarOctet(node);
    }

    public void caseAOctetListOctet(AOctetListOctet node) {
        this.inAOctetListOctet(node);
        if (node.getOctetList() != null) {
            node.getOctetList().apply(this);
            StringTokenizer tokens = new StringTokenizer(node.getOctetList().getText(), ",");
            while (tokens.hasMoreTokens()) {
                this.checkIPNum(tokens.nextToken());
            }
            this.m_ipaddr.append(node.getOctetList().getText());
        }
        this.outAOctetListOctet(node);
    }

    public void caseAOctetRangeOctet(AOctetRangeOctet node) {
        this.inAOctetRangeOctet(node);
        if (node.getOctetRange() != null) {
            node.getOctetRange().apply(this);
            StringTokenizer tokens = new StringTokenizer(node.getOctetRange().getText(), "-");
            while (tokens.hasMoreTokens()) {
                this.checkIPNum(tokens.nextToken());
            }
            this.m_ipaddr.append(node.getOctetRange().getText());
        }
        this.outAOctetRangeOctet(node);
    }

    public void caseAOctetRangeListOctet(AOctetRangeListOctet node) {
        this.inAOctetRangeListOctet(node);
        if (node.getOctetRangeList() != null) {
            node.getOctetRangeList().apply(this);
            StringTokenizer listTokens = new StringTokenizer(node.getOctetRangeList().getText(), ",");
            StringTokenizer rangeTokens = new StringTokenizer(listTokens.nextToken());
            while (rangeTokens.hasMoreTokens()) {
                this.checkIPNum(rangeTokens.nextToken());
            }
            while (listTokens.hasMoreTokens()) {
                this.checkIPNum(listTokens.nextToken());
            }
            this.m_ipaddr.append(node.getOctetRangeList().getText());
        }
        this.outAOctetRangeListOctet(node);
    }

    public void caseAIntegerOctet(AIntegerOctet node) {
        this.inAIntegerOctet(node);
        if (node.getInteger() != null) {
            node.getInteger().apply(this);
            this.checkIPNum(node.getInteger().toString().trim());
            this.m_ipaddr.append(node.getInteger().getText());
        }
        this.outAIntegerOctet(node);
    }

    public String getStatement() {
        if (this.m_node == null) {
            return null;
        }
        this.m_node.apply(this);
        return this.buildSelectClause() + this.m_from.toString() + this.m_where.toString();
    }
}

