/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.opennms.netmgt.rrd.RrdUtils;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeUtils {
    public static String DS_PROPERTIES_FILE = "ds.properties";

    private ResourceTypeUtils() {
    }

    public static Set<OnmsAttribute> getAttributesAtRelativePath(File rrdDirectory, String relativePath) {
        int suffixLength = RrdFileConstants.getRrdSuffix().length();
        File directory = new File(rrdDirectory, relativePath);
        File[] files = directory.listFiles(RrdFileConstants.RRD_FILENAME_FILTER);
        HashSet<OnmsAttribute> attributes = new HashSet<OnmsAttribute>(files.length);
        for (File file : files) {
            String fileName = file.getName();
            if (ResourceTypeUtils.isStoreByGroup()) {
                String groupName = fileName.substring(0, fileName.length() - suffixLength);
                Properties props = ResourceTypeUtils.getDsProperties(directory);
                for (Object o : props.keySet()) {
                    String dsName = (String)o;
                    if (!props.getProperty(dsName).equals(groupName)) continue;
                    attributes.add((OnmsAttribute)new RrdGraphAttribute(dsName, relativePath, file.getName()));
                }
                continue;
            }
            String dsName = fileName.substring(0, fileName.length() - suffixLength);
            attributes.add((OnmsAttribute)new RrdGraphAttribute(dsName, relativePath, file.getName()));
        }
        Properties properties = ResourceTypeUtils.getProperties(rrdDirectory, relativePath);
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                attributes.add((OnmsAttribute)new StringPropertyAttribute(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
        return attributes;
    }

    public static Properties getDsProperties(File directory) {
        Properties props = new Properties();
        File propertiesFile = new File(directory, DS_PROPERTIES_FILE);
        if (propertiesFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(propertiesFile);
                props.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception e) {
                ResourceTypeUtils.log().error((Object)("ds.properties error: " + e), (Throwable)e);
            }
        } else {
            ResourceTypeUtils.log().error((Object)"ds.properties does not exist");
        }
        return props;
    }

    public static File getRrdFileForDs(File directory, String ds) {
        if (ResourceTypeUtils.isStoreByGroup()) {
            Properties props = ResourceTypeUtils.getDsProperties(directory);
            ds = props.getProperty(ds);
        }
        return new File(directory, ds + RrdUtils.getExtension());
    }

    public static boolean isStoreByGroup() {
        return Boolean.getBoolean("org.opennms.rrd.storeByGroup");
    }

    public static Properties getProperties(File rrdDirectory, String relativePath) {
        Assert.notNull((Object)rrdDirectory, (String)"rrdDirectory argument must not be null");
        Assert.notNull((Object)relativePath, (String)"relativePath argument must not be null");
        return ResourceTypeUtils.getProperties(new File(rrdDirectory, relativePath + File.separator + "strings.properties"));
    }

    public static Properties getProperties(File file) {
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException e) {
            String message = "loadProperties: Error opening properties file " + file.getAbsolutePath() + ": " + e;
            ResourceTypeUtils.log().warn((Object)message, (Throwable)e);
            throw new DataAccessResourceFailureException(message, (Throwable)e);
        }
        Properties properties = new Properties();
        try {
            properties.load(fileInputStream);
        }
        catch (IOException e) {
            String message = "loadProperties: Error loading properties file " + file.getAbsolutePath() + ": " + e;
            ResourceTypeUtils.log().warn((Object)message, (Throwable)e);
            throw new DataAccessResourceFailureException(message, (Throwable)e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                String message = "loadProperties: Error closing properties file " + file.getAbsolutePath() + ": " + e;
                ResourceTypeUtils.log().warn((Object)message, (Throwable)e);
                throw new DataAccessResourceFailureException(message, (Throwable)e);
            }
        }
        return properties;
    }

    private static Category log() {
        return ThreadCategory.getInstance();
    }
}

