/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.LazyList;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeResourceType
implements OnmsResourceType {
    private static final Set<OnmsAttribute> s_emptyAttributeSet = Collections.unmodifiableSet(new HashSet());
    private ResourceDao m_resourceDao;

    public NodeResourceType(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public String getLabel() {
        return "Node";
    }

    public String getName() {
        return "node";
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return false;
    }

    public String getLinkForResource(OnmsResource resource) {
        return "element/node.jsp?node=" + resource.getName();
    }

    public OnmsResource createChildResource(OnmsNode node) {
        NodeChildResourceLoader loader = new NodeChildResourceLoader(node.getId());
        OnmsResource r = new OnmsResource(node.getId().toString(), node.getLabel(), (OnmsResourceType)this, s_emptyAttributeSet, (List)new LazyList((LazyList.Loader)loader));
        r.setEntity((OnmsEntity)node);
        loader.setParent(r);
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeChildResourceLoader
    implements LazyList.Loader<OnmsResource> {
        private int m_nodeId;
        private OnmsResource m_parent;

        public NodeChildResourceLoader(int nodeId) {
            this.m_nodeId = nodeId;
        }

        public void setParent(OnmsResource parent) {
            this.m_parent = parent;
        }

        public List<OnmsResource> load() {
            LinkedList<OnmsResource> children = new LinkedList<OnmsResource>();
            for (OnmsResourceType resourceType : this.getResourceTypesForNode(this.m_nodeId)) {
                for (OnmsResource resource : resourceType.getResourcesForNode(this.m_nodeId)) {
                    resource.setParent(this.m_parent);
                    children.add(resource);
                }
            }
            return children;
        }

        private Collection<OnmsResourceType> getResourceTypesForNode(int nodeId) {
            LinkedList<OnmsResourceType> resourceTypes = new LinkedList<OnmsResourceType>();
            for (OnmsResourceType resourceType : NodeResourceType.this.m_resourceDao.getResourceTypes()) {
                if (!resourceType.isResourceTypeOnNode(nodeId)) continue;
                resourceTypes.add(resourceType);
            }
            return resourceTypes;
        }
    }
}

