/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.InputStream;
import org.opennms.netmgt.dao.RrdDao;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultRrdDao
implements RrdDao,
InitializingBean {
    private RrdStrategy m_rrdStrategy;
    private File m_rrdBaseDirectory;
    private String m_rrdBinaryPath;

    public double getPrintValue(OnmsAttribute attribute, String cf, long start, long end) {
        String[] printLines;
        RrdGraphDetails graphDetails;
        Assert.notNull((Object)attribute, (String)"attribute argument must not be null");
        Assert.notNull((Object)cf, (String)"cf argument must not be null");
        Assert.isTrue((end > start ? 1 : 0) != 0, (String)"end argument must be after start argument");
        Assert.isAssignable(attribute.getClass(), RrdGraphAttribute.class, (String)"attribute argument must be assignable to RrdGraphAttribute");
        RrdGraphAttribute rrdAttribute = (RrdGraphAttribute)attribute;
        Object[] command = new String[]{this.m_rrdBinaryPath, "graph", "-", "--start=" + start / 1000L, "--end=" + end / 1000L, "DEF:ds=" + rrdAttribute.getRrdRelativePath() + ":" + attribute.getName() + ":" + cf, "PRINT:ds:" + cf + ":\"%le\""};
        String commandString = StringUtils.arrayToDelimitedString((Object[])command, (String)" ");
        try {
            graphDetails = this.m_rrdStrategy.createGraphReturnDetails(commandString, this.m_rrdBaseDirectory);
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Failure when generating graph to get data with command '" + commandString + "'", (Throwable)e);
        }
        try {
            printLines = graphDetails.getPrintLines();
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Failure to get print lines from grpah after graphing with command '" + commandString + "'", (Throwable)e);
        }
        if (printLines.length != 1) {
            throw new ObjectRetrievalFailureException("Returned number of print lines should be 1, but was " + printLines.length, (Object)commandString);
        }
        return Double.parseDouble(printLines[0]);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_rrdStrategy != null ? 1 : 0) != 0, (String)"property rrdStrategy must be set and be non-null");
        Assert.state((this.m_rrdBaseDirectory != null ? 1 : 0) != 0, (String)"property rrdBaseDirectory must be set and be non-null");
        Assert.state((this.m_rrdBinaryPath != null ? 1 : 0) != 0, (String)"property rrdBinaryPath must be set and be non-null");
    }

    public RrdStrategy getRrdStrategy() {
        return this.m_rrdStrategy;
    }

    public void setRrdStrategy(RrdStrategy rrdStrategy) {
        this.m_rrdStrategy = rrdStrategy;
    }

    public File getRrdBaseDirectory() {
        return this.m_rrdBaseDirectory;
    }

    public void setRrdBaseDirectory(File rrdBaseDirectory) {
        this.m_rrdBaseDirectory = rrdBaseDirectory;
    }

    public String getRrdBinaryPath() {
        return this.m_rrdBinaryPath;
    }

    public void setRrdBinaryPath(String rrdBinaryPath) {
        this.m_rrdBinaryPath = rrdBinaryPath;
    }

    public InputStream createGraph(String command, File workDir) throws DataRetrievalFailureException {
        try {
            return this.m_rrdStrategy.createGraph(command, workDir);
        }
        catch (Exception e) {
            throw new DataRetrievalFailureException("Could not create graph: " + e, (Throwable)e);
        }
    }

    public int getGraphTopOffsetWithText() {
        return this.m_rrdStrategy.getGraphTopOffsetWithText();
    }

    public int setGraphRightOffset() {
        return this.m_rrdStrategy.getGraphRightOffset();
    }

    public Double getLastFetchValue(OnmsAttribute attribute, int interval) throws DataAccessResourceFailureException {
        Assert.notNull((Object)attribute, (String)"attribute argument must not be null");
        Assert.isTrue((interval > 0 ? 1 : 0) != 0, (String)"interval argument must be greater than zero");
        Assert.isAssignable(attribute.getClass(), RrdGraphAttribute.class, (String)"attribute argument must be assignable to RrdGraphAttribute");
        RrdGraphAttribute rrdAttribute = (RrdGraphAttribute)attribute;
        File rrdFile = new File(this.m_rrdBaseDirectory, rrdAttribute.getRrdRelativePath());
        try {
            return this.m_rrdStrategy.fetchLastValue(rrdFile.getAbsolutePath(), attribute.getName(), interval);
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Failure to fetch last value from file '" + rrdFile + "' with interval " + interval, (Throwable)e);
        }
    }

    public Double getLastFetchValue(OnmsAttribute attribute, int interval, int range) throws DataAccessResourceFailureException {
        Assert.notNull((Object)attribute, (String)"attribute argument must not be null");
        Assert.isTrue((interval > 0 ? 1 : 0) != 0, (String)"interval argument must be greater than zero");
        Assert.isTrue((range > 0 ? 1 : 0) != 0, (String)"range argument must be greater than zero");
        Assert.isAssignable(attribute.getClass(), RrdGraphAttribute.class, (String)"attribute argument must be assignable to RrdGraphAttribute");
        RrdGraphAttribute rrdAttribute = (RrdGraphAttribute)attribute;
        File rrdFile = new File(this.m_rrdBaseDirectory, rrdAttribute.getRrdRelativePath());
        try {
            return this.m_rrdStrategy.fetchLastValueInRange(rrdFile.getAbsolutePath(), attribute.getName(), interval, range);
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Failure to fetch last value from file '" + rrdFile + "' with interval " + interval + " and range " + range, (Throwable)e);
        }
    }
}

