/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.opennms.netmgt.dao.OnmsDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDaoHibernate<T, K extends Serializable>
extends HibernateDaoSupport
implements OnmsDao<T, K> {
    Class<T> m_entityClass;

    public AbstractDaoHibernate(Class<T> entityClass) {
        this.m_entityClass = entityClass;
    }

    @Override
    public void initialize(Object obj) {
        this.getHibernateTemplate().initialize(obj);
    }

    @Override
    public void flush() {
        this.getHibernateTemplate().flush();
    }

    @Override
    public void clear() {
        this.getHibernateTemplate().clear();
    }

    public void evict(T entity) {
        this.getHibernateTemplate().evict(entity);
    }

    public void merge(T entity) {
        this.getHibernateTemplate().merge(entity);
    }

    public List<T> find(String query) {
        return this.getHibernateTemplate().find(query);
    }

    public List<T> find(String query, Object ... values) {
        return this.getHibernateTemplate().find(query, values);
    }

    public <S> List<S> findObjects(Class<S> clazz, String query, Object ... values) {
        return this.getHibernateTemplate().find(query, values);
    }

    protected int queryInt(final String query) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery(query).uniqueResult();
            }
        };
        Object result = this.getHibernateTemplate().execute(callback);
        return ((Number)result).intValue();
    }

    protected int queryInt(final String queryString, final Object ... args) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                for (int i = 0; i < args.length; ++i) {
                    query.setParameter(i, args[i]);
                }
                return query.uniqueResult();
            }
        };
        Object result = this.getHibernateTemplate().execute(callback);
        return ((Number)result).intValue();
    }

    protected T findUnique(final String query) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery(query).uniqueResult();
            }
        };
        Object result = this.getHibernateTemplate().execute(callback);
        return this.m_entityClass.cast(result);
    }

    protected T findUnique(final String queryString, final Object ... args) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                for (int i = 0; i < args.length; ++i) {
                    query.setParameter(i, args[i]);
                }
                return query.uniqueResult();
            }
        };
        Object result = this.getHibernateTemplate().execute(callback);
        return this.m_entityClass.cast(result);
    }

    @Override
    public int countAll() {
        return this.queryInt("select count(*) from " + this.m_entityClass.getName());
    }

    @Override
    public void delete(T entity) {
        this.getHibernateTemplate().delete(entity);
    }

    @Override
    public List<T> findAll() {
        return this.getHibernateTemplate().loadAll(this.m_entityClass);
    }

    @Override
    public List<T> findMatching(final OnmsCriteria onmsCrit) {
        onmsCrit.resultsOfType(this.m_entityClass);
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria attachedCrit = onmsCrit.getDetachedCriteria().getExecutableCriteria(session);
                if (onmsCrit.getFirstResult() != null) {
                    attachedCrit.setFirstResult(onmsCrit.getFirstResult().intValue());
                }
                if (onmsCrit.getMaxResults() != null) {
                    attachedCrit.setMaxResults(onmsCrit.getMaxResults().intValue());
                }
                return attachedCrit.list();
            }
        };
        return this.getHibernateTemplate().executeFind(callback);
    }

    @Override
    public T get(K id) {
        return this.m_entityClass.cast(this.getHibernateTemplate().get(this.m_entityClass, id));
    }

    @Override
    public T load(K id) {
        return this.m_entityClass.cast(this.getHibernateTemplate().load(this.m_entityClass, id));
    }

    @Override
    public void save(T entity) {
        this.getHibernateTemplate().save(entity);
    }

    @Override
    public void saveOrUpdate(T entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    @Override
    public void update(T entity) {
        this.getHibernateTemplate().update(entity);
    }
}

