/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.castor.CastorExceptionTranslator;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.dao.support.FileReloadCallback;
import org.opennms.netmgt.dao.support.FileReloadContainer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCastorConfigDao<K, V>
implements InitializingBean {
    private static final CastorExceptionTranslator CASTOR_EXCEPTION_TRANSLATOR = new CastorExceptionTranslator();
    private Class<K> m_castorClass;
    private Resource m_configResource;
    private FileReloadContainer<V> m_container;
    private CastorReloadCallback m_callback = new CastorReloadCallback();

    public AbstractCastorConfigDao(Class<K> entityClass) {
        this.m_castorClass = entityClass;
    }

    public abstract V translateConfig(K var1);

    protected Category log() {
        return ThreadCategory.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V loadConfig(Resource resource) {
        V config;
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(resource.getInputStream());
        }
        catch (IOException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("opening XML configuration file for resource '" + resource + "'", e);
        }
        try {
            this.log().debug((Object)"loading configuration");
            K castorConfig = CastorUtils.unmarshalWithTranslatedExceptions(this.m_castorClass, reader);
            config = this.translateConfig(castorConfig);
            this.log().debug((Object)"configuration loaded");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return config;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_configResource != null ? 1 : 0) != 0, (String)"property configResource must be set and be non-null");
        V config = this.loadConfig(this.m_configResource);
        this.m_container = new FileReloadContainer<V>(config, this.m_configResource, this.m_callback);
    }

    public Resource getConfigResource() {
        return this.m_configResource;
    }

    public void setConfigResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    protected FileReloadContainer<V> getContainer() {
        return this.m_container;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CastorReloadCallback
    implements FileReloadCallback<V> {
        @Override
        public V reload(V object, Resource resource) {
            return AbstractCastorConfigDao.this.loadConfig(resource);
        }
    }
}

