/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.IncludeURL;
import org.opennms.netmgt.config.collectd.ExcludeRange;
import org.opennms.netmgt.config.collectd.IncludeRange;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.filter.FilterDaoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectdPackage {
    private Package m_pkg;
    private List<String> m_ipList;
    private List<IncludeURL> m_includeURLs;

    public CollectdPackage(Package pkg, String localServer, boolean verifyServer) {
        this.m_pkg = pkg;
        this.m_includeURLs = new LinkedList<IncludeURL>();
        this.createIpList(localServer, verifyServer);
        this.createIncludeURLs(pkg);
    }

    private void createIncludeURLs(Package pkg) {
        Enumeration urlEnum = pkg.enumerateIncludeUrl();
        while (urlEnum.hasMoreElements()) {
            this.m_includeURLs.add(new IncludeURL((String)urlEnum.nextElement()));
        }
    }

    public Package getPackage() {
        return this.m_pkg;
    }

    public boolean serviceInPackageAndEnabled(String svcName) {
        Package pkg = this.getPackage();
        boolean result = false;
        Enumeration esvcs = pkg.enumerateService();
        while (!result && esvcs.hasMoreElements()) {
            String status;
            Service tsvc = (Service)esvcs.nextElement();
            if (!tsvc.getName().equalsIgnoreCase(svcName) || !(status = tsvc.getStatus()).equals("on")) continue;
            result = true;
        }
        return result;
    }

    boolean hasSpecific(long addr) {
        Package pkg = this.getPackage();
        boolean has_specific = false;
        Enumeration espec = pkg.enumerateSpecific();
        while (!has_specific && espec.hasMoreElements()) {
            long speca = IPSorter.convertToLong((String)espec.nextElement().toString());
            if (speca != addr) continue;
            has_specific = true;
        }
        return has_specific;
    }

    public boolean hasIncludeRange(long addr) {
        Package pkg = this.getPackage();
        boolean has_range_include = pkg.getIncludeRangeCount() == 0;
        Enumeration eincs = pkg.enumerateIncludeRange();
        while (!has_range_include && eincs.hasMoreElements()) {
            IncludeRange rng = (IncludeRange)eincs.nextElement();
            long start = IPSorter.convertToLong((String)rng.getBegin());
            if (addr > start) {
                long end = IPSorter.convertToLong((String)rng.getEnd());
                if (addr > end) continue;
                has_range_include = true;
                continue;
            }
            if (addr != start) continue;
            has_range_include = true;
        }
        return has_range_include;
    }

    public String getName() {
        return this.m_pkg.getName();
    }

    boolean hasExcludeRange(long addr, boolean has_specific) {
        Package pkg = this.getPackage();
        boolean has_range_exclude = false;
        Enumeration eex = pkg.enumerateExcludeRange();
        while (!has_range_exclude && !has_specific && eex.hasMoreElements()) {
            ExcludeRange rng = (ExcludeRange)eex.nextElement();
            long start = IPSorter.convertToLong((String)rng.getBegin());
            if (addr > start) {
                long end = IPSorter.convertToLong((String)rng.getEnd());
                if (addr > end) continue;
                has_range_exclude = true;
                continue;
            }
            if (addr != start) continue;
            has_range_exclude = true;
        }
        return has_range_exclude;
    }

    public void putIpList(List<String> ipList) {
        this.m_ipList = ipList;
    }

    public List<String> getIpList() {
        return this.m_ipList;
    }

    boolean interfaceInFilter(String iface) {
        boolean filterPassed = false;
        List<String> ipList = this.getIpList();
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(iface);
        } else {
            this.log().debug((Object)"interfaceInFilter: ipList contains no data");
        }
        if (!filterPassed) {
            this.log().debug((Object)("interfaceInFilter: Interface " + iface + " passed filter for package " + this.getName() + "?: false"));
        }
        return filterPassed;
    }

    Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public List<IncludeURL> getIncludeURLs() {
        return this.m_includeURLs;
    }

    boolean hasSpecificUrl(String iface, boolean has_specific) {
        Iterator<IncludeURL> it = this.getIncludeURLs().iterator();
        while (it.hasNext() && !has_specific) {
            IncludeURL includeURL = it.next();
            has_specific = includeURL.interfaceInUrl(iface);
        }
        return has_specific;
    }

    public boolean interfaceInPackage(String iface) {
        boolean packagePassed;
        boolean filterPassed = this.interfaceInFilter(iface);
        if (!filterPassed) {
            return false;
        }
        long addr = IPSorter.convertToLong((String)iface);
        boolean has_range_include = this.hasIncludeRange(addr);
        boolean has_specific = this.hasSpecific(addr);
        has_specific = this.hasSpecificUrl(iface, has_specific);
        boolean has_range_exclude = this.hasExcludeRange(addr, has_specific);
        boolean bl = packagePassed = has_specific || has_range_include && !has_range_exclude;
        if (packagePassed) {
            this.log().info((Object)("interfaceInPackage: Interface " + iface + " passed filter and specific/range for package " + this.getName() + "?: " + packagePassed));
        } else {
            this.log().debug((Object)("interfaceInPackage: Interface " + iface + " passed filter and specific/range for package " + this.getName() + "?: " + packagePassed));
        }
        return packagePassed;
    }

    String getFilterRule(String localServer, boolean verifyServer) {
        Package pkg = this.getPackage();
        String filter = pkg.getFilter().getContent();
        StringBuffer filterRules = new StringBuffer(filter);
        if (verifyServer) {
            filterRules.append(" & (serverName == ");
            filterRules.append('\"');
            filterRules.append(localServer);
            filterRules.append('\"');
            filterRules.append(")");
        }
        return filterRules.toString();
    }

    void createIpList(String localServer, boolean verifyServer) {
        Package pkg = this.getPackage();
        String filterRules = this.getFilterRule(localServer, verifyServer);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("createPackageIpMap: package is " + pkg.getName() + ". filer rules are  " + filterRules));
        }
        try {
            List<String> ipList = FilterDaoFactory.getInstance().getIPList(filterRules);
            if (ipList.size() > 0) {
                this.putIpList(ipList);
            }
        }
        catch (Throwable t) {
            this.log().error((Object)("createPackageIpMap: failed to map package: " + pkg.getName() + " to an IP List: " + t), t);
        }
    }

    public Service getService(String svcName) {
        ArrayList pkgSvcs = this.m_pkg.getServiceCollection();
        for (Service svc : pkgSvcs) {
            if (!svc.getName().equalsIgnoreCase(svcName)) continue;
            return svc;
        }
        throw new RuntimeException("Service name not part of package!");
    }

    public String storeByIfAlias() {
        return this.getPackage().getStoreByIfAlias();
    }

    public String ifAliasComment() {
        return this.getPackage().getIfAliasComment();
    }

    public String getStorFlagOverride() {
        return this.getPackage().getStorFlagOverride();
    }

    public String ifAliasDomain() {
        return this.getPackage().getIfAliasDomain();
    }

    public String storeByNodeId() {
        return this.getPackage().getStoreByNodeID();
    }
}

