/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.ClosableDataSource;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C3P0ConnectionFactory
implements ClosableDataSource {
    private ComboPooledDataSource m_pool;
    private String m_user;
    private String m_password;
    private String m_url;
    private String m_className;
    private Database m_database;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C3P0ConnectionFactory(String configFile) throws IOException, MarshalException, ValidationException, PropertyVetoException, SQLException {
        Class<Database> dsc = Database.class;
        FileInputStream fileInputStream = new FileInputStream(configFile);
        try {
            InputSource dbIn = new InputSource(fileInputStream);
            dbIn.setSystemId(configFile);
            this.m_database = (Database)Unmarshaller.unmarshal(dsc, (InputSource)dbIn);
            Param[] params = this.m_database.getDatabaseChoice().getDriver().getParam();
            for (Param param : Arrays.asList(params)) {
                if (param.getName().equals("user")) {
                    this.m_user = param.getValue();
                    continue;
                }
                if (!param.getName().equals("password")) continue;
                this.m_password = param.getValue();
            }
            this.initializePool();
        }
        finally {
            fileInputStream.close();
        }
    }

    private void initializePool() throws PropertyVetoException, SQLException {
        this.m_pool = new ComboPooledDataSource();
        this.m_pool.setPassword(this.m_password);
        this.m_pool.setUser(this.m_user);
        this.m_url = this.m_database.getDatabaseChoice().getDriver().getUrl();
        this.m_pool.setJdbcUrl(this.m_url);
        this.m_className = this.m_database.getDatabaseChoice().getDriver().getClassName();
        this.m_pool.setDriverClass(this.m_className);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_pool.getConnection();
    }

    public ComboPooledDataSource getPool() {
        return this.m_pool;
    }

    public void setPool(ComboPooledDataSource pool) {
        this.m_pool = pool;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public DataSource getDataSource() {
        return this.m_pool;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_pool.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_pool.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_pool.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_pool.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_pool.getLoginTimeout();
    }

    @Override
    public void close() throws SQLException {
        this.m_pool.close();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

