/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="categories")
public class OnmsCategory
implements Serializable,
Comparable<OnmsCategory> {
    private static final long serialVersionUID = 4694348093332239377L;
    private Integer m_id;
    private String m_name;
    private String m_description;

    public OnmsCategory(String name, String descr) {
        this.m_name = name;
        this.m_description = descr;
    }

    public OnmsCategory() {
    }

    public OnmsCategory(String name) {
        this();
        this.setName(name);
    }

    @Id
    @Column(name="categoryid")
    @SequenceGenerator(name="categorySequence", sequenceName="catNxtId")
    @GeneratedValue(generator="categorySequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Column(name="categoryName", unique=true, nullable=false)
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Column(name="categoryDescription")
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("name", (Object)this.getName()).append("description", (Object)this.getDescription()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OnmsCategory) {
            OnmsCategory t = (OnmsCategory)obj;
            return this.m_name.equals(t.m_name);
        }
        return false;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    @Override
    public int compareTo(OnmsCategory o) {
        return this.m_name.compareToIgnoreCase(o.m_name);
    }
}

