/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.ip;

public final class OC16ChecksumProducer {
    private int m_cksum = 0;
    private boolean m_finalized = false;

    private static int byteToInt(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    private static int shortToInt(short s) {
        if (s < 0) {
            return s + 65536;
        }
        return s;
    }

    private void finalizeSum() {
        if ((this.m_cksum & 0xFFFF0000) != 0) {
            this.m_cksum = (this.m_cksum >> 16 & 0xFFFF) + (this.m_cksum & 0xFFFF);
            this.m_cksum += this.m_cksum >>> 16;
        }
        this.m_finalized = true;
    }

    public void add(byte b) {
        this.add(b, (byte)0);
    }

    public void add(byte a, byte b) {
        this.m_cksum += OC16ChecksumProducer.byteToInt(a) << 8 | OC16ChecksumProducer.byteToInt(b);
        this.m_finalized = false;
    }

    public void add(short s) {
        this.m_cksum += OC16ChecksumProducer.shortToInt(s);
        this.m_finalized = false;
    }

    public void add(int i) {
        this.m_cksum += i >> 16 & 0xFFFF;
        this.m_cksum += i & 0xFFFF;
        this.m_finalized = false;
    }

    public void add(long l) {
        this.m_cksum += (int)(l >> 48) & 0xFFFF;
        this.m_cksum += (int)(l >> 32) & 0xFFFF;
        this.m_cksum += (int)(l >> 16) & 0xFFFF;
        this.m_cksum += (int)l & 0xFFFF;
        this.m_finalized = false;
    }

    public void reset() {
        this.m_cksum = 0;
        this.m_finalized = false;
    }

    public short getChecksum() {
        if (!this.m_finalized) {
            this.finalizeSum();
        }
        return (short)(~this.m_cksum & 0xFFFF);
    }
}

