/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.opennms.netmgt.ping.Packet;

public final class Reply {
    private final InetAddress m_address;
    private final Packet m_packet;

    private Reply(InetAddress addr, Packet pkt) {
        this.m_packet = pkt;
        this.m_address = addr;
    }

    public boolean isEchoReply() {
        return this.m_packet.isEchoReply();
    }

    public final short getIdentity() {
        return this.m_packet.getIdentity();
    }

    public final InetAddress getAddress() {
        return this.m_address;
    }

    public final Packet getPacket() {
        return this.m_packet;
    }

    public static Reply create(DatagramPacket packet) {
        if (packet.getData().length != Packet.getNetworkSize()) {
            throw new IllegalArgumentException("The packet is not the correct network size");
        }
        Packet pkt = new Packet(packet.getData());
        if (pkt.getReceivedTime() == 0L) {
            pkt.setReceivedTime();
        }
        return new Reply(packet.getAddress(), pkt);
    }
}

