/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer.operations;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.IfSnmpCollector;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.importer.operations.AbstractImportOperation;
import org.opennms.netmgt.importer.operations.SaveOrUpdateOperation;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSaveOrUpdateOperation
extends AbstractImportOperation
implements SaveOrUpdateOperation {
    private OnmsNode m_node = new OnmsNode();
    private NodeDao m_nodeDao;
    private DistPollerDao m_distPollerDao;
    private OnmsIpInterface m_currentInterface;
    private ServiceTypeDao m_svcTypeDao;
    private CategoryDao m_categoryDao;
    private ThreadLocal<HashMap<String, OnmsServiceType>> m_types;
    private ThreadLocal<HashMap<String, OnmsCategory>> m_categories;
    private IfSnmpCollector m_collector;

    public AbstractSaveOrUpdateOperation(String foreignSource, String foreignId, String nodeLabel, String building, String city) {
        this(null, foreignSource, foreignId, nodeLabel, building, city);
    }

    public AbstractSaveOrUpdateOperation(Integer nodeId, String foreignSource, String foreignId, String nodeLabel, String building, String city) {
        this.m_node.setId(nodeId);
        this.m_node.setLabel(nodeLabel);
        this.m_node.setLabelSource("U");
        this.m_node.setType("A");
        this.m_node.setForeignSource(foreignSource);
        this.m_node.setForeignId(foreignId);
        this.m_node.getAssetRecord().setBuilding(building);
        this.m_node.getAssetRecord().setCity(city);
    }

    @Override
    public void foundInterface(String ipAddr, Object descr, String snmpPrimary, boolean managed, int status) {
        if ("".equals(ipAddr)) {
            this.log().error((Object)("Found interface on node " + this.m_node.getLabel() + " with an empty ipaddr! Ignoring!"));
            this.m_currentInterface = new OnmsIpInterface();
            return;
        }
        this.m_currentInterface = new OnmsIpInterface(ipAddr, this.m_node);
        this.m_currentInterface.setIsManaged(status == 3 ? "U" : "M");
        this.m_currentInterface.setIsSnmpPrimary(OnmsIpInterface.CollectionType.get((String)snmpPrimary));
        this.m_currentInterface.setIpStatus(status == 3 ? new Integer(3) : new Integer(1));
        if ("P".equals(snmpPrimary)) {
            try {
                this.m_collector = new IfSnmpCollector(InetAddress.getByName(ipAddr));
            }
            catch (UnknownHostException e) {
                this.log().error((Object)("Unable to resolve address of snmpPrimary interface for node " + this.m_node.getLabel()), (Throwable)e);
            }
        }
        this.m_node.addIpInterface(this.m_currentInterface);
    }

    @Override
    public void gatherAdditionalData() {
        this.updateSnmpData();
    }

    @Override
    public List persist() {
        return this.doPersist();
    }

    protected abstract List doPersist();

    protected void updateSnmpData() {
        if (this.m_collector != null) {
            this.m_collector.run();
        }
        this.updateSnmpDataForNode();
        for (OnmsIpInterface ipIf : this.m_node.getIpInterfaces()) {
            this.resolveIpHostname(ipIf);
            this.updateSnmpDataForInterface(ipIf);
        }
    }

    private void updateSnmpDataForNode() {
        if (this.m_collector != null && this.m_collector.hasSystemGroup()) {
            this.m_node.setSysContact(this.m_collector.getSystemGroup().getSysContact());
            this.m_node.setSysDescription(this.m_collector.getSystemGroup().getSysDescr());
            this.m_node.setSysLocation(this.m_collector.getSystemGroup().getSysLocation());
            this.m_node.setSysObjectId(this.m_collector.getSystemGroup().getSysObjectID());
        }
    }

    protected boolean isSnmpDataForNodeUpToDate() {
        return this.m_collector != null && this.m_collector.hasSystemGroup();
    }

    protected boolean isSnmpDataForInterfacesUpToDate() {
        return this.m_collector != null && this.m_collector.hasIfTable() && this.m_collector.hasIpAddrTable();
    }

    private void updateSnmpDataForInterface(OnmsIpInterface ipIf) {
        if (this.m_collector == null || !this.m_collector.hasIpAddrTable() || !this.m_collector.hasIfTable()) {
            return;
        }
        String ipAddr = ipIf.getIpAddress();
        this.log().debug((Object)("Creating SNMP info for interface " + ipAddr));
        InetAddress inetAddr = ipIf.getInetAddress();
        int ifIndex = this.m_collector.getIfIndex(inetAddr);
        if (ifIndex == -1) {
            return;
        }
        OnmsSnmpInterface snmpIf = new OnmsSnmpInterface(ipAddr, new Integer(ifIndex), this.m_node);
        snmpIf.setIfAlias(this.m_collector.getIfAlias(ifIndex));
        snmpIf.setIfName(this.m_collector.getIfName(ifIndex));
        snmpIf.setIfType(this.getIfType(ifIndex));
        snmpIf.setNetMask(this.getNetMask(ifIndex));
        snmpIf.setIfAdminStatus(this.getAdminStatus(ifIndex));
        snmpIf.setIfDescr(this.m_collector.getIfDescr(ifIndex));
        snmpIf.setIfSpeed(this.m_collector.getIfSpeed(ifIndex));
        snmpIf.setPhysAddr(this.m_collector.getPhysAddr(ifIndex));
        ipIf.setSnmpInterface(snmpIf);
    }

    private Integer getAdminStatus(int ifIndex) {
        int adminStatus = this.m_collector.getAdminStatus(ifIndex);
        return adminStatus == -1 ? null : new Integer(adminStatus);
    }

    private Integer getIfType(int ifIndex) {
        int ifType = this.m_collector.getIfType(ifIndex);
        return ifType == -1 ? null : new Integer(ifType);
    }

    private String getNetMask(int ifIndex) {
        InetAddress[] ifAddressAndMask = this.m_collector.getIfAddressAndMask(ifIndex);
        if (ifAddressAndMask != null && ifAddressAndMask.length > 1 && ifAddressAndMask[1] != null) {
            return ifAddressAndMask[1].getHostAddress();
        }
        return null;
    }

    private void resolveIpHostname(OnmsIpInterface ipIf) {
        ipIf.setIpHostName(ipIf.getIpAddress());
    }

    @Override
    public void foundMonitoredService(String serviceName) {
        OnmsServiceType svcType = this.getServiceType(serviceName);
        OnmsMonitoredService service = new OnmsMonitoredService(this.m_currentInterface, svcType);
        service.setStatus("A");
        this.m_currentInterface.getMonitoredServices().add(service);
    }

    @Override
    public void foundCategory(String name) {
        OnmsCategory category = this.getCategory(name);
        this.m_node.getCategories().add(category);
    }

    private OnmsServiceType getServiceType(String serviceName) {
        this.preloadExistingTypes();
        OnmsServiceType type = this.getTypes().get(serviceName);
        if (type == null) {
            type = this.m_svcTypeDao.findByName(serviceName);
            if (type == null) {
                type = new OnmsServiceType(serviceName);
                this.m_svcTypeDao.save((Object)type);
            }
            this.getTypes().put(serviceName, type);
        }
        return type;
    }

    private void preloadExistingTypes() {
        if (this.getTypes() == null) {
            this.setTypes(new HashMap<String, OnmsServiceType>());
            for (OnmsServiceType svcType : this.m_svcTypeDao.findAll()) {
                this.getTypes().put(svcType.getName(), svcType);
            }
        }
    }

    private void preloadExistingCategories() {
        if (this.getCategories() == null) {
            this.setCategories(new HashMap<String, OnmsCategory>());
            for (OnmsCategory category : this.m_categoryDao.findAll()) {
                this.getCategories().put(category.getName(), category);
            }
        }
    }

    protected OnmsNode getNode() {
        return this.m_node;
    }

    protected NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    protected DistPollerDao getDistPollerDao() {
        return this.m_distPollerDao;
    }

    private OnmsCategory getCategory(String name) {
        this.preloadExistingCategories();
        OnmsCategory category = this.getCategories().get(name);
        if (category == null) {
            category = this.m_categoryDao.findByName(name);
            if (category == null) {
                category = new OnmsCategory(name);
                this.m_categoryDao.save((Object)category);
            }
            this.getCategories().put(category.getName(), category);
        }
        return category;
    }

    protected Map<String, OnmsIpInterface> getIpAddrToInterfaceMap(OnmsNode imported) {
        HashMap<String, OnmsIpInterface> ipAddrToIface = new HashMap<String, OnmsIpInterface>();
        for (OnmsIpInterface iface : imported.getIpInterfaces()) {
            ipAddrToIface.put(iface.getIpAddress(), iface);
        }
        return ipAddrToIface;
    }

    private HashMap<String, OnmsServiceType> getTypes() {
        return this.m_types.get();
    }

    private void setTypes(HashMap<String, OnmsServiceType> types) {
        this.m_types.set(types);
    }

    private void setCategories(HashMap<String, OnmsCategory> categories) {
        this.m_categories.set(categories);
    }

    private HashMap<String, OnmsCategory> getCategories() {
        return this.m_categories.get();
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public void setServiceTypeDao(ServiceTypeDao svcTypeDao) {
        this.m_svcTypeDao = svcTypeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = distPollerDao;
    }

    public void setTypeCache(ThreadLocal<HashMap<String, OnmsServiceType>> typeCache) {
        this.m_types = typeCache;
    }

    public void setCategoryCache(ThreadLocal<HashMap<String, OnmsCategory>> categoryCache) {
        this.m_categories = categoryCache;
    }

    protected Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public boolean nullSafeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

