/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.FormField;

public class DataForm
implements PacketExtension {
    private String type;
    private String title;
    private List instructions = new ArrayList();
    private ReportedData reportedData;
    private List items = new ArrayList();
    private List fields = new ArrayList();

    public DataForm(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getInstructions() {
        List list = this.instructions;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.instructions)).iterator();
        }
    }

    public ReportedData getReportedData() {
        return this.reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getItems() {
        List list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.items)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getFields() {
        List list = this.fields;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.fields)).iterator();
        }
    }

    public String getElementName() {
        return "x";
    }

    public String getNamespace() {
        return "jabber:x:data";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInstructions(List instructions) {
        this.instructions = instructions;
    }

    public void setReportedData(ReportedData reportedData) {
        this.reportedData = reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(FormField field) {
        List list = this.fields;
        synchronized (list) {
            this.fields.add(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstruction(String instruction) {
        List list = this.instructions;
        synchronized (list) {
            this.instructions.add(instruction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\" type=\"" + this.getType() + "\">");
        if (this.getTitle() != null) {
            buf.append("<title>").append(this.getTitle()).append("</title>");
        }
        Iterator it = this.getInstructions();
        while (it.hasNext()) {
            buf.append("<instructions>").append(it.next()).append("</instructions>");
        }
        if (this.getReportedData() != null) {
            buf.append(this.getReportedData().toXML());
        }
        Iterator i = this.getItems();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            buf.append(item.toXML());
        }
        i = this.getFields();
        while (i.hasNext()) {
            FormField field = (FormField)i.next();
            buf.append(field.toXML());
        }
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    public static class Item {
        private List fields = new ArrayList();

        public Item(List fields) {
            this.fields = fields;
        }

        public Iterator getFields() {
            return Collections.unmodifiableList(new ArrayList(this.fields)).iterator();
        }

        public String toXML() {
            StringBuffer buf = new StringBuffer();
            buf.append("<item>");
            Iterator i = this.getFields();
            while (i.hasNext()) {
                FormField field = (FormField)i.next();
                buf.append(field.toXML());
            }
            buf.append("</item>");
            return buf.toString();
        }
    }

    public static class ReportedData {
        private List fields = new ArrayList();

        public ReportedData(List fields) {
            this.fields = fields;
        }

        public Iterator getFields() {
            return Collections.unmodifiableList(new ArrayList(this.fields)).iterator();
        }

        public String toXML() {
            StringBuffer buf = new StringBuffer();
            buf.append("<reported>");
            Iterator i = this.getFields();
            while (i.hasNext()) {
                FormField field = (FormField)i.next();
                buf.append(field.toXML());
            }
            buf.append("</reported>");
            return buf.toString();
        }
    }
}

