/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.Iterator;
import java.util.Stack;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;

public class CommonTreeNodeStream
implements TreeNodeStream,
Iterator {
    public static final int INITIAL_LOOKAHEAD_BUFFER_SIZE = 20;
    public static final DummyTree DOWN = new DummyTree(){

        public int getType() {
            return 2;
        }

        public String toString() {
            return "DOWN";
        }
    };
    public static final DummyTree UP = new DummyTree(){

        public int getType() {
            return 3;
        }

        public String toString() {
            return "UP";
        }
    };
    public static final DummyTree EOF_NODE = new DummyTree(){

        public int getType() {
            return -1;
        }

        public String toString() {
            return "EOF";
        }
    };
    protected Tree root;
    protected Stack nodeStack = new Stack();
    protected Stack indexStack = new Stack();
    protected Tree currentNode;
    protected Tree previousNode;
    protected int currentChildIndex;
    protected Tree[] lookahead = new Tree[20];
    protected int head;
    protected int tail;
    protected int absoluteNodeIndex = -1;

    public CommonTreeNodeStream(Tree tree) {
        this.root = tree;
        this.reset();
    }

    public void reset() {
        this.currentNode = this.root;
        this.previousNode = null;
        this.currentChildIndex = -1;
    }

    public Object LT(int n) {
        if (n == -1) {
            return this.previousNode;
        }
        if (n == 0) {
            return Tree.INVALID_NODE;
        }
        this.fill(n);
        return this.lookahead[(this.head + n - 1) % this.lookahead.length];
    }

    public Object getTreeSource() {
        return this.root;
    }

    protected void fill(int n) {
        int n2 = this.tail < this.head ? this.lookahead.length - this.head + this.tail : this.tail - this.head;
        for (int i = 1; i <= n - n2; ++i) {
            this.next();
        }
    }

    protected void addLookahead(Tree tree) {
        this.lookahead[this.tail] = tree;
        this.tail = (this.tail + 1) % this.lookahead.length;
        if (this.tail == this.head) {
            Tree[] treeArray = new Tree[2 * this.lookahead.length];
            int n = this.lookahead.length - this.head;
            System.arraycopy(this.lookahead, this.head, treeArray, 0, n);
            System.arraycopy(this.lookahead, 0, treeArray, n, this.tail);
            this.lookahead = treeArray;
            this.head = 0;
            this.tail += n;
        }
    }

    public void consume() {
        ++this.absoluteNodeIndex;
        this.previousNode = this.lookahead[this.head];
        this.head = (this.head + 1) % this.lookahead.length;
    }

    public int LA(int n) {
        Tree tree = (Tree)this.LT(n);
        if (tree == null) {
            return 0;
        }
        return tree.getType();
    }

    public int mark() {
        throw new NoSuchMethodError("can't rewind trees yet");
    }

    public void release(int n) {
        throw new NoSuchMethodError("can't rewind trees yet");
    }

    public int index() {
        return this.absoluteNodeIndex;
    }

    public void rewind(int n) {
        throw new NoSuchMethodError("can't rewind trees yet");
    }

    public void seek(int n) {
        throw new NoSuchMethodError("can't seek trees yet");
    }

    public int size() {
        return this.absoluteNodeIndex + 1;
    }

    public boolean hasNext() {
        return this.currentNode != null;
    }

    public Object next() {
        if (this.currentNode == null) {
            this.addLookahead(EOF_NODE);
            return null;
        }
        if (this.currentChildIndex == -1) {
            return this.handleRootNode();
        }
        if (this.currentChildIndex < this.currentNode.getChildCount()) {
            return this.visitChild(this.currentChildIndex);
        }
        this.walkBackToMostRecentNodeWithUnvisitedChildren();
        if (this.currentNode != null) {
            return this.visitChild(this.currentChildIndex);
        }
        return null;
    }

    protected Tree handleRootNode() {
        Tree tree = this.currentNode;
        this.currentChildIndex = 0;
        if (tree.isNil()) {
            tree = this.visitChild(this.currentChildIndex);
        } else {
            this.addLookahead(tree);
            if (this.currentNode.getChildCount() == 0) {
                this.currentNode = null;
            }
        }
        return tree;
    }

    protected Tree visitChild(int n) {
        Tree tree = null;
        this.nodeStack.push(this.currentNode);
        this.indexStack.push(new Integer(n));
        if (n == 0 && !this.currentNode.isNil()) {
            this.addNavigationNode(2);
        }
        this.currentNode = this.currentNode.getChild(n);
        this.currentChildIndex = 0;
        tree = this.currentNode;
        this.addLookahead(tree);
        this.walkBackToMostRecentNodeWithUnvisitedChildren();
        return tree;
    }

    protected void addNavigationNode(final int n) {
        if (this.currentNode instanceof CommonTree) {
            DummyTree dummyTree = new DummyTree(){

                public int getType() {
                    return n;
                }

                public String toString() {
                    if (n == 2) {
                        return "DOWN";
                    }
                    return "UP";
                }
            };
            dummyTree.line = this.currentNode.getLine();
            dummyTree.charPositionInLine = this.currentNode.getCharPositionInLine();
            this.addLookahead(dummyTree);
        } else if (n == 2) {
            this.addLookahead(DOWN);
        } else {
            this.addLookahead(UP);
        }
    }

    protected void walkBackToMostRecentNodeWithUnvisitedChildren() {
        while (this.currentNode != null && this.currentChildIndex >= this.currentNode.getChildCount()) {
            this.currentNode = (Tree)this.nodeStack.pop();
            this.currentChildIndex = (Integer)this.indexStack.pop();
            ++this.currentChildIndex;
            if (this.currentChildIndex < this.currentNode.getChildCount()) continue;
            if (!this.currentNode.isNil()) {
                this.addNavigationNode(3);
            }
            if (this.currentNode != this.root) continue;
            this.currentNode = null;
        }
    }

    public void remove() {
    }

    public String toNodesOnlyString() {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.hasNext()) {
            CommonTree commonTree = (CommonTree)this.next();
            stringBuffer.append(" ");
            stringBuffer.append(commonTree.getType());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= this.lookahead.length; ++i) {
            Object object = this.LT(i);
            if (object == null) continue;
            stringBuffer.append(" ");
            stringBuffer.append(((Tree)object).getType());
        }
        return stringBuffer.toString();
    }

    public String toString(Object object, Object object2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringWork((Tree)object, (Tree)object2, stringBuffer);
        return stringBuffer.toString();
    }

    protected void toStringWork(Tree tree, Tree tree2, StringBuffer stringBuffer) {
        if (!tree.isNil()) {
            stringBuffer.append(((Object)tree).toString());
        }
        if (tree == tree2) {
            return;
        }
        int n = tree.getChildCount();
        for (int i = 0; i < n; ++i) {
            Tree tree3 = tree.getChild(i);
            this.toStringWork(tree3, tree2, stringBuffer);
        }
    }

    protected static abstract class DummyTree
    implements Tree {
        int line;
        int charPositionInLine;

        protected DummyTree() {
        }

        public Tree getChild(int n) {
            return null;
        }

        public int getChildCount() {
            return 0;
        }

        public void addChild(Tree tree) {
        }

        public boolean isNil() {
            return false;
        }

        public Tree dupTree() {
            return null;
        }

        public Tree dupNode() {
            return null;
        }

        public int getLine() {
            return this.line;
        }

        public int getCharPositionInLine() {
            return this.charPositionInLine;
        }

        public String toStringTree() {
            return null;
        }
    }
}

