/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.mortbay.io.tx.Handler;
import org.mortbay.io.tx.Transformer;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.JarResource;
import org.mortbay.resource.Resource;
import org.mortbay.util.LazyList;

public class TransformingWebAppClassLoader
extends WebAppClassLoader
implements Transformer {
    public TransformingWebAppClassLoader(WebAppContext context) {
        super(null, context);
    }

    public TransformingWebAppClassLoader(ClassLoader parent, WebAppContext context) {
        super(parent, context);
    }

    public void addURL(URL url) {
        try {
            Resource resource = Resource.newResource(url);
            if (!resource.isDirectory() && resource.exists()) {
                String jar = url.getFile();
                int slash = jar.lastIndexOf(47);
                if (slash >= 0) {
                    jar = jar.substring(slash + 1);
                }
                File tmp = File.createTempFile(jar + "-", null, this.getContext().getTempDirectory());
                tmp.delete();
                tmp.mkdir();
                resource = Resource.newResource("jar:" + resource + "!/");
                Log.info((String)("extract " + url + " to " + tmp));
                JarResource.extract(resource, tmp, true);
                url = tmp.toURL();
            }
            url = new URL("tx:" + url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Log.info((String)("transforming " + url));
        super.addURL(url);
    }

    public byte[] transform(URL src, byte[] content) {
        return content;
    }

    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url != null && url.getProtocol().equals("tx")) {
            try {
                url = new URL(url.getFile());
            }
            catch (MalformedURLException e) {
                Log.warn((Throwable)e);
            }
        }
        return url;
    }

    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url != null && url.getProtocol().equals("tx")) {
            try {
                url = new URL(url.getFile());
            }
            catch (MalformedURLException e) {
                Log.warn((Throwable)e);
            }
        }
        return url;
    }

    public Enumeration findResources(String name) throws IOException {
        Enumeration<URL> en = super.findResources(name);
        Object list = null;
        while (en != null && en.hasMoreElements()) {
            URL url = en.nextElement();
            if (url != null && url.getProtocol().equals("tx")) {
                try {
                    url = new URL(url.getFile());
                }
                catch (MalformedURLException e) {
                    Log.warn((Throwable)e);
                }
            }
            list = LazyList.add(list, (Object)url);
        }
        return Collections.enumeration(LazyList.getList(list));
    }

    static {
        Log.info((String)"Register org.mortbay.io.tx  URLStreamHandler");
        Handler.register();
    }
}

