/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.jrmp.interfaces;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.ConnectException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.ServerException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import javax.transaction.SystemException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextUtil;

public class JRMPInvokerProxy
implements Invoker,
Externalizable {
    private static final long serialVersionUID = -3713605626489646730L;
    protected Invoker remoteInvoker;
    public static int MAX_RETRIES = 10;

    public JRMPInvokerProxy() {
    }

    public JRMPInvokerProxy(Invoker remoteInvoker) {
        this.remoteInvoker = remoteInvoker;
    }

    public String getServerHostName() throws Exception {
        return this.remoteInvoker.getServerHostName();
    }

    public Object getTransactionPropagationContext() throws SystemException {
        TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    public Object invoke(Invocation invocation) throws Exception {
        MarshalledInvocation mi = new MarshalledInvocation(invocation);
        mi.setTransactionPropagationContext(this.getTransactionPropagationContext());
        for (int i = 0; i < MAX_RETRIES; ++i) {
            try {
                MarshalledObject result = (MarshalledObject)this.remoteInvoker.invoke(mi);
                return result.get();
            }
            catch (ConnectException ce) {
                if (i + 1 < MAX_RETRIES) {
                    Thread.sleep(1L);
                    continue;
                }
                throw ce;
            }
            catch (ServerException ex) {
                if (ex.detail instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)ex.detail;
                }
                if (ex.detail instanceof TransactionRolledbackException) {
                    throw (TransactionRolledbackException)ex.detail;
                }
                throw ex;
            }
        }
        throw new Exception("Unreachable statement");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.remoteInvoker instanceof RemoteStub) {
            out.writeObject(this.remoteInvoker);
        } else {
            Remote replacement = RemoteObject.toStub(this.remoteInvoker);
            out.writeObject(replacement);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.remoteInvoker = (Invoker)in.readObject();
    }
}

