/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.DynamicIntroductionAdvice;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionInfo;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

public class DefaultIntroductionAdvisor
implements IntroductionAdvisor,
ClassFilter,
Ordered,
Serializable {
    private int order = Integer.MAX_VALUE;
    private Advice advice;
    private Set interfaces = new HashSet();

    public DefaultIntroductionAdvisor(Advice advice) {
        if (advice instanceof IntroductionInfo) {
            this.init(advice, (IntroductionInfo)advice);
        } else {
            this.advice = advice;
        }
    }

    public DefaultIntroductionAdvisor(DynamicIntroductionAdvice advice, Class clazz) {
        this.advice = advice;
        this.addInterface(clazz);
    }

    public DefaultIntroductionAdvisor(Advice advice, IntroductionInfo introductionInfo) {
        this.init(advice, introductionInfo);
    }

    private void init(Advice advice, IntroductionInfo introductionInfo) {
        this.advice = advice;
        Class[] introducedInterfaces = introductionInfo.getInterfaces();
        if (introducedInterfaces.length == 0) {
            throw new IllegalArgumentException("IntroductionAdviceSupport implements no interfaces");
        }
        for (int i = 0; i < introducedInterfaces.length; ++i) {
            this.addInterface(introducedInterfaces[i]);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void addInterface(Class intf) {
        this.interfaces.add(intf);
    }

    public ClassFilter getClassFilter() {
        return this;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public Class[] getInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public boolean isPerInstance() {
        return true;
    }

    public void validateInterfaces() throws IllegalArgumentException {
        Iterator it = this.interfaces.iterator();
        while (it.hasNext()) {
            Class ifc = (Class)it.next();
            if (!ifc.isInterface()) {
                throw new IllegalArgumentException("Class [" + ifc.getName() + "] is not an interface; cannot be used in an introduction");
            }
            if (!(this.advice instanceof DynamicIntroductionAdvice) || ((DynamicIntroductionAdvice)this.advice).implementsInterface(ifc)) continue;
            throw new IllegalArgumentException("IntroductionAdvice [" + this.advice + "] " + "does not implement interface [" + ifc.getName() + "] specified in introduction advice");
        }
    }

    public String toString() {
        return this.getClass().getName() + ": advice [" + this.advice + "]; interfaces " + ClassUtils.classNamesToString((Collection)this.interfaces);
    }
}

