/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AnnotationBinding;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePairBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;

class DefaultValuePairBinding
implements IMemberValuePairBinding {
    private MethodBinding method;
    private Object domValue;
    private BindingResolver bindingResolver;

    static void appendValue(Object value, StringBuffer buffer) {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            buffer.append('{');
            int i = 0;
            int l = values.length;
            while (i < l) {
                if (i != 0) {
                    buffer.append(", ");
                }
                DefaultValuePairBinding.appendValue(values[i], buffer);
                ++i;
            }
            buffer.append('}');
        } else if (value instanceof ITypeBinding) {
            buffer.append(((ITypeBinding)value).getName());
            buffer.append(".class");
        } else {
            buffer.append(value);
        }
    }

    DefaultValuePairBinding(MethodBinding binding, BindingResolver resolver) {
        this.method = binding;
        this.domValue = MemberValuePairBinding.buildDOMValue(binding.getDefaultValue(), resolver);
        this.bindingResolver = resolver;
    }

    public IAnnotationBinding[] getAnnotations() {
        return AnnotationBinding.NoAnnotations;
    }

    public IJavaElement getJavaElement() {
        return null;
    }

    public String getKey() {
        return null;
    }

    public int getKind() {
        return 6;
    }

    public IMethodBinding getMethodBinding() {
        return this.bindingResolver.getMethodBinding(this.method);
    }

    public int getModifiers() {
        return -1;
    }

    public String getName() {
        return new String(this.method.selector);
    }

    public Object getValue() {
        return this.domValue;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isEqualTo(IBinding binding) {
        if (this == binding) {
            return true;
        }
        if (binding.getKind() != 6) {
            return false;
        }
        IMemberValuePairBinding other = (IMemberValuePairBinding)binding;
        if (!this.getMethodBinding().isEqualTo(other.getMethodBinding())) {
            return false;
        }
        Object value = this.getValue();
        if (value == null) {
            return other.getValue() == null;
        }
        return value.equals(other.getValue());
    }

    public boolean isSynthetic() {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuffer buffer) {
        buffer.append(this.getName());
        buffer.append(" = ");
        DefaultValuePairBinding.appendValue(this.getValue(), buffer);
    }
}

