/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.jmx.connectors;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.protocols.jmx.MBeanServerProxy;
import org.opennms.protocols.jmx.connectors.IsolatingClassLoader;
import org.opennms.protocols.jmx.connectors.JBossConnectionWrapper;

public class JBossConnectionFactory {
    static Category log = ThreadCategory.getInstance(JBossConnectionFactory.class);
    static String[] packages = new String[]{"org.jboss.naming.*", "org.jboss.interfaces.*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JBossConnectionWrapper getMBeanServerConnection(Map propertiesMap, InetAddress address) {
        InitialContext ctx;
        JBossConnectionWrapper wrapper = null;
        IsolatingClassLoader icl = null;
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        String connectionType = ParameterMap.getKeyedString(propertiesMap, "factory", "RMI");
        String timeout = ParameterMap.getKeyedString(propertiesMap, "timeout", "3000");
        String jbossVersion = ParameterMap.getKeyedString(propertiesMap, "version", "4");
        String port = ParameterMap.getKeyedString(propertiesMap, "port", "1099");
        if (connectionType == null) {
            log.error((Object)"factory property is not set, check the configuration files.");
            return null;
        }
        if (jbossVersion == null || jbossVersion.startsWith("4")) {
            try {
                icl = new IsolatingClassLoader("jboss", new URL[]{new File(System.getProperty("opennms.home") + "/lib/jboss/jbossall-client.jar").toURL()}, originalLoader, packages, true);
            }
            catch (MalformedURLException e) {
                log.error((Object)"JBossConnectionWrapper MalformedURLException", (Throwable)e);
            }
            catch (IsolatingClassLoader.InvalidContextClassLoaderException e) {
                log.error((Object)"JBossConnectionWrapper InvalidContextClassLoaderException", (Throwable)e);
            }
        } else if (jbossVersion.startsWith("3")) {
            try {
                icl = new IsolatingClassLoader("jboss", new URL[]{new File(System.getProperty("opennms.home") + "/lib/jboss/jbossall-client32.jar").toURL()}, originalLoader, packages, true);
            }
            catch (MalformedURLException e) {
                log.error((Object)"JBossConnectionWrapper MalformedURLException", (Throwable)e);
            }
            catch (IsolatingClassLoader.InvalidContextClassLoaderException e) {
                log.error((Object)"JBossConnectionWrapper InvalidContextClassLoaderException", (Throwable)e);
            }
        }
        if (icl == null) {
            return null;
        }
        Thread.currentThread().setContextClassLoader(icl);
        if (connectionType.equals("RMI")) {
            ctx = null;
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("java.naming.factory.initial", "org.jboss.naming.NamingContextFactory");
                props.put("java.naming.provider.url", "jnp://" + address.getHostAddress() + ":" + port);
                props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                props.put("jnp.sotimeout", timeout);
                ctx = new InitialContext(props);
                Object rmiAdaptor = ctx.lookup("jmx/rmi/RMIAdaptor");
                wrapper = new JBossConnectionWrapper(MBeanServerProxy.buildServerProxy(rmiAdaptor));
            }
            catch (Throwable e) {
                log.debug((Object)("JBossConnectionFactory - unable to get MBeanServer using RMI on " + address.getHostAddress() + ":" + port));
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (Throwable e1) {
                    log.debug((Object)"JBossConnectionFactory error closing initial context");
                }
            }
        } else if (connectionType.equals("HTTP")) {
            ctx = null;
            String invokerSuffix = null;
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("java.naming.factory.initial", "org.jboss.naming.HttpNamingContextFactory");
                props.put("java.naming.provider.url", "http://" + address.getHostAddress() + ":" + port + "/invoker/JNDIFactory");
                props.put("jnp.sotimeout", timeout);
                ctx = new InitialContext(props);
                Object rmiAdaptor = ctx.lookup("jmx/rmi/RMIAdaptor");
                wrapper = new JBossConnectionWrapper(MBeanServerProxy.buildServerProxy(rmiAdaptor));
            }
            catch (Exception e) {
                log.debug((Object)("JBossConnectionFactory - unable to get MBeanServer using HTTP on " + address.getHostAddress() + invokerSuffix));
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e1) {
                    log.debug((Object)"JBossConnectionFactory error closing initial context");
                }
            }
        }
        Thread.currentThread().setContextClassLoader(originalLoader);
        return wrapper;
    }
}

