/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.XmlrpcdConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.xmlrpcd.BroadcastEventProcessor;
import org.opennms.netmgt.xmlrpcd.EventQueueProcessor;

public class Xmlrpcd
extends AbstractServiceDaemon {
    private static final AbstractServiceDaemon m_singleton = new Xmlrpcd();
    private FifoQueue m_eventlogQ;
    private EventQueueProcessor m_processor;
    private BroadcastEventProcessor m_eventReceiver;

    public Xmlrpcd() {
        super("OpenNMS.Xmlrpcd");
    }

    protected void onInit() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"start: Creating the xmlrpc event queue processor");
        }
        this.m_eventlogQ = new FifoQueueImpl();
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"start: Initializing the xmlrpcd config factory");
            }
            XmlrpcdConfigFactory.reload();
            OpennmsServerConfigFactory.reload();
            XmlrpcdConfigFactory xFactory = XmlrpcdConfigFactory.getInstance();
            boolean verifyServer = OpennmsServerConfigFactory.getInstance().verifyServer();
            String localServer = null;
            if (verifyServer) {
                localServer = OpennmsServerConfigFactory.getInstance().getServerName();
            }
            Enumeration eventEnum = xFactory.getEventEnumeration();
            this.m_eventReceiver = new BroadcastEventProcessor(this.m_eventlogQ, xFactory.getMaxQueueSize(), eventEnum);
            this.m_processor = new EventQueueProcessor(this.m_eventlogQ, xFactory.getXmlrpcServer(), xFactory.getRetries(), xFactory.getElapseTime(), verifyServer, localServer, xFactory.getMaxQueueSize());
        }
        catch (MarshalException e) {
            this.log().error((Object)"Failed to load configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().error((Object)"Failed to load configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().error((Object)"Failed to load configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (Throwable t) {
            this.log().error((Object)"Failed to load configuration", t);
        }
    }

    protected void onStart() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"start: Initializing the xmlrpcd config factory");
        }
        this.m_processor.start();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"start: xmlrpcd ready to process events");
        }
    }

    protected void onPause() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Calling pause on processor");
        }
        this.m_processor.pause();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Processor paused");
        }
    }

    protected void onResume() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Calling resume on processor");
        }
        this.m_processor.resume();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Processor resumed");
        }
    }

    protected void onStop() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"exit: closing communication paths.");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"stop: Stopping queue processor.");
        }
        this.m_processor.stop();
    }

    public static AbstractServiceDaemon getInstance() {
        return m_singleton;
    }
}

